/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.gsissh.provider.impl;

import java.util.List;
import java.util.Map;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.gfac.ExecutionMode;
import org.apache.airavata.gfac.GFacException;
import org.apache.airavata.gfac.core.context.JobExecutionContext;
import org.apache.airavata.gfac.core.cpi.BetterGfacImpl;
import org.apache.airavata.gfac.core.cpi.GFacImpl;
import org.apache.airavata.gfac.core.handler.GFacHandlerException;
import org.apache.airavata.gfac.core.handler.ThreadedHandler;
import org.apache.airavata.gfac.core.notification.events.GFacEvent;
import org.apache.airavata.gfac.core.notification.events.StartExecutionEvent;
import org.apache.airavata.gfac.core.provider.AbstractRecoverableProvider;
import org.apache.airavata.gfac.core.provider.GFacProviderException;
import org.apache.airavata.gfac.core.utils.GFacUtils;
import org.apache.airavata.gfac.gsissh.security.GSISecurityContext;
import org.apache.airavata.gfac.gsissh.util.GFACGSISSHUtils;
import org.apache.airavata.gsi.ssh.api.Cluster;
import org.apache.airavata.gsi.ssh.api.SSHApiException;
import org.apache.airavata.gsi.ssh.api.job.JobDescriptor;
import org.apache.airavata.model.workspace.experiment.CorrectiveAction;
import org.apache.airavata.model.workspace.experiment.ErrorCategory;
import org.apache.airavata.model.workspace.experiment.JobDetails;
import org.apache.airavata.model.workspace.experiment.JobState;
import org.apache.airavata.schemas.gfac.ApplicationDeploymentDescriptionType;
import org.apache.airavata.schemas.gfac.GsisshHostType;
import org.apache.airavata.schemas.gfac.HostDescriptionType;
import org.apache.airavata.schemas.gfac.HpcApplicationDeploymentType;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GSISSHProvider
extends AbstractRecoverableProvider {
    private static final Logger log = LoggerFactory.getLogger(GSISSHProvider.class);

    public void initProperties(Map<String, String> properties) throws GFacProviderException, GFacException {
    }

    public void initialize(JobExecutionContext jobExecutionContext) throws GFacProviderException, GFacException {
        super.initialize(jobExecutionContext);
    }

    public void execute(JobExecutionContext jobExecutionContext) throws GFacProviderException, GFacException {
        log.info("Invoking GSISSH Provider Invoke ...");
        StringBuffer data = new StringBuffer();
        jobExecutionContext.getNotifier().publish((GFacEvent)new StartExecutionEvent());
        HostDescriptionType host = jobExecutionContext.getApplicationContext().getHostDescription().getType();
        HpcApplicationDeploymentType app = (HpcApplicationDeploymentType)jobExecutionContext.getApplicationContext().getApplicationDeploymentDescription().getType();
        JobDetails jobDetails = new JobDetails();
        try {
            Cluster cluster = null;
            if (jobExecutionContext.getSecurityContext("gsi") != null) {
                cluster = ((GSISecurityContext)jobExecutionContext.getSecurityContext("gsi")).getPbsCluster();
            }
            if (cluster == null) {
                throw new GFacProviderException("Security context is not set properly");
            }
            log.info("Successfully retrieved the Security Context");
            JobDescriptor jobDescriptor = GFACGSISSHUtils.createJobDescriptor(jobExecutionContext, (ApplicationDeploymentDescriptionType)app, cluster);
            log.info(jobDescriptor.toXML());
            data.append("jobDesc=").append(jobDescriptor.toXML());
            jobDetails.setJobDescription(jobDescriptor.toXML());
            String jobID = cluster.submitBatchJob(jobDescriptor);
            jobExecutionContext.setJobDetails(jobDetails);
            if (jobID == null) {
                jobDetails.setJobID("none");
                GFacUtils.saveJobStatus((JobExecutionContext)jobExecutionContext, (JobDetails)jobDetails, (JobState)JobState.FAILED);
            } else {
                jobDetails.setJobID(jobID);
                GFacUtils.saveJobStatus((JobExecutionContext)jobExecutionContext, (JobDetails)jobDetails, (JobState)JobState.SUBMITTED);
            }
            data.append(",jobId=").append(jobDetails.getJobID());
            this.delegateToMonitorHandlers(jobExecutionContext, (GsisshHostType)host, jobID);
        }
        catch (SSHApiException e) {
            String error = "Error submitting the job to host " + host.getHostAddress() + " message: " + e.getMessage();
            log.error(error);
            jobDetails.setJobID("none");
            GFacUtils.saveJobStatus((JobExecutionContext)jobExecutionContext, (JobDetails)jobDetails, (JobState)JobState.FAILED);
            GFacUtils.saveErrorDetails((JobExecutionContext)jobExecutionContext, (String)error, (CorrectiveAction)CorrectiveAction.CONTACT_SUPPORT, (ErrorCategory)ErrorCategory.AIRAVATA_INTERNAL_ERROR);
            throw new GFacProviderException(error, (Throwable)e);
        }
        catch (Exception e) {
            String error = "Error submitting the job to host " + host.getHostAddress() + " message: " + e.getMessage();
            log.error(error);
            jobDetails.setJobID("none");
            GFacUtils.saveJobStatus((JobExecutionContext)jobExecutionContext, (JobDetails)jobDetails, (JobState)JobState.FAILED);
            GFacUtils.saveErrorDetails((JobExecutionContext)jobExecutionContext, (String)error, (CorrectiveAction)CorrectiveAction.CONTACT_SUPPORT, (ErrorCategory)ErrorCategory.AIRAVATA_INTERNAL_ERROR);
            throw new GFacProviderException(error, (Throwable)e);
        }
        finally {
            log.info("Saving data for future recovery: ");
            log.info(data.toString());
            GFacUtils.savePluginData((JobExecutionContext)jobExecutionContext, (StringBuffer)data, (String)((Object)((Object)this)).getClass().getName());
        }
    }

    public void delegateToMonitorHandlers(JobExecutionContext jobExecutionContext, GsisshHostType host, String jobID) throws GFacHandlerException {
        List daemonHandlers = GFacImpl.getDaemonHandlers();
        if (daemonHandlers == null) {
            daemonHandlers = BetterGfacImpl.getDaemonHandlers();
        }
        ThreadedHandler pullMonitorHandler = null;
        ThreadedHandler pushMonitorHandler = null;
        String monitorMode = host.getMonitorMode();
        for (ThreadedHandler threadedHandler : daemonHandlers) {
            if ("org.apache.airavata.gfac.monitor.handlers.GridPullMonitorHandler".equals(threadedHandler.getClass().getName())) {
                pullMonitorHandler = threadedHandler;
                if ("".equals(monitorMode) || monitorMode == null || "pull".equals(monitorMode)) {
                    log.info("Job is launched successfully now parsing it to monitoring in pull mode, JobID Returned:  " + jobID);
                    pullMonitorHandler.invoke(jobExecutionContext);
                    continue;
                }
                log.error("Currently we only support Pull and Push monitoring and monitorMode should be PULL to handle by the GridPullMonitorHandler");
                continue;
            }
            if (!"org.apache.airavata.gfac.monitor.handlers.GridPushMonitorHandler".equals(threadedHandler.getClass().getName())) continue;
            pushMonitorHandler = threadedHandler;
            if ("".equals(monitorMode) || monitorMode == null || "push".equals(monitorMode)) {
                log.info("Job is launched successfully now parsing it to monitoring in push mode, JobID Returned:  " + jobID);
                pushMonitorHandler.invoke(jobExecutionContext);
                continue;
            }
            log.error("Currently we only support Pull and Push monitoring and monitorMode should be PUSH to handle by the GridPushMonitorHandler");
        }
        if (pullMonitorHandler == null && pushMonitorHandler == null && ExecutionMode.ASYNCHRONOUS.equals((Object)jobExecutionContext.getGFacConfiguration().getExecutionMode())) {
            log.error("No Daemon handler is configured in gfac-config.xml, either pull or push, so monitoring will not invoked, execution is configured as asynchronous, so Outhandler will not be invoked");
        }
    }

    public void dispose(JobExecutionContext jobExecutionContext) throws GFacProviderException, GFacException {
    }

    public void cancelJob(String jobId, JobExecutionContext jobExecutionContext) throws GFacException {
    }

    public void recover(JobExecutionContext jobExecutionContext) throws GFacProviderException, GFacException {
        String jobDesc;
        String jobId;
        HostDescriptionType host;
        block14: {
            log.info("Invoking Recovering for the Experiment: " + jobExecutionContext.getExperimentID());
            host = jobExecutionContext.getApplicationContext().getHostDescription().getType();
            jobId = "";
            jobDesc = "";
            try {
                String pluginData = GFacUtils.getPluginData((JobExecutionContext)jobExecutionContext, (String)((Object)((Object)this)).getClass().getName());
                String[] split = pluginData.split(",");
                if (split.length < 2) {
                    try {
                        this.execute(jobExecutionContext);
                    }
                    catch (GFacException e) {
                        throw new GFacProviderException("Error recovering provider", (Throwable)e);
                    }
                    return;
                }
                jobDesc = split[0].substring(7);
                jobId = split[1].substring(6);
                log.info("Following data have recovered: ");
                log.info("Job Description: " + jobDesc);
                log.info("Job Id: " + jobId);
                if (jobId != null && !"none".equals(jobId) && !"".equals(jobId)) break block14;
                try {
                    this.execute(jobExecutionContext);
                }
                catch (GFacException e) {
                    throw new GFacProviderException("Error recovering provider", (Throwable)e);
                }
                return;
            }
            catch (ApplicationSettingsException e) {
                e.printStackTrace();
            }
            catch (KeeperException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        try {
            JobDetails jobDetails = new JobDetails();
            jobDetails.setJobDescription(jobDesc);
            jobDetails.setJobID(jobId);
            jobExecutionContext.setJobDetails(jobDetails);
            if (jobExecutionContext.getSecurityContext("gsi") == null) {
                try {
                    GFACGSISSHUtils.addSecurityContext(jobExecutionContext);
                }
                catch (ApplicationSettingsException e) {
                    log.error(e.getMessage());
                    throw new GFacHandlerException("Error while creating SSHSecurityContext", (Exception)((Object)e), new String[]{e.getLocalizedMessage()});
                }
            }
            this.delegateToMonitorHandlers(jobExecutionContext, (GsisshHostType)host, jobId);
        }
        catch (GFacHandlerException e) {
            throw new GFacProviderException("Error delegating already ran job to Monitoring", (Throwable)e);
        }
    }
}

