/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.gsissh.handler;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.schmizz.sshj.connection.ConnectionException;
import net.schmizz.sshj.transport.TransportException;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.commons.gfac.type.ActualParameter;
import org.apache.airavata.commons.gfac.type.ApplicationDescription;
import org.apache.airavata.commons.gfac.type.MappingFactory;
import org.apache.airavata.gfac.GFacException;
import org.apache.airavata.gfac.core.context.JobExecutionContext;
import org.apache.airavata.gfac.core.handler.AbstractRecoverableHandler;
import org.apache.airavata.gfac.core.handler.GFacHandlerException;
import org.apache.airavata.gfac.core.provider.GFacProviderException;
import org.apache.airavata.gfac.core.utils.GFacUtils;
import org.apache.airavata.gfac.core.utils.OutputUtils;
import org.apache.airavata.gfac.gsissh.security.GSISecurityContext;
import org.apache.airavata.gfac.gsissh.util.GFACGSISSHUtils;
import org.apache.airavata.gsi.ssh.api.Cluster;
import org.apache.airavata.gsi.ssh.api.job.JobDescriptor;
import org.apache.airavata.model.workspace.experiment.CorrectiveAction;
import org.apache.airavata.model.workspace.experiment.DataObjectType;
import org.apache.airavata.model.workspace.experiment.DataTransferDetails;
import org.apache.airavata.model.workspace.experiment.DataType;
import org.apache.airavata.model.workspace.experiment.ErrorCategory;
import org.apache.airavata.model.workspace.experiment.JobDetails;
import org.apache.airavata.model.workspace.experiment.TaskDetails;
import org.apache.airavata.model.workspace.experiment.TransferState;
import org.apache.airavata.model.workspace.experiment.TransferStatus;
import org.apache.airavata.registry.cpi.ChildDataType;
import org.apache.airavata.registry.cpi.RegistryException;
import org.apache.airavata.registry.cpi.RegistryModelType;
import org.apache.airavata.schemas.gfac.ApplicationDeploymentDescriptionType;
import org.apache.airavata.schemas.gfac.GsisshHostType;
import org.apache.xmlbeans.XmlException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GSISSHOutputHandler
extends AbstractRecoverableHandler {
    private static final Logger log = LoggerFactory.getLogger(GSISSHOutputHandler.class);

    public void invoke(JobExecutionContext jobExecutionContext) throws GFacHandlerException {
        super.invoke(jobExecutionContext);
        int index = 0;
        int oldIndex = 0;
        List<Object> oldFiles = new ArrayList();
        StringBuffer data = new StringBuffer("|");
        if (jobExecutionContext.getApplicationContext().getHostDescription().getType() instanceof GsisshHostType && "push".equals(((GsisshHostType)jobExecutionContext.getApplicationContext().getHostDescription().getType()).getMonitorMode())) {
            log.warn("During the out handler chain jobExecution context came null, so trying to handler");
            ApplicationDescription applicationDeploymentDescription = jobExecutionContext.getApplicationContext().getApplicationDeploymentDescription();
            TaskDetails taskData = null;
            try {
                taskData = (TaskDetails)jobExecutionContext.getRegistry().get(RegistryModelType.TASK_DETAIL, (Object)jobExecutionContext.getTaskData().getTaskID());
            }
            catch (RegistryException e) {
                log.error("Error retrieving job details from Registry");
                throw new GFacHandlerException("Error retrieving job details from Registry", (Throwable)e);
            }
            JobDetails jobDetails = (JobDetails)taskData.getJobDetailsList().get(0);
            String jobDescription = jobDetails.getJobDescription();
            if (jobDescription != null) {
                JobDescriptor jobDescriptor = null;
                try {
                    jobDescriptor = JobDescriptor.fromXML((String)jobDescription);
                }
                catch (XmlException e1) {
                    e1.printStackTrace();
                }
                applicationDeploymentDescription.getType().setScratchWorkingDirectory(jobDescriptor.getJobDescriptorDocument().getJobDescriptor().getWorkingDirectory());
                applicationDeploymentDescription.getType().setInputDataDirectory(jobDescriptor.getInputDirectory());
                applicationDeploymentDescription.getType().setOutputDataDirectory(jobDescriptor.getOutputDirectory());
                applicationDeploymentDescription.getType().setStandardError(jobDescriptor.getJobDescriptorDocument().getJobDescriptor().getStandardErrorFile());
                applicationDeploymentDescription.getType().setStandardOutput(jobDescriptor.getJobDescriptorDocument().getJobDescriptor().getStandardOutFile());
            }
        }
        try {
            if (jobExecutionContext.getSecurityContext("gsi") == null) {
                GFACGSISSHUtils.addSecurityContext(jobExecutionContext);
            }
        }
        catch (ApplicationSettingsException e) {
            log.error(e.getMessage());
            throw new GFacHandlerException("Error while creating SSHSecurityContext", (Exception)((Object)e), new String[]{e.getLocalizedMessage()});
        }
        catch (GFacException e) {
            log.error(e.getMessage());
            throw new GFacHandlerException("Error while creating SSHSecurityContext", (Exception)((Object)e), new String[]{e.getLocalizedMessage()});
        }
        DataTransferDetails detail = new DataTransferDetails();
        TransferStatus status = new TransferStatus();
        ApplicationDeploymentDescriptionType app = jobExecutionContext.getApplicationContext().getApplicationDeploymentDescription().getType();
        try {
            File localStdErrFile;
            StringBuffer temp;
            File localStdOutFile;
            Cluster cluster = null;
            cluster = jobExecutionContext.getSecurityContext("gsi") != null ? ((GSISecurityContext)jobExecutionContext.getSecurityContext("gsi")).getPbsCluster() : ((GSISecurityContext)jobExecutionContext.getSecurityContext("gsi")).getPbsCluster();
            if (cluster == null) {
                throw new GFacProviderException("Security context is not set properly");
            }
            log.info("Successfully retrieved the Security Context");
            String pluginData = GFacUtils.getPluginData((JobExecutionContext)jobExecutionContext, (String)((Object)((Object)this)).getClass().getName());
            if (pluginData != null) {
                try {
                    oldIndex = Integer.parseInt(pluginData.split("\\|")[0].trim());
                    oldFiles = Arrays.asList(pluginData.split("\\|")[1].split(","));
                    if (oldIndex == oldFiles.size()) {
                        log.info("Old data looks good !!!!");
                    } else {
                        oldIndex = 0;
                        oldFiles.clear();
                    }
                }
                catch (NumberFormatException e) {
                    log.error("Previously stored data " + pluginData + " is wrong so we continue the operations");
                }
            }
            String timeStampedServiceName = GFacUtils.createUniqueNameForService((String)jobExecutionContext.getServiceName());
            TaskDetails taskData = jobExecutionContext.getTaskData();
            String outputDataDir = null;
            if (taskData.getAdvancedOutputDataHandling() != null) {
                outputDataDir = taskData.getAdvancedOutputDataHandling().getOutputDataDir();
            }
            if (outputDataDir == null) {
                outputDataDir = File.separator + "tmp";
            }
            outputDataDir = outputDataDir + File.separator + jobExecutionContext.getExperimentID() + "-" + jobExecutionContext.getTaskData().getTaskID();
            new File(outputDataDir).mkdirs();
            if (index < oldIndex) {
                localStdOutFile = new File((String)oldFiles.get(index));
                data.append((String)oldFiles.get(index++)).append(",");
            } else {
                localStdOutFile = new File(outputDataDir + File.separator + timeStampedServiceName + "stdout");
                cluster.scpFrom(app.getStandardOutput(), localStdOutFile.getAbsolutePath());
                Thread.sleep(1000L);
                temp = new StringBuffer(data.append(localStdOutFile.getAbsolutePath()).append(",").toString());
                GFacUtils.savePluginData((JobExecutionContext)jobExecutionContext, (StringBuffer)temp.insert(0, ++index), (String)((Object)((Object)this)).getClass().getName());
            }
            if (index < oldIndex) {
                localStdErrFile = new File((String)oldFiles.get(index));
                data.append((String)oldFiles.get(index++)).append(",");
            } else {
                localStdErrFile = new File(outputDataDir + File.separator + timeStampedServiceName + "stderr");
                cluster.scpFrom(app.getStandardError(), localStdErrFile.getAbsolutePath());
                Thread.sleep(1000L);
                temp = new StringBuffer(data.append(localStdErrFile.getAbsolutePath()).append(",").toString());
                GFacUtils.savePluginData((JobExecutionContext)jobExecutionContext, (StringBuffer)temp.insert(0, ++index), (String)((Object)((Object)this)).getClass().getName());
            }
            String stdOutStr = GFacUtils.readFileToString((String)localStdOutFile.getAbsolutePath());
            String stdErrStr = GFacUtils.readFileToString((String)localStdErrFile.getAbsolutePath());
            status.setTransferState(TransferState.COMPLETE);
            detail.setTransferStatus(status);
            detail.setTransferDescription("STDOUT:" + stdOutStr);
            this.registry.add(ChildDataType.DATA_TRANSFER_DETAIL, (Object)detail, (Object)jobExecutionContext.getTaskData().getTaskID());
            status.setTransferState(TransferState.COMPLETE);
            detail.setTransferStatus(status);
            detail.setTransferDescription("STDERR:" + stdErrStr);
            this.registry.add(ChildDataType.DATA_TRANSFER_DETAIL, (Object)detail, (Object)jobExecutionContext.getTaskData().getTaskID());
            ArrayList<DataObjectType> outputArray = new ArrayList<DataObjectType>();
            Map output = jobExecutionContext.getOutMessageContext().getParameters();
            Set keys = output.keySet();
            for (String paramName : keys) {
                ActualParameter actualParameter = (ActualParameter)output.get(paramName);
                if ("URI".equals(actualParameter.getType().getType().toString())) {
                    String outputFile;
                    List outputList = cluster.listDirectory(app.getOutputDataDirectory());
                    if (outputList.size() == 0 || ((String)outputList.get(0)).isEmpty()) {
                        OutputUtils.fillOutputFromStdout((Map)output, (String)stdOutStr, (String)stdErrStr, outputArray);
                        Set strings = output.keySet();
                        outputArray.clear();
                        for (String key : strings) {
                            String localFile;
                            ActualParameter actualParameter1 = (ActualParameter)output.get(key);
                            if (!"URI".equals(actualParameter1.getType().getType().toString())) continue;
                            String downloadFile = MappingFactory.toString((ActualParameter)actualParameter1);
                            if (index < oldIndex) {
                                localFile = (String)oldFiles.get(index);
                                data.append((String)oldFiles.get(index++)).append(",");
                            } else {
                                cluster.scpFrom(downloadFile, outputDataDir);
                                String fileName = downloadFile.substring(downloadFile.lastIndexOf(File.separatorChar) + 1, downloadFile.length());
                                localFile = outputDataDir + File.separator + fileName;
                                StringBuffer temp2 = new StringBuffer(data.append(localFile).append(",").toString());
                                GFacUtils.savePluginData((JobExecutionContext)jobExecutionContext, (StringBuffer)temp2.insert(0, ++index), (String)((Object)((Object)this)).getClass().getName());
                            }
                            jobExecutionContext.addOutputFile(localFile);
                            MappingFactory.fromString((ActualParameter)actualParameter1, (String)localFile);
                            DataObjectType dataObjectType = new DataObjectType();
                            dataObjectType.setValue(localFile);
                            dataObjectType.setKey(key);
                            dataObjectType.setType(DataType.URI);
                            outputArray.add(dataObjectType);
                        }
                        break;
                    }
                    String valueList = (String)outputList.get(0);
                    if (index < oldIndex) {
                        outputFile = (String)oldFiles.get(index);
                        data.append((String)oldFiles.get(index++)).append(",");
                    } else {
                        cluster.scpFrom(app.getOutputDataDirectory() + File.separator + valueList, outputDataDir);
                        outputFile = outputDataDir + File.separator + valueList;
                        jobExecutionContext.addOutputFile(outputFile);
                        StringBuffer temp3 = new StringBuffer(data.append(outputFile).append(",").toString());
                        GFacUtils.savePluginData((JobExecutionContext)jobExecutionContext, (StringBuffer)temp3.insert(0, ++index), (String)((Object)((Object)this)).getClass().getName());
                    }
                    jobExecutionContext.addOutputFile(outputFile);
                    DataObjectType dataObjectType = new DataObjectType();
                    dataObjectType.setValue(valueList);
                    dataObjectType.setKey(paramName);
                    dataObjectType.setType(DataType.URI);
                    outputArray.add(dataObjectType);
                    continue;
                }
                OutputUtils.fillOutputFromStdout((Map)output, (String)stdOutStr, (String)stdErrStr, outputArray);
                break;
            }
            if (outputArray == null || outputArray.isEmpty()) {
                throw new GFacHandlerException("Empty Output returned from the Application, Double check the applicationand ApplicationDescriptor output Parameter Names");
            }
            app.setStandardError(localStdErrFile.getAbsolutePath());
            app.setStandardOutput(localStdOutFile.getAbsolutePath());
            app.setOutputDataDirectory(outputDataDir);
            status.setTransferState(TransferState.DOWNLOAD);
            detail.setTransferStatus(status);
            detail.setTransferDescription(outputDataDir);
            this.registry.add(ChildDataType.DATA_TRANSFER_DETAIL, (Object)detail, (Object)jobExecutionContext.getTaskData().getTaskID());
            this.registry.add(ChildDataType.EXPERIMENT_OUTPUT, outputArray, (Object)jobExecutionContext.getExperimentID());
        }
        catch (XmlException e) {
            throw new GFacHandlerException("Cannot read output:" + e.getMessage(), (Throwable)e);
        }
        catch (ConnectionException e) {
            throw new GFacHandlerException(e.getMessage(), (Throwable)e);
        }
        catch (TransportException e) {
            throw new GFacHandlerException(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new GFacHandlerException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            try {
                status.setTransferState(TransferState.FAILED);
                detail.setTransferStatus(status);
                detail.setTransferDescription(e.getLocalizedMessage());
                this.registry.add(ChildDataType.DATA_TRANSFER_DETAIL, (Object)detail, (Object)jobExecutionContext.getTaskData().getTaskID());
                GFacUtils.saveErrorDetails((JobExecutionContext)jobExecutionContext, (String)e.getLocalizedMessage(), (CorrectiveAction)CorrectiveAction.CONTACT_SUPPORT, (ErrorCategory)ErrorCategory.FILE_SYSTEM_FAILURE);
            }
            catch (Exception e1) {
                throw new GFacHandlerException("Error persisting status", e1, new String[]{e1.getLocalizedMessage()});
            }
            throw new GFacHandlerException("Error in retrieving results", (Throwable)e);
        }
    }

    public void initProperties(Properties properties) throws GFacHandlerException {
    }

    public void recover(JobExecutionContext jobExecutionContext) throws GFacHandlerException {
        this.invoke(jobExecutionContext);
    }
}

