/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.gsissh.handler;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.StringUtil;
import org.apache.airavata.commons.gfac.type.ActualParameter;
import org.apache.airavata.commons.gfac.type.MappingFactory;
import org.apache.airavata.gfac.GFacException;
import org.apache.airavata.gfac.core.context.JobExecutionContext;
import org.apache.airavata.gfac.core.context.MessageContext;
import org.apache.airavata.gfac.core.handler.AbstractRecoverableHandler;
import org.apache.airavata.gfac.core.handler.GFacHandlerException;
import org.apache.airavata.gfac.core.utils.GFacUtils;
import org.apache.airavata.gfac.gsissh.security.GSISecurityContext;
import org.apache.airavata.gfac.gsissh.util.GFACGSISSHUtils;
import org.apache.airavata.gsi.ssh.api.Cluster;
import org.apache.airavata.gsi.ssh.api.SSHApiException;
import org.apache.airavata.model.workspace.experiment.CorrectiveAction;
import org.apache.airavata.model.workspace.experiment.DataTransferDetails;
import org.apache.airavata.model.workspace.experiment.ErrorCategory;
import org.apache.airavata.model.workspace.experiment.TransferState;
import org.apache.airavata.model.workspace.experiment.TransferStatus;
import org.apache.airavata.registry.cpi.ChildDataType;
import org.apache.airavata.schemas.gfac.ApplicationDeploymentDescriptionType;
import org.apache.airavata.schemas.gfac.URIArrayType;
import org.apache.airavata.schemas.gfac.URIParameterType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GSISSHInputHandler
extends AbstractRecoverableHandler {
    private static final Logger log = LoggerFactory.getLogger(GSISSHInputHandler.class);

    public void invoke(JobExecutionContext jobExecutionContext) throws GFacHandlerException {
        super.invoke(jobExecutionContext);
        int index = 0;
        int oldIndex = 0;
        List<Object> oldFiles = new ArrayList();
        MessageContext inputNew = new MessageContext();
        DataTransferDetails detail = new DataTransferDetails();
        TransferStatus status = new TransferStatus();
        StringBuffer data = new StringBuffer("|");
        try {
            String pluginData = GFacUtils.getPluginData((JobExecutionContext)jobExecutionContext, (String)((Object)((Object)this)).getClass().getName());
            if (pluginData != null) {
                try {
                    oldIndex = Integer.parseInt(pluginData.split("\\|")[0].trim());
                    oldFiles = Arrays.asList(pluginData.split("\\|")[1].split(","));
                    if (oldIndex == oldFiles.size()) {
                        log.info("Old data looks good !!!!");
                    } else {
                        oldIndex = 0;
                        oldFiles.clear();
                    }
                }
                catch (NumberFormatException e) {
                    log.error("Previously stored data " + pluginData + " is wrong so we continue the operations");
                }
            }
            if (jobExecutionContext.getSecurityContext("gsi") == null) {
                try {
                    GFACGSISSHUtils.addSecurityContext(jobExecutionContext);
                }
                catch (ApplicationSettingsException e) {
                    log.error(e.getMessage());
                    throw new GFacHandlerException("Error while creating SSHSecurityContext", (Exception)((Object)e), new String[]{e.getLocalizedMessage()});
                }
            }
            log.info("Invoking SCPInputHandler");
            MessageContext input = jobExecutionContext.getInMessageContext();
            Set parameters = input.getParameters().keySet();
            for (String paramName : parameters) {
                ActualParameter actualParameter = (ActualParameter)input.getParameters().get(paramName);
                String paramValue = MappingFactory.toString((ActualParameter)actualParameter);
                if ("URI".equals(actualParameter.getType().getType().toString())) {
                    if (index < oldIndex) {
                        log.info("Input File: " + paramValue + " is already transfered, so we skip this operation !!!");
                        ((URIParameterType)actualParameter.getType()).setValue((String)oldFiles.get(index));
                        data.append((String)oldFiles.get(index++)).append(",");
                    } else {
                        String s = GSISSHInputHandler.stageInputFiles(jobExecutionContext, paramValue);
                        ((URIParameterType)actualParameter.getType()).setValue(s);
                        StringBuffer temp = new StringBuffer(data.append(s).append(",").toString());
                        GFacUtils.savePluginData((JobExecutionContext)jobExecutionContext, (StringBuffer)temp.insert(0, ++index), (String)((Object)((Object)this)).getClass().getName());
                    }
                } else if ("URIArray".equals(actualParameter.getType().getType().toString())) {
                    List<String> split = Arrays.asList(StringUtil.getElementsFromString((String)paramValue));
                    ArrayList<Object> newFiles = new ArrayList<Object>();
                    for (String paramValueEach : split) {
                        if (index < oldIndex) {
                            log.info("Input File: " + paramValue + " is already transfered, so we skip this operation !!!");
                            newFiles.add(oldFiles.get(index));
                            data.append((String)oldFiles.get(index++)).append(",");
                            continue;
                        }
                        String stageInputFiles = GSISSHInputHandler.stageInputFiles(jobExecutionContext, paramValueEach);
                        status.setTransferState(TransferState.UPLOAD);
                        detail.setTransferStatus(status);
                        detail.setTransferDescription("Input Data Staged: " + stageInputFiles);
                        this.registry.add(ChildDataType.DATA_TRANSFER_DETAIL, (Object)detail, (Object)jobExecutionContext.getTaskData().getTaskID());
                        StringBuffer temp = new StringBuffer(data.append(stageInputFiles).append(",").toString());
                        GFacUtils.savePluginData((JobExecutionContext)jobExecutionContext, (StringBuffer)temp.insert(0, ++index), (String)((Object)((Object)this)).getClass().getName());
                        newFiles.add(stageInputFiles);
                    }
                    ((URIArrayType)actualParameter.getType()).setValueArray(newFiles.toArray(new String[newFiles.size()]));
                }
                inputNew.getParameters().put(paramName, actualParameter);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            status.setTransferState(TransferState.FAILED);
            detail.setTransferDescription(e.getLocalizedMessage());
            detail.setTransferStatus(status);
            try {
                GFacUtils.saveErrorDetails((JobExecutionContext)jobExecutionContext, (String)e.getLocalizedMessage(), (CorrectiveAction)CorrectiveAction.CONTACT_SUPPORT, (ErrorCategory)ErrorCategory.FILE_SYSTEM_FAILURE);
                this.registry.add(ChildDataType.DATA_TRANSFER_DETAIL, (Object)detail, (Object)jobExecutionContext.getTaskData().getTaskID());
            }
            catch (Exception e1) {
                throw new GFacHandlerException("Error persisting status", e1, new String[]{e1.getLocalizedMessage()});
            }
            throw new GFacHandlerException("Error while input File Staging", e, new String[]{e.getLocalizedMessage()});
        }
        jobExecutionContext.setInMessageContext(inputNew);
    }

    private static String stageInputFiles(JobExecutionContext jobExecutionContext, String paramValue) throws IOException, GFacException {
        Cluster cluster = null;
        cluster = jobExecutionContext.getSecurityContext("gsi") != null ? ((GSISecurityContext)jobExecutionContext.getSecurityContext("gsi")).getPbsCluster() : ((GSISecurityContext)jobExecutionContext.getSecurityContext("gsi")).getPbsCluster();
        if (cluster == null) {
            throw new GFacException("Security context is not set properly");
        }
        log.info("Successfully retrieved the Security Context");
        ApplicationDeploymentDescriptionType app = jobExecutionContext.getApplicationContext().getApplicationDeploymentDescription().getType();
        int i = paramValue.lastIndexOf(File.separator);
        String substring = paramValue.substring(i + 1);
        try {
            String targetFile = app.getInputDataDirectory() + File.separator + substring;
            if (paramValue.startsWith("file")) {
                paramValue = paramValue.substring(paramValue.indexOf(":") + 1, paramValue.length());
            }
            cluster.scpTo(targetFile, paramValue);
            return targetFile;
        }
        catch (SSHApiException e) {
            throw new GFacHandlerException("Error while input File Staging", (Exception)((Object)e), new String[]{e.getLocalizedMessage()});
        }
    }

    public void initProperties(Properties properties) throws GFacHandlerException {
    }

    public void recover(JobExecutionContext jobExecutionContext) throws GFacHandlerException {
        this.invoke(jobExecutionContext);
    }
}

