/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.gsissh.handler;

import java.util.Properties;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.gfac.GFacException;
import org.apache.airavata.gfac.core.context.JobExecutionContext;
import org.apache.airavata.gfac.core.handler.AbstractRecoverableHandler;
import org.apache.airavata.gfac.core.handler.GFacHandlerException;
import org.apache.airavata.gfac.core.utils.GFacUtils;
import org.apache.airavata.gfac.gsissh.security.GSISecurityContext;
import org.apache.airavata.gfac.gsissh.util.GFACGSISSHUtils;
import org.apache.airavata.gsi.ssh.api.Cluster;
import org.apache.airavata.gsi.ssh.api.SSHApiException;
import org.apache.airavata.model.workspace.experiment.CorrectiveAction;
import org.apache.airavata.model.workspace.experiment.DataTransferDetails;
import org.apache.airavata.model.workspace.experiment.ErrorCategory;
import org.apache.airavata.model.workspace.experiment.TransferState;
import org.apache.airavata.model.workspace.experiment.TransferStatus;
import org.apache.airavata.registry.cpi.ChildDataType;
import org.apache.airavata.schemas.gfac.ApplicationDeploymentDescriptionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GSISSHDirectorySetupHandler
extends AbstractRecoverableHandler {
    private static final Logger log = LoggerFactory.getLogger(GSISSHDirectorySetupHandler.class);

    public void invoke(JobExecutionContext jobExecutionContext) throws GFacHandlerException {
        try {
            if (jobExecutionContext.getSecurityContext("gsi") == null) {
                GFACGSISSHUtils.addSecurityContext(jobExecutionContext);
            }
        }
        catch (ApplicationSettingsException e) {
            log.error(e.getMessage());
            throw new GFacHandlerException("Error while creating SSHSecurityContext", (Exception)((Object)e), new String[]{e.getLocalizedMessage()});
        }
        catch (GFacException e) {
            throw new GFacHandlerException("Error while creating SSHSecurityContext", (Exception)((Object)e), new String[]{e.getLocalizedMessage()});
        }
        log.info("Setup SSH job directorties");
        super.invoke(jobExecutionContext);
        this.makeDirectory(jobExecutionContext);
    }

    private void makeDirectory(JobExecutionContext jobExecutionContext) throws GFacHandlerException {
        try {
            Cluster cluster = ((GSISecurityContext)jobExecutionContext.getSecurityContext("gsi")).getPbsCluster();
            if (cluster == null) {
                throw new GFacHandlerException("Security context is not set properly");
            }
            log.info("Successfully retrieved the Security Context");
            ApplicationDeploymentDescriptionType app = jobExecutionContext.getApplicationContext().getApplicationDeploymentDescription().getType();
            String workingDirectory = app.getScratchWorkingDirectory();
            cluster.makeDirectory(workingDirectory);
            cluster.makeDirectory(app.getScratchWorkingDirectory());
            cluster.makeDirectory(app.getInputDataDirectory());
            cluster.makeDirectory(app.getOutputDataDirectory());
            DataTransferDetails detail = new DataTransferDetails();
            TransferStatus status = new TransferStatus();
            status.setTransferState(TransferState.DIRECTORY_SETUP);
            detail.setTransferStatus(status);
            detail.setTransferDescription("Working directory = " + workingDirectory);
            this.registry.add(ChildDataType.DATA_TRANSFER_DETAIL, (Object)detail, (Object)jobExecutionContext.getTaskData().getTaskID());
        }
        catch (SSHApiException e) {
            throw new GFacHandlerException("Error executing the Handler: " + GSISSHDirectorySetupHandler.class, (Throwable)e);
        }
        catch (Exception e) {
            DataTransferDetails detail = new DataTransferDetails();
            TransferStatus status = new TransferStatus();
            detail.setTransferDescription(e.getLocalizedMessage());
            status.setTransferState(TransferState.FAILED);
            detail.setTransferStatus(status);
            try {
                this.registry.add(ChildDataType.DATA_TRANSFER_DETAIL, (Object)detail, (Object)jobExecutionContext.getTaskData().getTaskID());
                GFacUtils.saveErrorDetails((JobExecutionContext)jobExecutionContext, (String)e.getLocalizedMessage(), (CorrectiveAction)CorrectiveAction.CONTACT_SUPPORT, (ErrorCategory)ErrorCategory.FILE_SYSTEM_FAILURE);
            }
            catch (Exception e1) {
                throw new GFacHandlerException("Error persisting status", e1, new String[]{e1.getLocalizedMessage()});
            }
            throw new GFacHandlerException("Error executing the Handler: " + GSISSHDirectorySetupHandler.class, (Throwable)e);
        }
    }

    public void recover(JobExecutionContext jobExecutionContext) throws GFacHandlerException {
        this.invoke(jobExecutionContext);
    }

    public void initProperties(Properties properties) throws GFacHandlerException {
    }
}

