/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.gram.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.airavata.common.utils.StringUtil;
import org.apache.airavata.commons.gfac.type.ActualParameter;
import org.apache.airavata.commons.gfac.type.MappingFactory;
import org.apache.airavata.gfac.ToolsException;
import org.apache.airavata.gfac.core.context.JobExecutionContext;
import org.apache.airavata.gfac.core.context.MessageContext;
import org.apache.airavata.gfac.core.provider.GFacProviderException;
import org.apache.airavata.model.workspace.experiment.ComputationalResourceScheduling;
import org.apache.airavata.model.workspace.experiment.TaskDetails;
import org.apache.airavata.schemas.gfac.FileArrayType;
import org.apache.airavata.schemas.gfac.HpcApplicationDeploymentType;
import org.apache.airavata.schemas.gfac.NameValuePairType;
import org.apache.airavata.schemas.gfac.QueueType;
import org.apache.airavata.schemas.gfac.StringArrayType;
import org.apache.airavata.schemas.gfac.URIArrayType;
import org.globus.gram.GramAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GramRSLGenerator {
    protected static final Logger log = LoggerFactory.getLogger(GramRSLGenerator.class);

    public static GramAttributes configureRemoteJob(JobExecutionContext context) throws ToolsException {
        HpcApplicationDeploymentType app = (HpcApplicationDeploymentType)context.getApplicationContext().getApplicationDeploymentDescription().getType();
        GramAttributes jobAttr = new GramAttributes();
        jobAttr.setExecutable(app.getExecutableLocation());
        jobAttr.setDirectory(app.getStaticWorkingDirectory());
        jobAttr.setStdout(app.getStandardOutput());
        jobAttr.setStderr(app.getStandardError());
        NameValuePairType[] env = app.getApplicationEnvironmentArray();
        if (env.length != 0) {
            HashMap<String, String> nv = new HashMap<String, String>();
            for (int i = 0; i < env.length; ++i) {
                String key = env[i].getName();
                String value = env[i].getValue();
                nv.put(key, value);
            }
            for (Map.Entry entry : nv.entrySet()) {
                jobAttr.addEnvVariable((String)entry.getKey(), (String)entry.getValue());
            }
        }
        jobAttr.addEnvVariable("input", app.getInputDataDirectory());
        jobAttr.addEnvVariable("output", app.getOutputDataDirectory());
        if (app.getStandardInput() != null && !"".equals(app.getStandardInput())) {
            jobAttr.setStdin(app.getStandardInput());
        } else {
            MessageContext input = context.getInMessageContext();
            Map inputs = input.getParameters();
            Set keys = inputs.keySet();
            for (String paramName : keys) {
                ActualParameter actualParameter = (ActualParameter)inputs.get(paramName);
                if ("URIArray".equals(actualParameter.getType().getType().toString()) || "StringArray".equals(actualParameter.getType().getType().toString()) || "FileArray".equals(actualParameter.getType().getType().toString())) {
                    String[] values = null;
                    if (actualParameter.getType() instanceof URIArrayType) {
                        values = ((URIArrayType)actualParameter.getType()).getValueArray();
                    } else if (actualParameter.getType() instanceof StringArrayType) {
                        values = ((StringArrayType)actualParameter.getType()).getValueArray();
                    } else if (actualParameter.getType() instanceof FileArrayType) {
                        values = ((FileArrayType)actualParameter.getType()).getValueArray();
                    }
                    String value = StringUtil.createDelimiteredString((String[])values, (String)" ");
                    jobAttr.addArgument(value);
                    continue;
                }
                String paramValue = MappingFactory.toString((ActualParameter)actualParameter);
                jobAttr.addArgument(paramValue);
            }
        }
        TaskDetails taskData = context.getTaskData();
        if (taskData != null && taskData.isSetTaskScheduling()) {
            ComputationalResourceScheduling computionnalResource = taskData.getTaskScheduling();
            try {
                int cpuCount = computionnalResource.getTotalCPUCount();
                if (cpuCount > 0) {
                    app.setCpuCount(cpuCount);
                }
            }
            catch (NullPointerException e) {
                log.debug("No Value sent in WorkflowContextHeader for CPU Count, value in the Deployment Descriptor will be used");
                new GFacProviderException("No Value sent in WorkflowContextHeader for Node Count, value in the Deployment Descriptor will be used", (Throwable)e);
            }
            try {
                int nodeCount = computionnalResource.getNodeCount();
                if (nodeCount > 0) {
                    app.setNodeCount(nodeCount);
                }
            }
            catch (NullPointerException e) {
                log.debug("No Value sent in WorkflowContextHeader for Node Count, value in the Deployment Descriptor will be used");
                new GFacProviderException("No Value sent in WorkflowContextHeader for Node Count, value in the Deployment Descriptor will be used", (Throwable)e);
            }
            try {
                String queueName = computionnalResource.getQueueName();
                if (queueName != null) {
                    if (app.getQueue() == null) {
                        QueueType queueType = app.addNewQueue();
                        queueType.setQueueName(queueName);
                    } else {
                        app.getQueue().setQueueName(queueName);
                    }
                }
            }
            catch (NullPointerException e) {
                log.debug("No Value sent in WorkflowContextHeader for Node Count, value in the Deployment Descriptor will be used");
                new GFacProviderException("No Value sent in WorkflowContextHeader for Node Count, value in the Deployment Descriptor will be used", (Throwable)e);
            }
            try {
                int maxwallTime = computionnalResource.getWallTimeLimit();
                if (maxwallTime > 0) {
                    app.setMaxWallTime(maxwallTime);
                }
            }
            catch (NullPointerException e) {
                log.debug("No Value sent in WorkflowContextHeader for Node Count, value in the Deployment Descriptor will be used");
                new GFacProviderException("No Value sent in WorkflowContextHeader for Node Count, value in the Deployment Descriptor will be used", (Throwable)e);
            }
        }
        if (app.getNodeCount() > 0) {
            jobAttr.set("hostCount", String.valueOf(app.getNodeCount()));
            log.debug("Setting number of Nodes to " + app.getCpuCount());
        }
        if (app.getCpuCount() > 0) {
            log.debug("Setting number of procs to " + app.getCpuCount());
            jobAttr.setNumProcs(app.getCpuCount());
        }
        if (app.getMinMemory() > 0) {
            log.debug("Setting minimum memory to " + app.getMinMemory());
            jobAttr.setMinMemory(app.getMinMemory());
        }
        if (app.getMaxMemory() > 0) {
            log.debug("Setting maximum memory to " + app.getMaxMemory());
            jobAttr.setMaxMemory(app.getMaxMemory());
        }
        if (app.getProjectAccount() != null && app.getProjectAccount().getProjectAccountNumber() != null) {
            log.debug("Setting project to " + app.getProjectAccount().getProjectAccountNumber());
            jobAttr.setProject(app.getProjectAccount().getProjectAccountNumber());
        }
        if (app.getQueue() != null && app.getQueue().getQueueName() != null) {
            log.debug("Setting job queue to " + app.getQueue().getQueueName());
            jobAttr.setQueue(app.getQueue().getQueueName());
        }
        if (app.getMaxWallTime() > 0) {
            log.debug("Setting max wall clock time to " + app.getMaxWallTime());
            jobAttr.setMaxWallTime(app.getMaxWallTime());
            jobAttr.set("proxy_timeout", "1");
        } else {
            jobAttr.setMaxWallTime(30);
        }
        String jobType = JobType.SINGLE.toString();
        if (app.getJobType() != null) {
            jobType = app.getJobType().toString();
        }
        if (jobType.equalsIgnoreCase(JobType.SINGLE.toString())) {
            log.debug("Setting job type to single");
            jobAttr.setJobType(1);
        }
        if (jobType.equalsIgnoreCase(JobType.SERIAL.toString())) {
            log.debug("Setting job type to single");
            jobAttr.setJobType(1);
        } else if (jobType.equalsIgnoreCase(JobType.MPI.toString())) {
            log.debug("Setting job type to mpi");
            jobAttr.setJobType(3);
        } else if (jobType.equalsIgnoreCase(JobType.MULTIPLE.toString())) {
            log.debug("Setting job type to multiple");
            jobAttr.setJobType(2);
        } else if (jobType.equalsIgnoreCase(JobType.CONDOR.toString())) {
            jobAttr.setJobType(4);
        }
        return jobAttr;
    }

    private static enum JobType {
        SERIAL,
        SINGLE,
        MPI,
        MULTIPLE,
        CONDOR;

    }
}

