/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.gram.util;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.airavata.gfac.ToolsException;
import org.apache.airavata.gfac.core.context.JobExecutionContext;
import org.apache.airavata.gfac.core.provider.GFacProviderException;
import org.apache.airavata.gfac.gram.util.GramRSLGenerator;
import org.apache.airavata.gfac.gram.util.GridFTPContactInfo;
import org.apache.airavata.model.workspace.experiment.JobState;
import org.globus.gram.GramAttributes;
import org.globus.gram.GramJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GramProviderUtils {
    private static final Logger log = LoggerFactory.getLogger(GramProviderUtils.class);

    public static GramJob setupEnvironment(JobExecutionContext jobExecutionContext, boolean enableTwoPhase) throws GFacProviderException {
        log.debug("Searching for Gate Keeper");
        try {
            GramAttributes jobAttr = GramRSLGenerator.configureRemoteJob(jobExecutionContext);
            String rsl = jobAttr.toRSL();
            if (enableTwoPhase) {
                rsl = rsl + "(twoPhase=yes)";
            }
            log.debug("RSL = " + rsl);
            GramJob job = new GramJob(rsl);
            return job;
        }
        catch (ToolsException te) {
            throw new GFacProviderException(te.getMessage(), (Throwable)te);
        }
    }

    public static JobState getApplicationJobStatus(int gramStatus) {
        switch (gramStatus) {
            case 32: {
                return JobState.HELD;
            }
            case 2: {
                return JobState.ACTIVE;
            }
            case 8: {
                return JobState.COMPLETE;
            }
            case 4: {
                return JobState.FAILED;
            }
            case 1: {
                return JobState.QUEUED;
            }
            case 64: {
                return JobState.QUEUED;
            }
            case 128: {
                return JobState.COMPLETE;
            }
            case 16: {
                return JobState.SUSPENDED;
            }
        }
        return JobState.UNKNOWN;
    }

    public static URI createGsiftpURI(String host, String localPath) throws URISyntaxException {
        StringBuffer buf = new StringBuffer();
        if (!host.startsWith("gsiftp://")) {
            buf.append("gsiftp://");
        }
        buf.append(host);
        if (!host.endsWith("/")) {
            buf.append("/");
        }
        buf.append(localPath);
        return new URI(buf.toString());
    }

    public static URI createGsiftpURI(GridFTPContactInfo host, String localPath) throws URISyntaxException {
        StringBuffer buf = new StringBuffer();
        if (!host.hostName.startsWith("gsiftp://")) {
            buf.append("gsiftp://");
        }
        buf.append(host).append(":").append(host.port);
        if (!host.hostName.endsWith("/")) {
            buf.append("/");
        }
        buf.append(localPath);
        return new URI(buf.toString());
    }

    public static String createGsiftpURIAsString(String host, String localPath) throws URISyntaxException {
        StringBuffer buf = new StringBuffer();
        if (!host.startsWith("gsiftp://")) {
            buf.append("gsiftp://");
        }
        buf.append(host);
        if (!host.endsWith("/")) {
            buf.append("/");
        }
        buf.append(localPath);
        return buf.toString();
    }
}

