/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.gram.util;

import org.apache.airavata.gfac.GFacException;
import org.apache.airavata.gfac.core.context.JobExecutionContext;
import org.apache.airavata.gfac.core.notification.events.GFacEvent;
import org.apache.airavata.gfac.core.notification.events.StatusChangeEvent;
import org.apache.airavata.gfac.core.utils.GFacUtils;
import org.apache.airavata.gfac.gram.security.GSISecurityContext;
import org.apache.airavata.gfac.gram.util.GramProviderUtils;
import org.apache.airavata.model.workspace.experiment.JobDetails;
import org.apache.airavata.model.workspace.experiment.JobState;
import org.globus.gram.GramJob;
import org.globus.gram.GramJobListener;
import org.ietf.jgss.GSSCredential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GramJobSubmissionListener
implements GramJobListener {
    private final Logger log = LoggerFactory.getLogger(GramJobSubmissionListener.class);
    public static final int NO_ERROR = -42;
    public static final int INITIAL_STATUS = -43;
    private volatile boolean jobDone = false;
    private volatile int error = -42;
    private int currentStatus = -43;
    private JobExecutionContext context;
    private GramJob job;

    public GramJobSubmissionListener(GramJob job, JobExecutionContext context) {
        this.job = job;
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitFor() {
        while (!this.isJobDone()) {
            GramJobSubmissionListener gramJobSubmissionListener = this;
            synchronized (gramJobSubmissionListener) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private synchronized boolean isJobDone() {
        return this.jobDone;
    }

    private void setStatus(int status, int error) {
        try {
            GFacUtils.updateJobStatus((JobExecutionContext)this.context, (JobDetails)this.context.getJobDetails(), (JobState)GramProviderUtils.getApplicationJobStatus(status));
        }
        catch (GFacException e) {
            this.log.error("Error persisting status" + e.getLocalizedMessage(), (Throwable)e);
        }
        this.currentStatus = status;
        this.error = error;
        switch (this.currentStatus) {
            case 4: {
                this.log.info("Job Error Code: " + error);
                this.jobDone = true;
                this.notifyAll();
            }
            case 8: {
                this.jobDone = true;
                this.notifyAll();
            }
        }
    }

    public synchronized void statusChanged(GramJob job) {
        int jobStatus = job.getStatus();
        String jobStatusMessage = "Status of job " + job.getIDAsString() + "is " + job.getStatusAsString();
        this.context.getNotifier().publish((GFacEvent)new StatusChangeEvent(jobStatusMessage));
        if (this.currentStatus != jobStatus) {
            this.currentStatus = jobStatus;
            this.setStatus(job.getStatus(), job.getError());
            this.renewCredentials(job);
        }
    }

    private void renewCredentials(GramJob job) {
        try {
            int proxyExpTime = job.getCredentials().getRemainingLifetime();
            if (proxyExpTime < GSISecurityContext.CREDENTIAL_RENEWING_THRESH_HOLD) {
                this.log.info("Job proxy expired. Trying to renew proxy");
                GSSCredential gssCred = ((GSISecurityContext)this.context.getSecurityContext("gsi")).renewCredentials();
                job.renew(gssCred);
                this.log.info("MyProxy credentials are renewed .");
            }
        }
        catch (Exception e) {
            this.log.error("An error occurred while trying to renew credentials. Job id " + job.getIDAsString());
        }
    }

    public synchronized int getError() {
        return this.error;
    }

    public synchronized int getCurrentStatus() {
        return this.currentStatus;
    }
}

