/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.gram.security;

import java.io.File;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.ServerSettings;
import org.apache.airavata.credential.store.credential.Credential;
import org.apache.airavata.credential.store.credential.impl.certificate.CertificateCredential;
import org.apache.airavata.credential.store.store.CredentialReader;
import org.apache.airavata.gfac.AbstractSecurityContext;
import org.apache.airavata.gfac.GFacException;
import org.apache.airavata.gfac.RequestData;
import org.globus.gsi.X509Credential;
import org.globus.gsi.gssapi.GlobusGSSCredentialImpl;
import org.globus.gsi.provider.GlobusProvider;
import org.globus.myproxy.GetParams;
import org.globus.myproxy.MyProxy;
import org.globus.myproxy.MyProxyException;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GSISecurityContext
extends AbstractSecurityContext {
    protected static final Logger log = LoggerFactory.getLogger(GSISecurityContext.class);
    public static final String GSI_SECURITY_CONTEXT = "gsi";
    public static int CREDENTIAL_RENEWING_THRESH_HOLD = 900;
    private GSSCredential gssCredentials = null;

    public static void setUpTrustedCertificatePath(String trustedCertificatePath) {
        File file = new File(trustedCertificatePath);
        if (!file.exists() || !file.canRead()) {
            File f = new File(".");
            log.info("Current directory " + f.getAbsolutePath());
            throw new RuntimeException("Cannot read trusted certificate path " + trustedCertificatePath);
        }
        System.setProperty("X509_CERT_DIR", file.getAbsolutePath());
    }

    private static void setUpTrustedCertificatePath() throws ApplicationSettingsException {
        String trustedCertificatePath = ServerSettings.getSetting((String)"trusted.cert.location");
        GSISecurityContext.setUpTrustedCertificatePath(trustedCertificatePath);
    }

    public static String getTrustedCertificatePath() {
        return System.getProperty("X509_CERT_DIR");
    }

    public GSISecurityContext(CredentialReader credentialReader, RequestData requestData) {
        super(credentialReader, requestData);
    }

    public GSSCredential getGssCredentials() throws GFacException, ApplicationSettingsException {
        if (this.gssCredentials == null) {
            try {
                this.gssCredentials = this.getCredentialsFromStore();
            }
            catch (Exception e) {
                log.error("An exception occurred while retrieving credentials from the credential store. Will continue with my proxy user name and password.", (Throwable)e);
            }
            if (this.gssCredentials == null) {
                this.gssCredentials = this.getDefaultCredentials();
            }
            if (this.gssCredentials == null) {
                throw new GFacException("Unable to retrieve my proxy credentials to continue operation.");
            }
        } else {
            try {
                if (this.gssCredentials.getRemainingLifetime() < CREDENTIAL_RENEWING_THRESH_HOLD) {
                    return this.renewCredentials();
                }
            }
            catch (GSSException e) {
                throw new GFacException("Unable to retrieve remaining life time from credentials.", (Throwable)e);
            }
        }
        return this.gssCredentials;
    }

    public GSSCredential renewCredentials() throws GFacException, ApplicationSettingsException {
        try {
            this.gssCredentials = this.renewCredentialsAsATrustedHost();
        }
        catch (Exception e) {
            log.warn("Renewing credentials as a trusted renewer failed", (Throwable)e);
            this.gssCredentials = this.getProxyCredentials();
        }
        return this.gssCredentials;
    }

    public GSSCredential getCredentialsFromStore() throws Exception {
        if (this.getCredentialReader() == null) {
            return null;
        }
        Credential credential = this.getCredentialReader().getCredential(this.getRequestData().getGatewayId(), this.getRequestData().getTokenId());
        if (credential != null) {
            if (credential instanceof CertificateCredential) {
                log.info("Successfully found credentials for token id - " + this.getRequestData().getTokenId() + " gateway id - " + this.getRequestData().getGatewayId());
                CertificateCredential certificateCredential = (CertificateCredential)credential;
                X509Certificate[] certificates = certificateCredential.getCertificates();
                X509Credential newCredential = new X509Credential(certificateCredential.getPrivateKey(), certificates);
                GlobusGSSCredentialImpl cred = new GlobusGSSCredentialImpl(newCredential, 0);
                System.out.print(cred.export(0));
                return cred;
            }
            log.info("Credential type is not CertificateCredential. Cannot create mapping globus credentials. Credential type - " + credential.getClass().getName());
        } else {
            log.info("Could not find credentials for token - " + this.getRequestData().getTokenId() + " and " + "gateway id - " + this.getRequestData().getGatewayId());
        }
        return null;
    }

    public GSSCredential getDefaultCredentials() throws GFacException, ApplicationSettingsException {
        MyProxy myproxy = new MyProxy(this.getRequestData().getMyProxyServerUrl(), this.getRequestData().getMyProxyPort());
        try {
            return myproxy.get(this.getRequestData().getMyProxyUserName(), this.getRequestData().getMyProxyPassword(), this.getRequestData().getMyProxyLifeTime());
        }
        catch (MyProxyException e) {
            throw new GFacException("An error occurred while retrieving default security credentials.", (Throwable)e);
        }
    }

    public GSSCredential getProxyCredentials() throws GFacException, ApplicationSettingsException {
        MyProxy myproxy = new MyProxy(this.getRequestData().getMyProxyServerUrl(), this.getRequestData().getMyProxyPort());
        try {
            return myproxy.get(this.gssCredentials, this.getRequestData().getMyProxyUserName(), this.getRequestData().getMyProxyPassword(), this.getRequestData().getMyProxyLifeTime());
        }
        catch (MyProxyException e) {
            throw new GFacException("An error occurred while renewing security credentials using user/password.", (Throwable)e);
        }
    }

    public GSSCredential renewCredentialsAsATrustedHost() throws GFacException, ApplicationSettingsException {
        MyProxy myproxy = new MyProxy(this.getRequestData().getMyProxyServerUrl(), this.getRequestData().getMyProxyPort());
        GetParams getParams = new GetParams();
        getParams.setAuthzCreds(this.gssCredentials);
        getParams.setUserName(this.getRequestData().getMyProxyUserName());
        getParams.setLifetime(this.getRequestData().getMyProxyLifeTime());
        try {
            return myproxy.get(this.gssCredentials, getParams);
        }
        catch (MyProxyException e) {
            throw new GFacException("An error occurred while renewing security credentials.", (Throwable)e);
        }
    }

    static {
        Security.addProvider((Provider)new GlobusProvider());
        try {
            GSISecurityContext.setUpTrustedCertificatePath();
        }
        catch (ApplicationSettingsException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
        }
    }
}

