/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.gram.provider.impl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.ServerSettings;
import org.apache.airavata.gfac.GFacException;
import org.apache.airavata.gfac.JobSubmissionFault;
import org.apache.airavata.gfac.core.context.JobExecutionContext;
import org.apache.airavata.gfac.core.notification.events.GFacEvent;
import org.apache.airavata.gfac.core.notification.events.JobIDEvent;
import org.apache.airavata.gfac.core.notification.events.StartExecutionEvent;
import org.apache.airavata.gfac.core.provider.AbstractProvider;
import org.apache.airavata.gfac.core.provider.GFacProviderException;
import org.apache.airavata.gfac.core.utils.GFacUtils;
import org.apache.airavata.gfac.gram.security.GSISecurityContext;
import org.apache.airavata.gfac.gram.util.GramJobSubmissionListener;
import org.apache.airavata.gfac.gram.util.GramProviderUtils;
import org.apache.airavata.model.workspace.experiment.CorrectiveAction;
import org.apache.airavata.model.workspace.experiment.ErrorCategory;
import org.apache.airavata.model.workspace.experiment.JobDetails;
import org.apache.airavata.model.workspace.experiment.JobState;
import org.apache.airavata.schemas.gfac.ApplicationDeploymentDescriptionType;
import org.apache.airavata.schemas.gfac.GlobusHostType;
import org.globus.gram.GramException;
import org.globus.gram.GramJob;
import org.globus.gram.GramJobListener;
import org.globus.gram.WaitingForCommitException;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GramProvider
extends AbstractProvider {
    private static final Logger log = LoggerFactory.getLogger(GramJobSubmissionListener.class);
    private GramJob job;
    private GramJobSubmissionListener listener;
    private boolean twoPhase = true;
    private boolean renewCredentialsAttempt = false;
    private boolean reSubmissionInProgress = false;
    private boolean authorisationFailedAttempt = false;
    private static final Map<String, GramJob> currentlyExecutingJobCache = new ConcurrentHashMap<String, GramJob>();
    private static Properties resources;

    public void initialize(JobExecutionContext jobExecutionContext) throws GFacProviderException, GFacException {
        try {
            super.initialize(jobExecutionContext);
            String strTwoPhase = ServerSettings.getSetting((String)"TwoPhase");
            if (strTwoPhase != null) {
                this.twoPhase = Boolean.parseBoolean(strTwoPhase);
                log.info("Two phase commit is set to " + this.twoPhase);
            }
        }
        catch (ApplicationSettingsException e) {
            log.warn("Error reading TwoPhase property from configurations.", (Throwable)e);
        }
        this.job = GramProviderUtils.setupEnvironment(jobExecutionContext, this.twoPhase);
        this.listener = new GramJobSubmissionListener(this.job, jobExecutionContext);
        this.job.addListener((GramJobListener)this.listener);
    }

    public void execute(JobExecutionContext jobExecutionContext) throws GFacProviderException, GFacException {
        jobExecutionContext.getNotifier().publish((GFacEvent)new StartExecutionEvent());
        GlobusHostType host = (GlobusHostType)jobExecutionContext.getApplicationContext().getHostDescription().getType();
        ApplicationDeploymentDescriptionType app = jobExecutionContext.getApplicationContext().getApplicationDeploymentDescription().getType();
        StringBuilder stringBuilder = new StringBuilder();
        try {
            GSSCredential gssCred = ((GSISecurityContext)jobExecutionContext.getSecurityContext("gsi")).getGssCredentials();
            this.job.setCredentials(gssCred);
            String gateKeeper = host.getGlobusGateKeeperEndPointArray(0);
            log.info("Request to contact:" + gateKeeper);
            stringBuilder.append("Finished launching job, Host = ").append(host.getHostAddress()).append(" RSL = ").append(this.job.getRSL()).append(" working directory = ").append(app.getStaticWorkingDirectory()).append(" temp directory = ").append(app.getScratchWorkingDirectory()).append(" Globus GateKeeper Endpoint = ").append(gateKeeper);
            log.info(stringBuilder.toString());
            this.submitJobs(gateKeeper, jobExecutionContext, host);
        }
        catch (ApplicationSettingsException e) {
            throw new GFacException(e.getMessage(), (Throwable)e);
        }
        finally {
            if (this.job != null) {
                try {
                    this.job.removeListener((GramJobListener)this.listener);
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                }
            }
        }
    }

    private void submitJobs(String gateKeeper, JobExecutionContext jobExecutionContext, GlobusHostType globusHostType) throws GFacException, GFacProviderException {
        boolean applicationSaved = false;
        String taskID = jobExecutionContext.getTaskData().getTaskID();
        if (this.twoPhase) {
            try {
                this.job.request(true, gateKeeper, false, false);
                this.renewCredentialsAttempt = false;
            }
            catch (WaitingForCommitException e) {
                String jobID = this.job.getIDAsString();
                this.details.setJobID(jobID);
                this.details.setJobDescription(this.job.getRSL());
                jobExecutionContext.setJobDetails(this.details);
                GFacUtils.saveJobStatus((JobExecutionContext)jobExecutionContext, (JobDetails)this.details, (JobState)JobState.UN_SUBMITTED);
                applicationSaved = true;
                String jobStatusMessage = "Un-submitted JobID= " + jobID;
                log.info(jobStatusMessage);
                jobExecutionContext.getNotifier().publish((GFacEvent)new JobIDEvent(jobStatusMessage));
                log.info("Two phase commit: sending COMMIT_REQUEST signal; Job id - " + jobID);
                try {
                    this.job.signal(5);
                }
                catch (GramException gramException) {
                    throw new GFacException("Error while sending commit request. Job Id - " + this.job.getIDAsString(), (Throwable)gramException);
                }
                catch (GSSException gssException) {
                    log.error("Error while submitting commit request - Credentials provided are invalid. Job Id - " + this.job.getIDAsString(), (Throwable)e);
                    log.info("Attempting to renew credentials and re-submit commit signal...");
                    GFacUtils.saveErrorDetails((JobExecutionContext)jobExecutionContext, (String)gssException.getLocalizedMessage(), (CorrectiveAction)CorrectiveAction.RETRY_SUBMISSION, (ErrorCategory)ErrorCategory.AIRAVATA_INTERNAL_ERROR);
                    this.renewCredentials(jobExecutionContext);
                    try {
                        this.job.signal(5);
                    }
                    catch (GramException e1) {
                        GFacUtils.saveErrorDetails((JobExecutionContext)jobExecutionContext, (String)gssException.getLocalizedMessage(), (CorrectiveAction)CorrectiveAction.CONTACT_SUPPORT, (ErrorCategory)ErrorCategory.AIRAVATA_INTERNAL_ERROR);
                        throw new GFacException("Error while sending commit request. Job Id - " + this.job.getIDAsString(), (Throwable)e1);
                    }
                    catch (GSSException e1) {
                        GFacUtils.saveErrorDetails((JobExecutionContext)jobExecutionContext, (String)gssException.getLocalizedMessage(), (CorrectiveAction)CorrectiveAction.CONTACT_SUPPORT, (ErrorCategory)ErrorCategory.AIRAVATA_INTERNAL_ERROR);
                        throw new GFacException("Error while sending commit request. Job Id - " + this.job.getIDAsString() + ". Credentials provided invalid", (Throwable)e1);
                    }
                }
                GFacUtils.updateJobStatus((JobExecutionContext)jobExecutionContext, (JobDetails)this.details, (JobState)JobState.SUBMITTED);
                jobStatusMessage = "Submitted JobID= " + this.job.getIDAsString();
                log.info(jobStatusMessage);
                jobExecutionContext.getNotifier().publish((GFacEvent)new JobIDEvent(jobStatusMessage));
            }
            catch (GSSException e) {
                GFacUtils.saveErrorDetails((JobExecutionContext)jobExecutionContext, (String)e.getLocalizedMessage(), (CorrectiveAction)CorrectiveAction.RETRY_SUBMISSION, (ErrorCategory)ErrorCategory.AIRAVATA_INTERNAL_ERROR);
                this.reSubmitJob(gateKeeper, jobExecutionContext, globusHostType, e);
            }
            catch (GramException e) {
                GFacUtils.saveErrorDetails((JobExecutionContext)jobExecutionContext, (String)e.getLocalizedMessage(), (CorrectiveAction)CorrectiveAction.CONTACT_SUPPORT, (ErrorCategory)ErrorCategory.AIRAVATA_INTERNAL_ERROR);
                throw new GFacException("An error occurred while submitting a job, job id = " + this.job.getIDAsString(), (Throwable)e);
            }
        } else {
            try {
                this.job.request(true, gateKeeper, false, false);
                this.renewCredentialsAttempt = false;
            }
            catch (GramException e) {
                GFacUtils.saveErrorDetails((JobExecutionContext)jobExecutionContext, (String)e.getLocalizedMessage(), (CorrectiveAction)CorrectiveAction.CONTACT_SUPPORT, (ErrorCategory)ErrorCategory.AIRAVATA_INTERNAL_ERROR);
                throw new GFacException("An error occurred while submitting a job, job id = " + this.job.getIDAsString(), (Throwable)e);
            }
            catch (GSSException e) {
                GFacUtils.saveErrorDetails((JobExecutionContext)jobExecutionContext, (String)e.getLocalizedMessage(), (CorrectiveAction)CorrectiveAction.RETRY_SUBMISSION, (ErrorCategory)ErrorCategory.AIRAVATA_INTERNAL_ERROR);
                this.reSubmitJob(gateKeeper, jobExecutionContext, globusHostType, e);
            }
            String jobStatusMessage = "Un-submitted JobID= " + this.job.getIDAsString();
            log.info(jobStatusMessage);
            jobExecutionContext.getNotifier().publish((GFacEvent)new JobIDEvent(jobStatusMessage));
        }
        currentlyExecutingJobCache.put(this.job.getIDAsString(), this.job);
        this.listener.waitFor();
        this.checkJobStatus(jobExecutionContext, globusHostType, gateKeeper);
    }

    private void renewCredentials(JobExecutionContext jobExecutionContext) throws GFacException {
        this.renewCredentials(this.job, jobExecutionContext);
    }

    private void renewCredentials(GramJob gramJob, JobExecutionContext jobExecutionContext) throws GFacException {
        try {
            GSSCredential gssCred = ((GSISecurityContext)jobExecutionContext.getSecurityContext("gsi")).renewCredentials();
            gramJob.renew(gssCred);
        }
        catch (GramException e1) {
            throw new GFacException("Unable to renew credentials. Job Id - " + gramJob.getIDAsString(), (Throwable)e1);
        }
        catch (GSSException e1) {
            throw new GFacException("Unable to renew credentials. Job Id - " + gramJob.getIDAsString(), (Throwable)e1);
        }
        catch (ApplicationSettingsException e) {
            throw new GFacException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private void reSubmitJob(String gateKeeper, JobExecutionContext jobExecutionContext, GlobusHostType globusHostType, Exception e) throws GFacException, GFacProviderException {
        if (this.renewCredentialsAttempt) {
            throw new GFacException("Error while submitting job - Credentials provided are invalid. Job Id - " + this.job.getIDAsString(), (Throwable)e);
        }
        this.renewCredentialsAttempt = true;
        log.error("Error while submitting job - Credentials provided are invalid. Job Id - " + this.job.getIDAsString(), (Throwable)e);
        log.info("Attempting to renew credentials and re-submit jobs...");
        this.job.removeListener((GramJobListener)this.listener);
        this.listener = new GramJobSubmissionListener(this.job, jobExecutionContext);
        this.job.addListener((GramJobListener)this.listener);
        this.renewCredentials(jobExecutionContext);
        this.submitJobs(gateKeeper, jobExecutionContext, globusHostType);
    }

    private void reSubmitJob(String gateKeeper, JobExecutionContext jobExecutionContext, GlobusHostType globusHostType) throws GFacException, GFacProviderException {
        log.info("Attempting to renew credentials and re-submit jobs...");
        this.job.removeListener((GramJobListener)this.listener);
        this.listener = new GramJobSubmissionListener(this.job, jobExecutionContext);
        this.job.addListener((GramJobListener)this.listener);
        this.renewCredentials(jobExecutionContext);
        this.submitJobs(gateKeeper, jobExecutionContext, globusHostType);
    }

    public void dispose(JobExecutionContext jobExecutionContext) throws GFacProviderException {
    }

    public void cancelJob(String jobId, JobExecutionContext jobExecutionContext) throws GFacException {
        this.cancelSingleJob(jobId, jobExecutionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelSingleJob(String jobId, JobExecutionContext context) throws GFacException {
        if (currentlyExecutingJobCache.containsKey(jobId)) {
            GramProvider gramProvider = this;
            synchronized (gramProvider) {
                GramJob gramJob = currentlyExecutingJobCache.get(jobId);
                if (gramJob != null && (gramJob.getStatus() != 8 || gramJob.getStatus() != 4)) {
                    this.cancelJob(gramJob, context);
                }
            }
        }
        try {
            GSSCredential gssCred = ((GSISecurityContext)context.getSecurityContext("gsi")).getGssCredentials();
            GramJob gramJob = new GramJob(null);
            try {
                gramJob.setID(jobId);
            }
            catch (MalformedURLException e) {
                throw new GFacException("Invalid job id - " + jobId, (Throwable)e);
            }
            gramJob.setCredentials(gssCred);
            GramProvider gramProvider = this;
            synchronized (gramProvider) {
                if (gramJob.getStatus() != 8 || gramJob.getStatus() != 4) {
                    this.cancelJob(gramJob, context);
                }
            }
        }
        catch (ApplicationSettingsException e) {
            throw new GFacException((Exception)((Object)e));
        }
    }

    private void cancelJob(GramJob gramJob, JobExecutionContext context) throws GFacException {
        try {
            gramJob.cancel();
        }
        catch (GramException e) {
            throw new GFacException("Error cancelling job, id - " + gramJob.getIDAsString(), (Throwable)e);
        }
        catch (GSSException e) {
            log.warn("Credentials invalid to cancel job. Attempting to renew credentials and re-try. Job id - " + gramJob.getIDAsString());
            this.renewCredentials(gramJob, context);
            try {
                gramJob.cancel();
                gramJob.signal(10);
            }
            catch (GramException e1) {
                throw new GFacException("Error cancelling job, id - " + gramJob.getIDAsString(), (Throwable)e1);
            }
            catch (GSSException e1) {
                throw new GFacException("Error cancelling job, invalid credentials. Job id - " + gramJob.getIDAsString(), (Throwable)e);
            }
        }
    }

    public void initProperties(Map<String, String> properties) throws GFacException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkJobStatus(JobExecutionContext jobExecutionContext, GlobusHostType host, String gateKeeper) throws GFacProviderException {
        int jobStatus = this.listener.getCurrentStatus();
        if (jobStatus == 4) {
            String errorMsg = "Job " + this.job.getIDAsString() + " on host " + host.getHostAddress() + " Job Exit Code = " + this.listener.getError() + " Error Description = " + this.getGramErrorString(this.listener.getError());
            if (this.listener.getError() == 24) {
                if (!this.reSubmissionInProgress) {
                    this.reSubmissionInProgress = true;
                    log.info("Invalid script reply received. Re-submitting job, id - " + this.job.getIDAsString());
                    try {
                        this.reSubmitJob(gateKeeper, jobExecutionContext, host);
                    }
                    catch (GFacException e) {
                        throw new GFacProviderException("Error during re-submission. Original job submission data - " + errorMsg, (Throwable)e);
                    }
                    return;
                }
            } else if (this.listener.getError() == 7) {
                if (!this.authorisationFailedAttempt) {
                    this.authorisationFailedAttempt = true;
                    log.info("Authorisation error contacting provider. Re-submitting job with renewed credentials.");
                    try {
                        this.renewCredentials(jobExecutionContext);
                        this.reSubmitJob(gateKeeper, jobExecutionContext, host);
                    }
                    catch (GFacException e) {
                        throw new GFacProviderException("Error during re-submission. Original job submission data - " + errorMsg, (Throwable)e);
                    }
                    return;
                }
            } else if (this.listener.getError() == 8) {
                log.info("User successfully cancelled job id " + this.job.getIDAsString());
                return;
            }
            log.error(errorMsg);
            GramProvider gramProvider = this;
            synchronized (gramProvider) {
                currentlyExecutingJobCache.remove(this.job.getIDAsString());
            }
            throw new JobSubmissionFault((Throwable)new Exception(errorMsg), host.getHostAddress(), gateKeeper, this.job.getRSL(), jobExecutionContext, this.getGramErrorString(this.listener.getError()), this.listener.getError());
        }
        if (jobStatus == 8) {
            log.info("Job " + this.job.getIDAsString() + " on host " + host.getHostAddress() + " is successfully executed.");
            GramProvider gramProvider = this;
            synchronized (gramProvider) {
                currentlyExecutingJobCache.remove(this.job.getIDAsString());
            }
        }
    }

    public String getGramErrorString(int errorCode) {
        if (resources != null) {
            try {
                return resources.getProperty(String.valueOf(errorCode));
            }
            catch (MissingResourceException mre) {
                log.warn("Error reading globus error descriptions.", (Throwable)mre);
                return "Error code: " + errorCode;
            }
        }
        return "Error code: " + errorCode;
    }

    static {
        try {
            String propFileName = "errors.properties";
            resources = new Properties();
            InputStream inputStream = GramProvider.class.getClassLoader().getResourceAsStream(propFileName);
            if (inputStream == null) {
                throw new FileNotFoundException("property file '" + propFileName + "' not found in the classpath");
            }
            resources.load(inputStream);
        }
        catch (FileNotFoundException mre) {
            log.error("errors.properties not found", (Throwable)mre);
        }
        catch (IOException e) {
            log.error("Error reading errors.properties file", (Throwable)e);
        }
    }
}

