/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.gram.persistence;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.airavata.common.utils.DBUtil;
import org.apache.airavata.gfac.GFacException;
import org.apache.airavata.gfac.core.persistence.JobData;
import org.apache.airavata.gfac.core.persistence.JobPersistenceManager;
import org.apache.log4j.Logger;

public class DBJobPersistenceManager
implements JobPersistenceManager {
    private DBUtil dbUtil;
    private static final Logger log = Logger.getLogger(DBJobPersistenceManager.class);

    public DBJobPersistenceManager(DBUtil db) {
        this.dbUtil = db;
    }

    public synchronized void updateJobStatus(JobData jobData) throws GFacException {
        if (jobData.getState() == 32) {
            this.insertJob(jobData);
        } else {
            String sql = "update gram_job set status = ? where job_id = ?";
            Connection connection = null;
            PreparedStatement stmt = null;
            try {
                connection = this.getConnection();
                stmt = connection.prepareStatement(sql);
                stmt.setInt(1, jobData.getState());
                stmt.setString(2, jobData.getJobId());
                stmt.executeUpdate();
                connection.commit();
            }
            catch (SQLException e) {
                throw new GFacException((Exception)e);
            }
            finally {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (SQLException e) {
                    log.error((Object)"Error closing streams", (Throwable)e);
                }
            }
        }
    }

    private void insertJob(JobData jobData) throws GFacException {
        String sql = "insert into gram_job values (?, ?)";
        PreparedStatement stmt = null;
        Connection connection = null;
        try {
            connection = this.getConnection();
            stmt = connection.prepareStatement(sql);
            stmt.setString(1, jobData.getJobId());
            stmt.setInt(2, jobData.getState());
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new GFacException((Exception)e);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"Error closing streams", (Throwable)e);
            }
        }
    }

    public List<JobData> getRunningJobs() throws GFacException {
        String sql = "select * from gram_job where status not in (?, ?, ?)";
        int[] statuses = new int[]{32, 8, 4};
        return this.getJobs(sql, statuses);
    }

    public List<JobData> getFailedJobs() throws GFacException {
        String sql = "select * from gram_job where status in (?)";
        int[] statuses = new int[]{4};
        return this.getJobs(sql, statuses);
    }

    public List<JobData> getUnSubmittedJobs() throws GFacException {
        String sql = "select * from gram_job where status in (?)";
        int[] statuses = new int[]{32};
        return this.getJobs(sql, statuses);
    }

    public List<JobData> getSuccessfullyCompletedJobs() throws GFacException {
        String sql = "select * from gram_job where status in (?)";
        int[] statuses = new int[]{8};
        return this.getJobs(sql, statuses);
    }

    protected List<JobData> getJobs(String sql, int[] statuses) throws GFacException {
        ArrayList<JobData> jobs = new ArrayList<JobData>();
        PreparedStatement preparedStatement = null;
        Connection connection = null;
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement(sql);
            int index = 1;
            for (int status : statuses) {
                preparedStatement.setInt(index, status);
                ++index;
            }
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String jobId = resultSet.getString("job_id");
                int state = resultSet.getInt("status");
                jobs.add(new JobData(jobId, state));
            }
        }
        catch (SQLException e) {
            throw new GFacException((Exception)e);
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"Error closing connection", (Throwable)e);
            }
        }
        return jobs;
    }

    private synchronized Connection getConnection() throws SQLException {
        Connection connection = this.dbUtil.getConnection();
        connection.setAutoCommit(true);
        return connection;
    }
}

