/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.gram.handler;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.StringUtil;
import org.apache.airavata.commons.gfac.type.ActualParameter;
import org.apache.airavata.commons.gfac.type.ApplicationDescription;
import org.apache.airavata.commons.gfac.type.MappingFactory;
import org.apache.airavata.gfac.GFacException;
import org.apache.airavata.gfac.ToolsException;
import org.apache.airavata.gfac.core.context.JobExecutionContext;
import org.apache.airavata.gfac.core.context.MessageContext;
import org.apache.airavata.gfac.core.handler.AbstractHandler;
import org.apache.airavata.gfac.core.handler.GFacHandlerException;
import org.apache.airavata.gfac.core.provider.GFacProviderException;
import org.apache.airavata.gfac.core.utils.GFacUtils;
import org.apache.airavata.gfac.core.utils.OutputUtils;
import org.apache.airavata.gfac.gram.external.GridFtp;
import org.apache.airavata.gfac.gram.security.GSISecurityContext;
import org.apache.airavata.gfac.gram.util.GramProviderUtils;
import org.apache.airavata.model.workspace.experiment.CorrectiveAction;
import org.apache.airavata.model.workspace.experiment.DataTransferDetails;
import org.apache.airavata.model.workspace.experiment.ErrorCategory;
import org.apache.airavata.model.workspace.experiment.TaskDetails;
import org.apache.airavata.model.workspace.experiment.TransferState;
import org.apache.airavata.model.workspace.experiment.TransferStatus;
import org.apache.airavata.registry.cpi.ChildDataType;
import org.apache.airavata.registry.cpi.Registry;
import org.apache.airavata.schemas.gfac.ApplicationDeploymentDescriptionType;
import org.apache.airavata.schemas.gfac.GlobusHostType;
import org.apache.airavata.schemas.gfac.HostDescriptionType;
import org.apache.airavata.schemas.gfac.StringArrayType;
import org.apache.airavata.schemas.gfac.URIArrayType;
import org.apache.airavata.schemas.gfac.URIParameterType;
import org.apache.airavata.schemas.gfac.UnicoreHostType;
import org.ietf.jgss.GSSCredential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GridFTPOutputHandler
extends AbstractHandler {
    private static final Logger log = LoggerFactory.getLogger(GridFTPOutputHandler.class);
    private Registry registry;

    public void invoke(JobExecutionContext jobExecutionContext) throws GFacHandlerException {
        log.info("Invoking GridFTPOutputHandler ...");
        super.invoke(jobExecutionContext);
        ApplicationDeploymentDescriptionType app = jobExecutionContext.getApplicationContext().getApplicationDeploymentDescription().getType();
        HostDescriptionType hostType = jobExecutionContext.getApplicationContext().getHostDescription().getType();
        String[] gridFTPEndpointArray = null;
        String hostName = null;
        if (jobExecutionContext.getApplicationContext().getHostDescription().getType() instanceof GlobusHostType) {
            gridFTPEndpointArray = ((GlobusHostType)hostType).getGridFTPEndPointArray();
            hostName = ((GlobusHostType)hostType).getHostName();
        } else if (jobExecutionContext.getApplicationContext().getHostDescription().getType() instanceof UnicoreHostType) {
            gridFTPEndpointArray = ((UnicoreHostType)hostType).getGridFTPEndPointArray();
            hostName = ((UnicoreHostType)hostType).getHostName();
        }
        GridFtp ftp = new GridFtp();
        File localStdErrFile = null;
        HashMap<String, ActualParameter> stringMap = new HashMap<String, ActualParameter>();
        DataTransferDetails detail = new DataTransferDetails();
        TransferStatus status = new TransferStatus();
        try {
            GSSCredential gssCred = ((GSISecurityContext)jobExecutionContext.getSecurityContext("gsi")).getGssCredentials();
            String[] hostgridFTP = gridFTPEndpointArray;
            if (hostgridFTP == null || hostgridFTP.length == 0) {
                hostgridFTP = new String[]{hostName};
            }
            for (String endpoint : gridFTPEndpointArray) {
                try {
                    String outputDataDirectory;
                    URI stdoutURI = GramProviderUtils.createGsiftpURI(endpoint, app.getStandardOutput());
                    URI stderrURI = GramProviderUtils.createGsiftpURI(endpoint, app.getStandardError());
                    status.setTransferState(TransferState.COMPLETE);
                    detail.setTransferStatus(status);
                    detail.setTransferDescription("STDOUT:" + stdoutURI.toString());
                    this.registry.add(ChildDataType.DATA_TRANSFER_DETAIL, (Object)detail, (Object)jobExecutionContext.getTaskData().getTaskID());
                    status.setTransferState(TransferState.COMPLETE);
                    detail.setTransferStatus(status);
                    detail.setTransferDescription("STDERR:" + stderrURI.toString());
                    this.registry.add(ChildDataType.DATA_TRANSFER_DETAIL, (Object)detail, (Object)jobExecutionContext.getTaskData().getTaskID());
                    log.info("STDOUT:" + stdoutURI.toString());
                    log.info("STDERR:" + stderrURI.toString());
                    File logDir = new File("./service_logs");
                    if (!logDir.exists()) {
                        logDir.mkdir();
                    }
                    String timeStampedServiceName = GFacUtils.createUniqueNameForService((String)jobExecutionContext.getServiceName());
                    File localStdOutFile = File.createTempFile(timeStampedServiceName, "stdout");
                    localStdErrFile = File.createTempFile(timeStampedServiceName, "stderr");
                    String stdout = null;
                    String stderr = null;
                    try {
                        stdout = ftp.readRemoteFile(stdoutURI, gssCred, localStdOutFile);
                        stderr = ftp.readRemoteFile(stderrURI, gssCred, localStdErrFile);
                        ApplicationDescription application = jobExecutionContext.getApplicationContext().getApplicationDeploymentDescription();
                        ApplicationDeploymentDescriptionType appDesc = application.getType();
                        appDesc.setStandardOutput(stdout);
                        appDesc.setStandardError(stderr);
                        jobExecutionContext.getApplicationContext().setApplicationDeploymentDescription(application);
                    }
                    catch (ToolsException e) {
                        log.error("Cannot download stdout/err files. One reason could be the job is not successfully finished:  " + e.getMessage());
                    }
                    ArrayList outputArray = new ArrayList();
                    Map output = jobExecutionContext.getOutMessageContext().getParameters();
                    Set keys = output.keySet();
                    for (String paramName : keys) {
                        Object valueList;
                        List<String> outputList;
                        URI outputURI;
                        ActualParameter actualParameter = (ActualParameter)output.get(paramName);
                        if ("URIArray".equals(actualParameter.getType().getType().toString())) {
                            outputURI = GramProviderUtils.createGsiftpURI(endpoint, app.getOutputDataDirectory());
                            outputList = ftp.listDir(outputURI, gssCred);
                            valueList = outputList.toArray(new String[outputList.size()]);
                            ((URIArrayType)actualParameter.getType()).setValueArray(valueList);
                            stringMap.put(paramName, actualParameter);
                        } else if ("StringArray".equals(actualParameter.getType().getType().toString())) {
                            String[] valueList2 = OutputUtils.parseStdoutArray((String)stdout, (String)paramName);
                            ((StringArrayType)actualParameter.getType()).setValueArray(valueList2);
                            stringMap.put(paramName, actualParameter);
                        } else if ("URI".equals(actualParameter.getType().getType().toString())) {
                            outputURI = GramProviderUtils.createGsiftpURI(endpoint, app.getOutputDataDirectory());
                            outputList = ftp.listDir(outputURI, gssCred);
                            if (outputList.size() == 0 || outputList.get(0).isEmpty()) {
                                OutputUtils.fillOutputFromStdout((Map)output, (String)stdout, (String)stderr, outputArray);
                            } else {
                                valueList = outputList.get(0);
                                ((URIParameterType)actualParameter.getType()).setValue((String)valueList);
                                stringMap = new HashMap();
                                stringMap.put(paramName, actualParameter);
                            }
                        } else {
                            OutputUtils.fillOutputFromStdout((Map)output, (String)stdout, (String)stderr, outputArray);
                        }
                        status.setTransferState(TransferState.DOWNLOAD);
                        detail.setTransferStatus(status);
                        detail.setTransferDescription("Output: " + ((ActualParameter)stringMap.get(paramName)).toString());
                        this.registry.add(ChildDataType.DATA_TRANSFER_DETAIL, (Object)detail, (Object)jobExecutionContext.getTaskData().getTaskID());
                    }
                    if (outputArray == null || outputArray.isEmpty()) {
                        throw new GFacHandlerException("Empty Output returned from the Application, Double check the applicationand ApplicationDescriptor output Parameter Names");
                    }
                    TaskDetails taskData = jobExecutionContext.getTaskData();
                    if (taskData == null || taskData.getAdvancedOutputDataHandling() == null || (outputDataDirectory = taskData.getAdvancedOutputDataHandling().getOutputDataDir()) == null || "".equals(outputDataDirectory)) continue;
                    GridFTPOutputHandler.stageOutputFiles(jobExecutionContext, outputDataDirectory);
                }
                catch (ToolsException e) {
                    log.error(e.getMessage());
                    throw new GFacHandlerException(e.getMessage() + "\n StdError Data: \n" + GridFTPOutputHandler.readLastLinesofStdOut(localStdErrFile.getPath(), 20), (Throwable)e);
                }
                catch (URISyntaxException e) {
                    log.error(e.getMessage());
                    throw new GFacHandlerException("URI is malformatted:" + e.getMessage(), (Exception)e, new String[]{GridFTPOutputHandler.readLastLinesofStdOut(localStdErrFile.getPath(), 20)});
                }
            }
        }
        catch (Exception e) {
            try {
                status.setTransferState(TransferState.FAILED);
                detail.setTransferStatus(status);
                this.registry.add(ChildDataType.DATA_TRANSFER_DETAIL, (Object)detail, (Object)jobExecutionContext.getTaskData().getTaskID());
                GFacUtils.saveErrorDetails((JobExecutionContext)jobExecutionContext, (String)e.getLocalizedMessage(), (CorrectiveAction)CorrectiveAction.CONTACT_SUPPORT, (ErrorCategory)ErrorCategory.FILE_SYSTEM_FAILURE);
            }
            catch (Exception e1) {
                throw new GFacHandlerException("Error persisting status", e1, new String[]{e1.getLocalizedMessage()});
            }
            log.error(e.getMessage());
            throw new GFacHandlerException(e.getMessage(), e, new String[]{GridFTPOutputHandler.readLastLinesofStdOut(localStdErrFile.getPath(), 20)});
        }
    }

    private static String readLastLinesofStdOut(String path, int count) {
        int i;
        StringBuffer buffer = new StringBuffer();
        FileInputStream in = null;
        try {
            in = new FileInputStream(path);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        ArrayList<String> strLine = new ArrayList<String>();
        String tmp = null;
        int numberofLines = 0;
        try {
            while ((tmp = br.readLine()) != null) {
                strLine.add(tmp);
                ++numberofLines;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (numberofLines > count) {
            for (i = numberofLines - count; i < numberofLines; ++i) {
                buffer.append((String)strLine.get(i));
                buffer.append("\n");
            }
        } else {
            for (i = 0; i < numberofLines; ++i) {
                buffer.append((String)strLine.get(i));
                buffer.append("\n");
            }
        }
        try {
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return buffer.toString();
    }

    private static void stageOutputFiles(JobExecutionContext jobExecutionContext, String outputFileStagingPath) throws GFacProviderException, GFacException, ApplicationSettingsException {
        HostDescriptionType hostType = jobExecutionContext.getApplicationContext().getHostDescription().getType();
        String[] gridFTPEndpointArray = null;
        if (jobExecutionContext.getApplicationContext().getHostDescription().getType() instanceof GlobusHostType) {
            gridFTPEndpointArray = ((GlobusHostType)hostType).getGridFTPEndPointArray();
        } else if (jobExecutionContext.getApplicationContext().getHostDescription().getType() instanceof UnicoreHostType) {
            gridFTPEndpointArray = ((UnicoreHostType)hostType).getGridFTPEndPointArray();
        }
        MessageContext outputNew = new MessageContext();
        MessageContext output = jobExecutionContext.getOutMessageContext();
        Map parameters = output.getParameters();
        for (String paramName : parameters.keySet()) {
            ActualParameter actualParameter = (ActualParameter)parameters.get(paramName);
            GridFtp ftp = new GridFtp();
            GSSCredential gssCred = ((GSISecurityContext)jobExecutionContext.getSecurityContext("gsi")).getGssCredentials();
            try {
                if ("URI".equals(actualParameter.getType().getType().toString())) {
                    for (String endpoint : gridFTPEndpointArray) {
                        ((URIParameterType)actualParameter.getType()).setValue(GridFTPOutputHandler.doStaging(outputFileStagingPath, MappingFactory.toString((ActualParameter)actualParameter), ftp, gssCred, endpoint));
                    }
                } else if ("URIArray".equals(actualParameter.getType().getType().toString())) {
                    List<String> split = Arrays.asList(StringUtil.getElementsFromString((String)MappingFactory.toString((ActualParameter)actualParameter)));
                    ArrayList<String> newFiles = new ArrayList<String>();
                    for (String endpoint : gridFTPEndpointArray) {
                        for (String paramValueEach : split) {
                            newFiles.add(GridFTPOutputHandler.doStaging(outputFileStagingPath, paramValueEach, ftp, gssCred, endpoint));
                        }
                        ((URIArrayType)actualParameter.getType()).setValueArray(newFiles.toArray(new String[newFiles.size()]));
                    }
                }
            }
            catch (URISyntaxException e) {
                log.error(e.getMessage());
                throw new GFacProviderException(e.getMessage(), (Throwable)e);
            }
            catch (ToolsException e) {
                log.error(e.getMessage());
                throw new GFacProviderException(e.getMessage(), (Throwable)e);
            }
            outputNew.getParameters().put(paramName, actualParameter);
        }
        jobExecutionContext.setOutMessageContext(outputNew);
    }

    private static String doStaging(String outputFileStagingPath, String paramValue, GridFtp ftp, GSSCredential gssCred, String endpoint) throws URISyntaxException, ToolsException {
        URI srcURI = GramProviderUtils.createGsiftpURI(endpoint, paramValue);
        String fileName = new File(srcURI.getPath()).getName();
        File outputpath = new File(outputFileStagingPath);
        if (!outputpath.exists()) {
            outputpath.mkdirs();
        }
        File outputFile = new File(outputpath.getAbsolutePath() + File.separator + fileName);
        ftp.readRemoteFile(srcURI, gssCred, outputFile);
        return outputFileStagingPath + File.separator + fileName;
    }

    public void initProperties(Properties properties) throws GFacHandlerException {
    }
}

