/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.gram.handler;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.StringUtil;
import org.apache.airavata.commons.gfac.type.ActualParameter;
import org.apache.airavata.commons.gfac.type.MappingFactory;
import org.apache.airavata.gfac.GFacException;
import org.apache.airavata.gfac.ToolsException;
import org.apache.airavata.gfac.core.context.JobExecutionContext;
import org.apache.airavata.gfac.core.context.MessageContext;
import org.apache.airavata.gfac.core.handler.AbstractHandler;
import org.apache.airavata.gfac.core.handler.AppDescriptorCheckHandler;
import org.apache.airavata.gfac.core.handler.GFacHandlerException;
import org.apache.airavata.gfac.core.utils.GFacUtils;
import org.apache.airavata.gfac.gram.external.GridFtp;
import org.apache.airavata.gfac.gram.security.GSISecurityContext;
import org.apache.airavata.gfac.gram.util.GramProviderUtils;
import org.apache.airavata.model.workspace.experiment.CorrectiveAction;
import org.apache.airavata.model.workspace.experiment.DataTransferDetails;
import org.apache.airavata.model.workspace.experiment.ErrorCategory;
import org.apache.airavata.model.workspace.experiment.TransferState;
import org.apache.airavata.model.workspace.experiment.TransferStatus;
import org.apache.airavata.registry.cpi.ChildDataType;
import org.apache.airavata.schemas.gfac.ApplicationDeploymentDescriptionType;
import org.apache.airavata.schemas.gfac.GlobusHostType;
import org.apache.airavata.schemas.gfac.HostDescriptionType;
import org.apache.airavata.schemas.gfac.URIArrayType;
import org.apache.airavata.schemas.gfac.URIParameterType;
import org.apache.airavata.schemas.gfac.UnicoreHostType;
import org.ietf.jgss.GSSCredential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GridFTPInputHandler
extends AbstractHandler {
    private static final Logger log = LoggerFactory.getLogger(AppDescriptorCheckHandler.class);

    public void invoke(JobExecutionContext jobExecutionContext) throws GFacHandlerException {
        log.info("Invoking GridFTPInputHandler ...");
        super.invoke(jobExecutionContext);
        DataTransferDetails detail = new DataTransferDetails();
        TransferStatus status = new TransferStatus();
        MessageContext inputNew = new MessageContext();
        try {
            MessageContext input = jobExecutionContext.getInMessageContext();
            Set parameters = input.getParameters().keySet();
            for (String paramName : parameters) {
                ActualParameter actualParameter = (ActualParameter)input.getParameters().get(paramName);
                String paramValue = MappingFactory.toString((ActualParameter)actualParameter);
                if ("URI".equals(actualParameter.getType().getType().toString())) {
                    ((URIParameterType)actualParameter.getType()).setValue(GridFTPInputHandler.stageInputFiles(jobExecutionContext, paramValue));
                } else if ("URIArray".equals(actualParameter.getType().getType().toString())) {
                    List<String> split = Arrays.asList(StringUtil.getElementsFromString((String)paramValue));
                    ArrayList<String> newFiles = new ArrayList<String>();
                    for (String paramValueEach : split) {
                        String stageInputFiles = GridFTPInputHandler.stageInputFiles(jobExecutionContext, paramValueEach);
                        detail.setTransferDescription("Input Data Staged: " + stageInputFiles);
                        status.setTransferState(TransferState.UPLOAD);
                        detail.setTransferStatus(status);
                        this.registry.add(ChildDataType.DATA_TRANSFER_DETAIL, (Object)detail, (Object)jobExecutionContext.getTaskData().getTaskID());
                        newFiles.add(stageInputFiles);
                    }
                    ((URIArrayType)actualParameter.getType()).setValueArray(newFiles.toArray(new String[newFiles.size()]));
                }
                inputNew.getParameters().put(paramName, actualParameter);
            }
        }
        catch (Exception e) {
            try {
                status.setTransferState(TransferState.FAILED);
                detail.setTransferStatus(status);
                this.registry.add(ChildDataType.DATA_TRANSFER_DETAIL, (Object)detail, (Object)jobExecutionContext.getTaskData().getTaskID());
                GFacUtils.saveErrorDetails((JobExecutionContext)jobExecutionContext, (String)e.getLocalizedMessage(), (CorrectiveAction)CorrectiveAction.CONTACT_SUPPORT, (ErrorCategory)ErrorCategory.FILE_SYSTEM_FAILURE);
            }
            catch (Exception e1) {
                throw new GFacHandlerException("Error persisting status", e1, new String[]{e1.getLocalizedMessage()});
            }
            log.error(e.getMessage());
            throw new GFacHandlerException("Error while input File Staging", e, new String[]{e.getLocalizedMessage()});
        }
        jobExecutionContext.setInMessageContext(inputNew);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String stageInputFiles(JobExecutionContext jobExecutionContext, String paramValue) throws URISyntaxException, SecurityException, ToolsException, IOException, GFacException, ApplicationSettingsException {
        URI gridftpURL = new URI(paramValue);
        String[] gridFTPEndpointArray = null;
        boolean isInputNonLocal = true;
        HostDescriptionType hostType = jobExecutionContext.getApplicationContext().getHostDescription().getType();
        if (jobExecutionContext.getApplicationContext().getHostDescription().getType() instanceof GlobusHostType) {
            gridFTPEndpointArray = ((GlobusHostType)hostType).getGridFTPEndPointArray();
        } else if (jobExecutionContext.getApplicationContext().getHostDescription().getType() instanceof UnicoreHostType) {
            gridFTPEndpointArray = ((UnicoreHostType)hostType).getGridFTPEndPointArray();
            isInputNonLocal = false;
        }
        ApplicationDeploymentDescriptionType app = jobExecutionContext.getApplicationContext().getApplicationDeploymentDescription().getType();
        GridFtp ftp = new GridFtp();
        URI destURI = null;
        GSSCredential gssCred = ((GSISecurityContext)jobExecutionContext.getSecurityContext("gsi")).getGssCredentials();
        for (String endpoint : gridFTPEndpointArray) {
            URI inputURI = GramProviderUtils.createGsiftpURI(endpoint, app.getInputDataDirectory());
            String fileName = new File(gridftpURL.getPath()).getName();
            fileName = ftp.gridFTPFileExist(inputURI, fileName, gssCred);
            String destLocalPath = inputURI.getPath() + File.separator + fileName;
            if (fileName != null && !"".equals(fileName)) {
                destURI = GramProviderUtils.createGsiftpURI(endpoint, destLocalPath);
                if (paramValue.startsWith("gsiftp")) {
                    if (isInputNonLocal) {
                        ftp.uploadFile(gridftpURL, destURI, gssCred);
                        continue;
                    }
                    return paramValue;
                }
                if (paramValue.startsWith("file")) {
                    String localFile = paramValue.substring(paramValue.indexOf(":") + 1, paramValue.length());
                    FileInputStream fis = null;
                    try {
                        fis = new FileInputStream(localFile);
                        ftp.uploadFile(destURI, gssCred, fis);
                        continue;
                    }
                    catch (IOException e) {
                        throw new GFacException("Unable to create file : " + localFile, (Throwable)e);
                    }
                    finally {
                        if (fis != null) {
                            fis.close();
                        }
                    }
                }
                if (paramValue.startsWith("http")) {
                    if (isInputNonLocal) {
                        InputStream is = null;
                        try {
                            is = gridftpURL.toURL().openStream();
                            ftp.uploadFile(destURI, gssCred, is);
                            continue;
                        }
                        finally {
                            is.close();
                        }
                    }
                    return paramValue;
                }
                return paramValue;
            }
            return paramValue;
        }
        return destURI.getPath();
    }

    public void initProperties(Properties properties) throws GFacHandlerException {
    }
}

