/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.gram.external;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import org.apache.airavata.gfac.Constants;
import org.apache.airavata.gfac.ToolsException;
import org.apache.airavata.gfac.gram.util.GramProviderUtils;
import org.apache.airavata.gfac.gram.util.GridFTPContactInfo;
import org.globus.ftp.DataChannelAuthentication;
import org.globus.ftp.DataSource;
import org.globus.ftp.DataSourceStream;
import org.globus.ftp.FTPClient;
import org.globus.ftp.FileInfo;
import org.globus.ftp.GridFTPClient;
import org.globus.ftp.HostPort;
import org.globus.ftp.Marker;
import org.globus.ftp.MarkerListener;
import org.globus.ftp.MlsxEntry;
import org.globus.ftp.exception.ClientException;
import org.globus.ftp.exception.ServerException;
import org.globus.gsi.gssapi.auth.Authorization;
import org.globus.gsi.gssapi.auth.HostAuthorization;
import org.ietf.jgss.GSSCredential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GridFtp {
    public static final Logger log = LoggerFactory.getLogger(GridFtp.class);
    public static final String GSIFTP_SCHEME = "gsiftp";
    public static final String HOST = "host";

    public void makeDir(URI destURI, GSSCredential gssCred) throws ToolsException {
        GridFTPClient destClient = null;
        GridFTPContactInfo destHost = new GridFTPContactInfo(destURI.getHost(), destURI.getPort());
        try {
            String destPath = destURI.getPath();
            log.info("Creating Directory = " + destHost + "=" + destPath);
            destClient = new GridFTPClient(destHost.hostName, destHost.port);
            int tryCount = 0;
            while (true) {
                try {
                    destClient.setAuthorization((Authorization)new HostAuthorization(HOST));
                    destClient.authenticate(gssCred);
                    destClient.setDataChannelAuthentication(DataChannelAuthentication.SELF);
                    if (!destClient.exists(destPath)) {
                        destClient.makeDir(destPath);
                    }
                }
                catch (ServerException e) {
                    if (++tryCount >= 3) {
                        throw new ToolsException(e.getMessage(), (Throwable)e);
                    }
                    Thread.sleep(10000L);
                    continue;
                }
                catch (IOException e) {
                    if (++tryCount >= 3) {
                        throw new ToolsException(e.getMessage(), (Throwable)e);
                    }
                    Thread.sleep(10000L);
                    continue;
                }
                break;
            }
        }
        catch (ServerException e) {
            throw new ToolsException("Cannot Create GridFTP Client to:" + destHost.toString(), (Throwable)e);
        }
        catch (IOException e) {
            throw new ToolsException("Cannot Create GridFTP Client to:" + destHost.toString(), (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new ToolsException("Internal Error cannot sleep", (Throwable)e);
        }
        finally {
            if (destClient != null) {
                try {
                    destClient.close();
                }
                catch (Exception e) {
                    log.warn("Cannot close GridFTP client connection", (Throwable)e);
                }
            }
        }
    }

    public void uploadFile(URI destURI, GSSCredential gsCredential, InputStream io) throws ToolsException {
        GridFTPClient ftpClient = null;
        GridFTPContactInfo contactInfo = new GridFTPContactInfo(destURI.getHost(), destURI.getPort());
        try {
            String remoteFile = destURI.getPath();
            log.info("The remote file is " + remoteFile);
            log.debug("Setup GridFTP Client");
            ftpClient = new GridFTPClient(contactInfo.hostName, contactInfo.port);
            ftpClient.setAuthorization((Authorization)new HostAuthorization(HOST));
            ftpClient.authenticate(gsCredential);
            ftpClient.setDataChannelAuthentication(DataChannelAuthentication.SELF);
            log.info("Uploading file");
            if (GridFtp.checkBinaryExtensions(remoteFile)) {
                log.debug("Transfer mode is set to Binary for a file upload");
                ftpClient.setType(1);
            }
            ftpClient.put(remoteFile, (DataSource)new DataSourceStream(io), new MarkerListener(){

                public void markerArrived(Marker marker) {
                }
            });
            log.info("Upload file to:" + remoteFile + " is done");
        }
        catch (ServerException e) {
            throw new ToolsException("Cannot upload file to GridFTP:" + contactInfo.toString(), (Throwable)e);
        }
        catch (IOException e) {
            throw new ToolsException("Cannot upload file to GridFTP:" + contactInfo.toString(), (Throwable)e);
        }
        catch (ClientException e) {
            throw new ToolsException("Cannot upload file to GridFTP:" + contactInfo.toString(), (Throwable)e);
        }
        finally {
            if (ftpClient != null) {
                try {
                    ftpClient.close();
                }
                catch (Exception e) {
                    log.warn("Cannot close GridFTP client connection", (Throwable)e);
                }
            }
        }
    }

    public void uploadFile(URI srcURI, URI destURI, GSSCredential gsCredential) throws ToolsException {
        GridFTPClient srcClient = null;
        GridFTPContactInfo destContactInfo = new GridFTPContactInfo(destURI.getHost(), destURI.getPort());
        GridFTPContactInfo srcContactInfo = new GridFTPContactInfo(srcURI.getHost(), srcURI.getPort());
        try {
            String remoteFile = destURI.getPath();
            log.info("The remote file is " + remoteFile);
            log.debug("Setup GridFTP Client");
            srcClient = new GridFTPClient(srcContactInfo.hostName, srcContactInfo.port);
            srcClient.setAuthorization((Authorization)new HostAuthorization(HOST));
            srcClient.authenticate(gsCredential);
            srcClient.setDataChannelAuthentication(DataChannelAuthentication.SELF);
            GridFTPClient destClient = new GridFTPClient(destContactInfo.hostName, destContactInfo.port);
            destClient.setAuthorization((Authorization)new HostAuthorization(HOST));
            destClient.authenticate(gsCredential);
            destClient.setDataChannelAuthentication(DataChannelAuthentication.SELF);
            log.debug("Uploading file");
            if (GridFtp.checkBinaryExtensions(remoteFile)) {
                log.debug("Transfer mode is set to Binary for a file upload");
                srcClient.setType(1);
            }
            srcClient.transfer(srcURI.getPath(), (FTPClient)destClient, remoteFile, false, null);
            log.info("Upload file to:" + remoteFile + " is done");
        }
        catch (ServerException e) {
            throw new ToolsException("Cannot upload file to GridFTP:" + destContactInfo.toString(), (Throwable)e);
        }
        catch (IOException e) {
            throw new ToolsException("Cannot upload file to GridFTP:" + destContactInfo.toString(), (Throwable)e);
        }
        catch (ClientException e) {
            throw new ToolsException("Cannot upload file to GridFTP:" + destContactInfo.toString(), (Throwable)e);
        }
        finally {
            if (srcClient != null) {
                try {
                    srcClient.close();
                }
                catch (Exception e) {
                    log.warn("Cannot close GridFTP client connection", (Throwable)e);
                }
            }
        }
    }

    public void uploadFile(URI destURI, GSSCredential gsCredential, File localFile) throws ToolsException {
        GridFTPClient ftpClient = null;
        GridFTPContactInfo contactInfo = new GridFTPContactInfo(destURI.getHost(), destURI.getPort());
        try {
            String remoteFile = destURI.getPath();
            log.info("The local temp file is " + localFile);
            log.info("the remote file is " + remoteFile);
            log.debug("Setup GridFTP Client");
            ftpClient = new GridFTPClient(contactInfo.hostName, contactInfo.port);
            ftpClient.setAuthorization((Authorization)new HostAuthorization(HOST));
            ftpClient.authenticate(gsCredential);
            ftpClient.setDataChannelAuthentication(DataChannelAuthentication.SELF);
            log.debug("Uploading file");
            if (GridFtp.checkBinaryExtensions(remoteFile)) {
                log.debug("Transfer mode is set to Binary for a file upload");
                ftpClient.setType(1);
            }
            ftpClient.put(localFile, remoteFile, false);
            log.info("Upload file to:" + remoteFile + " is done");
        }
        catch (ServerException e) {
            throw new ToolsException("Cannot upload file to GridFTP:" + contactInfo.toString(), (Throwable)e);
        }
        catch (IOException e) {
            throw new ToolsException("Cannot upload file to GridFTP:" + contactInfo.toString(), (Throwable)e);
        }
        catch (ClientException e) {
            throw new ToolsException("Cannot upload file to GridFTP:" + contactInfo.toString(), (Throwable)e);
        }
        finally {
            if (ftpClient != null) {
                try {
                    ftpClient.close();
                }
                catch (Exception e) {
                    log.warn("Cannot close GridFTP client connection", (Throwable)e);
                }
            }
        }
    }

    public void downloadFile(URI destURI, GSSCredential gsCredential, File localFile) throws ToolsException {
        GridFTPClient ftpClient = null;
        GridFTPContactInfo contactInfo = new GridFTPContactInfo(destURI.getHost(), destURI.getPort());
        try {
            String remoteFile = destURI.getPath();
            log.info("The local temp file is " + localFile);
            log.info("the remote file is " + remoteFile);
            log.debug("Setup GridFTP Client");
            ftpClient = new GridFTPClient(contactInfo.hostName, contactInfo.port);
            ftpClient.setAuthorization((Authorization)new HostAuthorization(HOST));
            ftpClient.authenticate(gsCredential);
            ftpClient.setDataChannelAuthentication(DataChannelAuthentication.SELF);
            log.debug("Downloading file");
            if (GridFtp.checkBinaryExtensions(remoteFile)) {
                log.debug("Transfer mode is set to Binary to download a file");
                ftpClient.setType(1);
            }
            ftpClient.get(remoteFile, localFile);
            log.info("Download file to:" + localFile + " is done");
        }
        catch (ServerException e) {
            throw new ToolsException("Cannot download file from GridFTP:" + contactInfo.toString(), (Throwable)e);
        }
        catch (IOException e) {
            throw new ToolsException("Cannot download file from GridFTP:" + contactInfo.toString(), (Throwable)e);
        }
        catch (ClientException e) {
            throw new ToolsException("Cannot download file from GridFTP:" + contactInfo.toString(), (Throwable)e);
        }
        finally {
            if (ftpClient != null) {
                try {
                    ftpClient.close(false);
                }
                catch (Exception e) {
                    log.warn("Cannot close GridFTP client connection", (Throwable)e);
                }
            }
        }
    }

    public String readRemoteFile(URI destURI, GSSCredential gsCredential, File localFile) throws ToolsException {
        BufferedReader instream = null;
        File localTempfile = null;
        try {
            localTempfile = localFile == null ? File.createTempFile("stderr", "err") : localFile;
            log.info("Local temporary file:" + localTempfile);
            this.downloadFile(destURI, gsCredential, localTempfile);
            instream = new BufferedReader(new FileReader(localTempfile));
            StringBuffer buff = new StringBuffer();
            String temp = null;
            while ((temp = instream.readLine()) != null) {
                buff.append(temp);
                buff.append(Constants.NEWLINE);
            }
            log.info("finish read file:" + localTempfile);
            String string = buff.toString();
            return string;
        }
        catch (FileNotFoundException e) {
            throw new ToolsException("Cannot read localfile file:" + localTempfile, (Throwable)e);
        }
        catch (IOException e) {
            throw new ToolsException("Cannot read localfile file:" + localTempfile, (Throwable)e);
        }
        finally {
            if (instream != null) {
                try {
                    instream.close();
                }
                catch (Exception e) {
                    log.warn("Cannot close GridFTP client connection", (Throwable)e);
                }
            }
        }
    }

    public void transfer(URI srchost, URI desthost, GSSCredential gssCred, boolean srcActive) throws ToolsException {
        GridFTPClient destClient = null;
        GridFTPClient srcClient = null;
        try {
            HostPort hp;
            destClient = new GridFTPClient(desthost.getHost(), desthost.getPort());
            destClient.setAuthorization((Authorization)new HostAuthorization(HOST));
            destClient.authenticate(gssCred);
            if (GridFtp.checkBinaryExtensions(desthost.getPath())) {
                log.debug("Transfer mode is set to Binary");
                destClient.setType(1);
            }
            srcClient = new GridFTPClient(srchost.getHost(), srchost.getPort());
            srcClient.setAuthorization((Authorization)new HostAuthorization(HOST));
            srcClient.authenticate(gssCred);
            if (GridFtp.checkBinaryExtensions(srchost.getPath())) {
                log.debug("Transfer mode is set to Binary");
                srcClient.setType(1);
            }
            if (srcActive) {
                log.debug("Set src active");
                hp = destClient.setPassive();
                srcClient.setActive(hp);
            } else {
                log.debug("Set dst active");
                hp = srcClient.setPassive();
                destClient.setActive(hp);
            }
            log.debug("Start transfer file from GridFTP:" + srchost.toString() + " to " + desthost.toString());
            srcClient.transfer(srchost.getPath(), (FTPClient)destClient, desthost.getPath(), false, null);
            if (srcClient.getSize(srchost.getPath()) == destClient.getSize(desthost.getPath())) {
                log.debug("CHECK SUM OK");
            } else {
                log.debug("****CHECK SUM FAILED****");
            }
        }
        catch (ServerException e) {
            throw new ToolsException("Cannot transfer file from GridFTP:" + srchost.toString() + " to " + desthost.toString(), (Throwable)e);
        }
        catch (IOException e) {
            throw new ToolsException("Cannot transfer file from GridFTP:" + srchost.toString() + " to " + desthost.toString(), (Throwable)e);
        }
        catch (ClientException e) {
            throw new ToolsException("Cannot transfer file from GridFTP:" + srchost.toString() + " to " + desthost.toString(), (Throwable)e);
        }
        finally {
            if (destClient != null) {
                try {
                    destClient.close();
                }
                catch (Exception e) {
                    log.warn("Cannot close GridFTP client connection at Desitnation:" + desthost.toString());
                }
            }
            if (srcClient != null) {
                try {
                    srcClient.close();
                }
                catch (Exception e) {
                    log.warn("Cannot close GridFTP client connection at Source:" + srchost.toString(), (Throwable)e);
                }
            }
        }
    }

    public List<String> listDir(URI dirURI, GSSCredential gssCred) throws ToolsException {
        ArrayList<String> files = new ArrayList<String>();
        GridFTPClient srcClient = null;
        try {
            GridFTPContactInfo contactInfo = new GridFTPContactInfo(dirURI.getHost(), dirURI.getPort());
            srcClient = new GridFTPClient(contactInfo.hostName, contactInfo.port);
            srcClient.setAuthorization((Authorization)new HostAuthorization(HOST));
            srcClient.authenticate(gssCred);
            srcClient.setDataChannelAuthentication(DataChannelAuthentication.SELF);
            srcClient.setType(2);
            srcClient.changeDir(dirURI.getPath());
            Vector fileInfo = null;
            try {
                fileInfo = srcClient.mlsd();
            }
            catch (Throwable e) {
                fileInfo = srcClient.list();
            }
            if (!fileInfo.isEmpty()) {
                for (int j = 0; j < fileInfo.size(); ++j) {
                    String name = null;
                    if (fileInfo.get(j) instanceof MlsxEntry) {
                        name = ((MlsxEntry)fileInfo.get(j)).getFileName();
                    } else if (fileInfo.get(j) instanceof FileInfo) {
                        name = ((FileInfo)fileInfo.get(j)).getName();
                    } else {
                        throw new ToolsException("Unsupported type returned by gridftp " + fileInfo.get(j));
                    }
                    if (name.equals(".") || name.equals("..")) continue;
                    URI uri = GramProviderUtils.createGsiftpURI(contactInfo.hostName, dirURI.getPath() + File.separator + name);
                    files.add(uri.getPath());
                }
            }
            ArrayList<String> arrayList = files;
            return arrayList;
        }
        catch (IOException e) {
            throw new ToolsException("Could not list directory: " + dirURI.toString(), (Throwable)e);
        }
        catch (ServerException e) {
            throw new ToolsException("Could not list directory: " + dirURI.toString(), (Throwable)e);
        }
        catch (ClientException e) {
            throw new ToolsException("Could not list directory: " + dirURI.toString(), (Throwable)e);
        }
        catch (URISyntaxException e) {
            throw new ToolsException("Error creating URL of listed files: " + dirURI.toString(), (Throwable)e);
        }
        finally {
            if (srcClient != null) {
                try {
                    srcClient.close();
                }
                catch (Exception e) {
                    log.warn("Cannot close GridFTP client connection", (Throwable)e);
                }
            }
        }
    }

    private static boolean checkBinaryExtensions(String filePath) {
        String extension = filePath.substring(filePath.lastIndexOf(".") + 1, filePath.length());
        HashSet<String> extensions = new HashSet<String>(Arrays.asList("tar", "zip", "gz", "tgz"));
        return extensions.contains(extension);
    }

    public String gridFTPFileExist(URI inputDirectory, String fileName, GSSCredential gssCred) throws ToolsException {
        List<String> strings = this.listDir(inputDirectory, gssCred);
        for (String fileExist : strings) {
            if (!fileName.equals(fileExist)) continue;
            fileName = "duplicate_" + fileName;
            return fileName;
        }
        return fileName;
    }
}

