/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.bes.utils;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.BitSet;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;

public class URIUtils {
    public static String encodeAll(String uri) throws URIException {
        String result = URIUtils.encodeAuthority(uri);
        result = URIUtils.encodePath(uri);
        result = URIUtils.encodeQuery(result);
        result = URIUtils.encodeFragment(result);
        return result;
    }

    public static String encodeAuthority(String uri) throws URIException {
        int end;
        int start = uri.indexOf("//");
        if (start == -1) {
            return uri;
        }
        if ((end = uri.indexOf("/", ++start + 1)) == -1) {
            end = uri.indexOf("?", start + 1);
        }
        if (end == -1) {
            end = uri.indexOf("#", start + 1);
        }
        if (end == -1) {
            end = uri.length();
        }
        String before = uri.substring(0, start + 1);
        String authority = uri.substring(start + 1, end);
        String after = uri.substring(end);
        authority = URIUtil.encode((String)authority, (BitSet)org.apache.commons.httpclient.URI.allowed_authority);
        return before + authority + after;
    }

    public static String encodePath(String uri) throws URIException {
        int doubleSlashIndex = uri.indexOf("//");
        boolean hasAuthority = doubleSlashIndex >= 0;
        int start = -1;
        start = hasAuthority ? uri.indexOf("/", doubleSlashIndex + 2) : uri.indexOf(":");
        if (start == -1) {
            return uri;
        }
        int end = uri.indexOf("?", start + 1);
        if (end == -1) {
            end = uri.indexOf("#", start + 1);
        }
        if (end == -1) {
            end = uri.length();
        }
        String before = uri.substring(0, start + 1);
        String path = uri.substring(start + 1, end);
        String after = uri.substring(end);
        path = URIUtil.encode((String)path, (BitSet)org.apache.commons.httpclient.URI.allowed_abs_path);
        return before + path + after;
    }

    public static String encodeQuery(String uri) throws URIException {
        int queryStart = uri.indexOf("?");
        if (queryStart == -1) {
            return uri;
        }
        int queryEnd = uri.indexOf("#");
        if (queryEnd == -1) {
            queryEnd = uri.length();
        }
        String beforeQuery = uri.substring(0, queryStart + 1);
        String query = uri.substring(queryStart + 1, queryEnd);
        String afterQuery = uri.substring(queryEnd);
        query = URIUtil.encode((String)query, (BitSet)org.apache.commons.httpclient.URI.allowed_query);
        return beforeQuery + query + afterQuery;
    }

    public static String encodeFragment(String uri) throws URIException {
        int fragmentStart = uri.indexOf("#");
        if (fragmentStart == -1) {
            return uri;
        }
        String beforeFragment = uri.substring(0, fragmentStart + 1);
        String fragment = uri.substring(fragmentStart + 1);
        fragment = URIUtil.encode((String)fragment, (BitSet)org.apache.commons.httpclient.URI.allowed_fragment);
        return beforeFragment + fragment;
    }

    public static URI createGsiftpURI(String host, String localPath) throws URISyntaxException {
        StringBuffer buf = new StringBuffer();
        if (!host.startsWith("gsiftp://")) {
            buf.append("gsiftp://");
        }
        buf.append(host);
        if (!host.endsWith("/")) {
            buf.append("/");
        }
        buf.append(localPath);
        return new URI(buf.toString());
    }
}

