/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.bes.utils;

import de.fzj.unicore.wsrflite.xmlbeans.WSUtilities;
import eu.unicore.jsdl.extensions.ResourceRequestDocument;
import eu.unicore.jsdl.extensions.ResourceRequestType;
import org.apache.airavata.gfac.bes.utils.JSDLUtils;
import org.apache.airavata.gfac.bes.utils.RangeValueType;
import org.apache.airavata.gfac.core.context.JobExecutionContext;
import org.apache.airavata.gfac.core.provider.GFacProviderException;
import org.apache.airavata.model.workspace.experiment.ComputationalResourceScheduling;
import org.apache.airavata.model.workspace.experiment.TaskDetails;
import org.apache.xmlbeans.XmlObject;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobDefinitionType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.ResourcesType;

public class ResourceProcessor {
    public static void generateResourceElements(JobDefinitionType value, JobExecutionContext context) throws Exception {
        TaskDetails taskData = context.getTaskData();
        if (taskData != null && taskData.isSetTaskScheduling()) {
            try {
                String qName;
                RangeValueType rangeType;
                ComputationalResourceScheduling crs = taskData.getTaskScheduling();
                if (crs.getTotalPhysicalMemory() > 0) {
                    rangeType = new RangeValueType();
                    rangeType.setLowerBound(Double.NaN);
                    rangeType.setUpperBound(Double.NaN);
                    rangeType.setExact(crs.getTotalPhysicalMemory());
                    JSDLUtils.setIndividualPhysicalMemoryRequirements(value, rangeType);
                }
                if (crs.getNodeCount() > 0) {
                    rangeType = new RangeValueType();
                    rangeType.setLowerBound(Double.NaN);
                    rangeType.setUpperBound(Double.NaN);
                    rangeType.setExact(crs.getNodeCount());
                    JSDLUtils.setTotalResourceCountRequirements(value, rangeType);
                }
                if (crs.getWallTimeLimit() > 0) {
                    RangeValueType cpuTime = new RangeValueType();
                    cpuTime.setLowerBound(Double.NaN);
                    cpuTime.setUpperBound(Double.NaN);
                    long wallTime = crs.getWallTimeLimit() * 60;
                    cpuTime.setExact(wallTime);
                    JSDLUtils.setIndividualCPUTimeRequirements(value, cpuTime);
                }
                if (crs.getTotalCPUCount() > 0) {
                    rangeType = new RangeValueType();
                    rangeType.setLowerBound(Double.NaN);
                    rangeType.setUpperBound(Double.NaN);
                    int nodeCount = crs.getNodeCount();
                    if (nodeCount <= 0) {
                        nodeCount = 1;
                    }
                    rangeType.setExact(crs.getTotalCPUCount() / nodeCount);
                    JSDLUtils.setIndividualCPUCountRequirements(value, rangeType);
                }
                if ((qName = crs.getQueueName()) != null && !"".equals(qName) && !crs.getQueueName().trim().equalsIgnoreCase("default")) {
                    ResourceRequestDocument rqDoc = ResourceRequestDocument.Factory.newInstance();
                    ResourceRequestType rq = rqDoc.addNewResourceRequest();
                    rq.setName("Queue");
                    rq.setValue(qName);
                    ResourcesType res = JSDLUtils.getOrCreateResources(value);
                    WSUtilities.insertAny((XmlObject)rqDoc, (XmlObject)res);
                }
            }
            catch (NullPointerException npe) {
                new GFacProviderException("No value set for resource requirements.", (Throwable)npe);
            }
        }
    }
}

