/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.bes.utils;

import org.apache.airavata.gfac.bes.utils.ApplicationProcessor;
import org.apache.airavata.gfac.bes.utils.BESConstants;
import org.apache.airavata.gfac.bes.utils.JSDLUtils;
import org.apache.airavata.gfac.bes.utils.ResourceProcessor;
import org.apache.airavata.gfac.bes.utils.UASDataStagingProcessor;
import org.apache.airavata.gfac.core.context.ApplicationContext;
import org.apache.airavata.gfac.core.context.JobExecutionContext;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobDefinitionDocument;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobDefinitionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSDLGenerator
implements BESConstants {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    public static synchronized JobDefinitionDocument buildJSDLInstance(JobExecutionContext context) throws Exception {
        JobDefinitionDocument jobDefDoc = JobDefinitionDocument.Factory.newInstance();
        JobDefinitionType value = jobDefDoc.addNewJobDefinition();
        JSDLGenerator.createJobIdentification(value, context);
        ResourceProcessor.generateResourceElements(value, context);
        ApplicationProcessor.generateJobSpecificAppElements(value, context);
        return jobDefDoc;
    }

    public static synchronized JobDefinitionDocument buildJSDLInstance(JobExecutionContext context, String smsUrl) throws Exception {
        JobDefinitionDocument jobDefDoc = JobDefinitionDocument.Factory.newInstance();
        JobDefinitionType value = jobDefDoc.addNewJobDefinition();
        JSDLGenerator.createJobIdentification(value, context);
        ResourceProcessor.generateResourceElements(value, context);
        ApplicationProcessor.generateJobSpecificAppElements(value, context);
        UASDataStagingProcessor.generateDataStagingElements(value, context, smsUrl);
        return jobDefDoc;
    }

    public static synchronized JobDefinitionDocument buildJSDLInstance(JobExecutionContext context, String smsUrl, Object jobDirectoryMode) throws Exception {
        JobDefinitionDocument jobDefDoc = JobDefinitionDocument.Factory.newInstance();
        JobDefinitionType value = jobDefDoc.addNewJobDefinition();
        JSDLGenerator.createJobIdentification(value, context);
        ResourceProcessor.generateResourceElements(value, context);
        ApplicationProcessor.generateJobSpecificAppElements(value, context);
        UASDataStagingProcessor.generateDataStagingElements(value, context, smsUrl);
        return jobDefDoc;
    }

    private static void createJobIdentification(JobDefinitionType value, JobExecutionContext context) {
        ApplicationContext appCtxt = context.getApplicationContext();
        if (appCtxt != null) {
            if (appCtxt.getComputeResourcePreference() != null && appCtxt.getComputeResourcePreference().getAllocationProjectNumber() != null) {
                JSDLUtils.addProjectName(value, appCtxt.getComputeResourcePreference().getAllocationProjectNumber());
            }
            if (appCtxt.getApplicationInterfaceDescription() != null && appCtxt.getApplicationInterfaceDescription().getApplicationDescription() != null) {
                JSDLUtils.getOrCreateJobIdentification(value).setDescription(appCtxt.getApplicationInterfaceDescription().getApplicationDescription());
            }
            if (appCtxt.getApplicationInterfaceDescription() != null && appCtxt.getApplicationInterfaceDescription().getApplicationName() != null) {
                JSDLUtils.getOrCreateJobIdentification(value).setJobName(appCtxt.getApplicationInterfaceDescription().getApplicationName());
            }
        }
    }
}

