/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.bes.utils;

import de.fzj.unicore.uas.client.StorageClient;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.apache.airavata.gfac.Constants;
import org.apache.airavata.gfac.bes.utils.FileDownloader;
import org.apache.airavata.gfac.bes.utils.FileUploader;
import org.apache.airavata.gfac.bes.utils.Mode;
import org.apache.airavata.gfac.bes.utils.UASDataStagingProcessor;
import org.apache.airavata.gfac.core.context.JobExecutionContext;
import org.apache.airavata.gfac.core.provider.GFacProviderException;
import org.apache.airavata.model.appcatalog.appinterface.DataType;
import org.apache.airavata.model.appcatalog.appinterface.InputDataObjectType;
import org.apache.airavata.model.appcatalog.appinterface.OutputDataObjectType;
import org.apache.airavata.model.workspace.experiment.TaskDetails;
import org.apache.airavata.registry.cpi.ChildDataType;
import org.apache.airavata.registry.cpi.Registry;
import org.apache.airavata.registry.cpi.RegistryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataTransferrer {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected JobExecutionContext jobContext;
    protected StorageClient storageClient;
    protected List<OutputDataObjectType> resultantOutputsLst;
    protected String gatewayDownloadLocation;
    protected String stdoutLocation;
    protected String stderrLocation;

    public DataTransferrer(JobExecutionContext jobContext, StorageClient storageClient) {
        this.jobContext = jobContext;
        this.storageClient = storageClient;
        this.resultantOutputsLst = new ArrayList<OutputDataObjectType>();
        this.initStdoutsLocation();
    }

    private void initStdoutsLocation() {
        this.gatewayDownloadLocation = this.getDownloadLocation();
        String stdout = this.jobContext.getStandardOutput();
        String stderr = this.jobContext.getStandardError();
        if (stdout != null) {
            stdout = stdout.substring(stdout.lastIndexOf(47) + 1);
        }
        if (stderr != null) {
            stderr = stderr.substring(stderr.lastIndexOf(47) + 1);
        }
        String stdoutFileName = stdout == null || stdout.equals("") ? "stdout" : stdout;
        String stderrFileName = stdout == null || stderr.equals("") ? "stderr" : stderr;
        this.stdoutLocation = this.gatewayDownloadLocation + File.separator + stdoutFileName;
        this.stderrLocation = this.gatewayDownloadLocation + File.separator + stderrFileName;
        this.jobContext.addOutputFile(this.stdoutLocation);
        this.jobContext.setStandardOutput(this.stdoutLocation);
        this.jobContext.addOutputFile(this.stderrLocation);
        this.jobContext.setStandardError(this.stderrLocation);
    }

    public void uploadLocalFiles() throws GFacProviderException {
        List<String> inFilePrms = this.extractInFileParams();
        for (String uri : inFilePrms) {
            String fileName = new File(uri).getName();
            if (!uri.startsWith("file:")) continue;
            try {
                String uriWithoutProtocol = uri.substring(uri.lastIndexOf("://") + 1, uri.length());
                FileUploader fileUploader = new FileUploader(uriWithoutProtocol, fileName, Mode.overwrite);
                fileUploader.perform(this.storageClient);
            }
            catch (FileNotFoundException e3) {
                throw new GFacProviderException("Error while staging-in, local file " + fileName + " not found", (Throwable)e3);
            }
            catch (Exception e) {
                throw new GFacProviderException("Cannot upload files", (Throwable)e);
            }
        }
    }

    public void downloadRemoteFiles() throws GFacProviderException {
        List applicationOutputs;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Download location is:" + this.gatewayDownloadLocation);
        }
        if ((applicationOutputs = this.jobContext.getTaskData().getApplicationOutputs()) != null && !applicationOutputs.isEmpty()) {
            for (OutputDataObjectType output : applicationOutputs) {
                if ("".equals(output.getValue()) || output.getValue() == null) continue;
                if (output.getType().equals((Object)DataType.STDOUT)) {
                    output.setValue(this.jobContext.getStandardOutput());
                    this.resultantOutputsLst.add(output);
                    continue;
                }
                if (output.getType().equals((Object)DataType.STDERR)) {
                    output.setValue(this.jobContext.getStandardError());
                    this.resultantOutputsLst.add(output);
                    continue;
                }
                if (!output.getType().equals((Object)DataType.STRING)) continue;
                String value = null;
                value = !output.getLocation().isEmpty() ? output.getLocation() + File.separator + output.getValue() : output.getValue();
                String outputPath = this.gatewayDownloadLocation + File.separator + output.getValue();
                File f = new File(this.gatewayDownloadLocation);
                if (!f.exists()) {
                    f.mkdirs();
                }
                FileDownloader fileDownloader = new FileDownloader(value, outputPath, Mode.overwrite);
                try {
                    fileDownloader.perform(this.storageClient);
                    output.setType(DataType.URI);
                    output.setValue(outputPath);
                    this.jobContext.addOutputFile(outputPath);
                    this.resultantOutputsLst.add(output);
                }
                catch (Exception e) {
                    this.log.error("Error downloading " + value + " from job working directory. ");
                    throw new GFacProviderException(e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
        this.downloadStdOuts();
    }

    public void downloadStdOuts() throws GFacProviderException {
        String stdoutFileName = new File(this.stdoutLocation).getName();
        String stderrFileName = new File(this.stderrLocation).getName();
        FileDownloader f1 = null;
        try {
            this.log.info("Downloading stdout and stderr..");
            this.log.info(stdoutFileName + " -> " + this.stdoutLocation);
            f1 = new FileDownloader(stdoutFileName, this.stdoutLocation, Mode.overwrite);
            f1.perform(this.storageClient);
            String stdoutput = this.readFile(this.stdoutLocation);
            this.log.info(stderrFileName + " -> " + this.stderrLocation);
            f1.setFrom(stderrFileName);
            f1.setTo(this.stderrLocation);
            f1.perform(this.storageClient);
            String stderror = this.readFile(this.stderrLocation);
            if (UASDataStagingProcessor.isUnicoreEndpoint(this.jobContext)) {
                String scriptExitCodeFName = "UNICORE_SCRIPT_EXIT_CODE";
                String scriptCodeLocation = this.gatewayDownloadLocation + File.separator + scriptExitCodeFName;
                f1.setFrom(scriptExitCodeFName);
                f1.setTo(scriptCodeLocation);
                f1.perform(this.storageClient);
                this.jobContext.addOutputFile(scriptCodeLocation);
                this.log.info("UNICORE_SCRIPT_EXIT_CODE -> " + scriptCodeLocation);
                this.log.info("EXIT CODE: " + this.readFile(scriptCodeLocation));
            }
        }
        catch (Exception e) {
            throw new GFacProviderException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void publishFinalOutputs() throws GFacProviderException {
        try {
            if (!this.resultantOutputsLst.isEmpty()) {
                this.log.debug("Publishing the list of outputs to the registry instance..");
                Registry registry = this.jobContext.getRegistry();
                registry.add(ChildDataType.EXPERIMENT_OUTPUT, this.resultantOutputsLst, (Object)this.jobContext.getExperimentID());
            }
        }
        catch (RegistryException e) {
            throw new GFacProviderException("Cannot publish outputs to the registry.");
        }
    }

    public List<String> extractInFileParams() {
        ArrayList<String> filePrmsList = new ArrayList<String>();
        List applicationInputs = this.jobContext.getTaskData().getApplicationInputs();
        if (applicationInputs != null && !applicationInputs.isEmpty()) {
            for (InputDataObjectType output : applicationInputs) {
                if (!output.getType().equals((Object)DataType.URI)) continue;
                filePrmsList.add(output.getValue());
            }
        }
        return filePrmsList;
    }

    private String readFile(String localFile) throws IOException {
        BufferedReader instream = new BufferedReader(new FileReader(localFile));
        StringBuffer buff = new StringBuffer();
        String temp = null;
        while ((temp = instream.readLine()) != null) {
            buff.append(temp);
            buff.append(Constants.NEWLINE);
        }
        this.log.info("finish read file:" + localFile);
        return buff.toString();
    }

    public void setStorageClient(StorageClient sc) {
        this.storageClient = sc;
    }

    private String getDownloadLocation() {
        File file;
        TaskDetails taskData = this.jobContext.getTaskData();
        String outputDataDir = "";
        if (taskData != null && taskData.getAdvancedOutputDataHandling() != null) {
            outputDataDir = taskData.getAdvancedOutputDataHandling().getOutputDataDir();
            if (outputDataDir == null || "".equals(outputDataDir)) {
                outputDataDir = this.getTempPath(this.jobContext.getExperimentID());
            } else if (outputDataDir.startsWith("scp:") || outputDataDir.startsWith("ftp:") || outputDataDir.startsWith("gsiftp:")) {
                outputDataDir = this.getTempPath(this.jobContext.getExperimentID());
            } else if (outputDataDir.startsWith("file:") && outputDataDir.contains("@")) {
                outputDataDir = this.getTempPath(this.jobContext.getExperimentID());
            } else {
                try {
                    URI u = new URI(outputDataDir);
                    outputDataDir = u.getPath();
                }
                catch (URISyntaxException e) {
                    outputDataDir = this.getTempPath(this.jobContext.getExperimentID());
                }
            }
        }
        if (!(file = new File(outputDataDir)).exists()) {
            file.mkdirs();
        }
        return outputDataDir;
    }

    private String getTempPath(String experimentID) {
        String tmpOutputDir = File.separator + "tmp" + File.separator + this.jobContext.getExperimentID();
        new File(tmpOutputDir).mkdirs();
        return tmpOutputDir;
    }
}

