/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.bes.security;

import eu.emi.security.authn.x509.X509CertChainValidator;
import eu.emi.security.authn.x509.X509Credential;
import eu.emi.security.authn.x509.helpers.CertificateHelpers;
import eu.emi.security.authn.x509.helpers.proxy.X509v3CertificateBuilder;
import eu.emi.security.authn.x509.impl.CertificateUtils;
import eu.emi.security.authn.x509.impl.DirectoryCertChainValidator;
import eu.emi.security.authn.x509.impl.KeyAndCertCredential;
import eu.emi.security.authn.x509.impl.X500NameUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Random;
import javax.security.auth.x500.X500Principal;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.ServerSettings;
import org.apache.airavata.credential.store.credential.Credential;
import org.apache.airavata.credential.store.credential.impl.certificate.CertificateCredential;
import org.apache.airavata.credential.store.store.CredentialReader;
import org.apache.airavata.gfac.AbstractSecurityContext;
import org.apache.airavata.gfac.GFacException;
import org.apache.airavata.gfac.RequestData;
import org.apache.airavata.gfac.bes.utils.MyProxyLogon;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X509SecurityContext
extends AbstractSecurityContext {
    private static final long serialVersionUID = 1L;
    protected static final Logger log = LoggerFactory.getLogger(X509SecurityContext.class);
    public static final String X509_SECURITY_CONTEXT = "x509.security.context";
    public static final int CREDENTIAL_RENEWING_THRESH_HOLD = 900;
    protected static DirectoryCertChainValidator dcValidator;
    private X509Credential x509Credentials = null;

    public static void setUpTrustedCertificatePath(String trustedCertificatePath) {
        File file = new File(trustedCertificatePath);
        if (!file.exists() || !file.canRead()) {
            File f = new File(".");
            log.info("Current directory " + f.getAbsolutePath());
            throw new RuntimeException("Cannot read trusted certificate path " + trustedCertificatePath);
        }
        System.setProperty("X509_CERT_DIR", file.getAbsolutePath());
    }

    private static void setUpTrustedCertificatePath() throws ApplicationSettingsException {
        String trustedCertificatePath = ServerSettings.getSetting((String)"trusted.cert.location");
        X509SecurityContext.setUpTrustedCertificatePath(trustedCertificatePath);
    }

    public static String getTrustedCertificatePath() {
        return System.getProperty("X509_CERT_DIR");
    }

    public X509SecurityContext(CredentialReader credentialReader, RequestData requestData) {
        super(credentialReader, requestData);
    }

    public X509Credential getX509Credentials() throws GFacException, ApplicationSettingsException {
        if (this.getCredentialReader() == null) {
            return this.getDefaultCredentials();
        }
        if (this.x509Credentials == null) {
            try {
                this.x509Credentials = this.getCredentialsFromStore();
            }
            catch (Exception e) {
                log.error("An exception occurred while retrieving credentials from the credential store. Will continue with my proxy user name and password.", (Throwable)e);
            }
            if (this.x509Credentials == null) {
                this.x509Credentials = this.getDefaultCredentials();
            }
            if (this.x509Credentials == null) {
                throw new GFacException("Unable to retrieve my proxy credentials to continue operation.");
            }
        } else {
            try {
                long remainingTime = this.x509Credentials.getCertificate().getNotAfter().getTime() - new Date().getTime();
                if (remainingTime < 900L) {
                    log.warn("Do not support credentials renewal");
                }
                log.info("Fall back to get new default credentials");
                try {
                    this.x509Credentials.getCertificate().checkValidity();
                }
                catch (Exception e) {
                    this.x509Credentials = this.getDefaultCredentials();
                }
            }
            catch (Exception e) {
                throw new GFacException("Unable to retrieve remaining life time from credentials.", (Throwable)e);
            }
        }
        return this.x509Credentials;
    }

    public X509Credential getCredentialsFromStore() throws Exception {
        if (this.getCredentialReader() == null) {
            return null;
        }
        Credential credential = this.getCredentialReader().getCredential(this.getRequestData().getGatewayId(), this.getRequestData().getTokenId());
        if (credential != null) {
            if (credential instanceof CertificateCredential) {
                log.info("Successfully found credentials for token id - " + this.getRequestData().getTokenId() + " gateway id - " + this.getRequestData().getGatewayId());
                CertificateCredential certificateCredential = (CertificateCredential)credential;
                X509Certificate[] certificates = certificateCredential.getCertificates();
                KeyAndCertCredential keyAndCert = new KeyAndCertCredential(certificateCredential.getPrivateKey(), certificates);
                return keyAndCert;
            }
            log.info("Credential type is not CertificateCredential. Cannot create mapping globus credentials. Credential type - " + credential.getClass().getName());
        } else {
            log.info("Could not find credentials for token - " + this.getRequestData().getTokenId() + " and " + "gateway id - " + this.getRequestData().getGatewayId());
        }
        return null;
    }

    public X509Credential getDefaultCredentials() throws GFacException, ApplicationSettingsException {
        MyProxyLogon logon = new MyProxyLogon();
        logon.setValidator((X509CertChainValidator)dcValidator);
        logon.setHost(this.getRequestData().getMyProxyServerUrl());
        logon.setPort(this.getRequestData().getMyProxyPort());
        logon.setUsername(this.getRequestData().getMyProxyUserName());
        logon.setPassphrase(this.getRequestData().getMyProxyPassword().toCharArray());
        logon.setLifetime(this.getRequestData().getMyProxyLifeTime());
        try {
            logon.connect();
            logon.logon();
            logon.getCredentials();
            logon.disconnect();
            PrivateKey pk = logon.getPrivateKey();
            return new KeyAndCertCredential(pk, new X509Certificate[]{logon.getCertificate()});
        }
        catch (Exception e) {
            throw new GFacException("An error occurred while retrieving default security credentials.", (Throwable)e);
        }
    }

    private static DirectoryCertChainValidator getTrustedCerts() throws Exception {
        String certLocation = X509SecurityContext.getTrustedCertificatePath();
        ArrayList<String> trustedCert = new ArrayList<String>();
        trustedCert.add(certLocation + "/*.0");
        trustedCert.add(certLocation + "/*.pem");
        DirectoryCertChainValidator dcValidator = new DirectoryCertChainValidator(trustedCert, CertificateUtils.Encoding.PEM, -1L, 60000, null);
        return dcValidator;
    }

    private String getCNFromUserDN(String userDN) {
        return X500NameUtils.getAttributeValues((String)userDN, (ASN1ObjectIdentifier)BCStyle.CN)[0];
    }

    public KeyAndCertCredential generateShortLivedCredential(String userDN, String caCertPath, String caKeyPath, String caPwd) throws Exception {
        SubjectPublicKeyInfo publicKeyInfo;
        long CredentialGoodFromOffset = 900000L;
        long startTime = System.currentTimeMillis() - 900000L;
        long endTime = startTime + 108000000L;
        String keyLengthProp = "1024";
        int keyLength = Integer.parseInt(keyLengthProp);
        String signatureAlgorithm = "SHA1withRSA";
        KeyAndCertCredential caCred = this.getCACredential(caCertPath, caKeyPath, caPwd);
        KeyPairGenerator kpg = KeyPairGenerator.getInstance(caCred.getKey().getAlgorithm());
        kpg.initialize(keyLength);
        KeyPair pair = kpg.generateKeyPair();
        X500Principal subjectDN = new X500Principal(userDN);
        Random rand = new Random();
        try {
            publicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)new ASN1InputStream(pair.getPublic().getEncoded()).readObject());
        }
        catch (IOException e) {
            throw new InvalidKeyException("Can not parse the public keybeing included in the short lived certificate", e);
        }
        X500Name issuerX500Name = CertificateHelpers.toX500Name((X500Principal)caCred.getCertificate().getSubjectX500Principal());
        X500Name subjectX500Name = CertificateHelpers.toX500Name((X500Principal)subjectDN);
        X509v3CertificateBuilder certBuilder = new X509v3CertificateBuilder(issuerX500Name, new BigInteger(20, rand), new Date(startTime), new Date(endTime), subjectX500Name, publicKeyInfo);
        AlgorithmIdentifier sigAlgId = X509v3CertificateBuilder.extractAlgorithmId((X509Certificate)caCred.getCertificate());
        X509Certificate certificate = certBuilder.build(caCred.getKey(), sigAlgId, signatureAlgorithm, null, null);
        certificate.checkValidity(new Date());
        certificate.verify(caCred.getCertificate().getPublicKey());
        KeyAndCertCredential result = new KeyAndCertCredential(pair.getPrivate(), new X509Certificate[]{certificate, caCred.getCertificate()});
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyAndCertCredential getCACredential(String caCertPath, String caKeyPath, String password) throws Exception {
        FileInputStream isCert = null;
        FileInputStream isKey = null;
        try {
            isKey = new FileInputStream(caKeyPath);
            PrivateKey pk = CertificateUtils.loadPrivateKey((InputStream)isKey, (CertificateUtils.Encoding)CertificateUtils.Encoding.PEM, (char[])password.toCharArray());
            isCert = new FileInputStream(caCertPath);
            X509Certificate caCert = CertificateUtils.loadCertificate((InputStream)isCert, (CertificateUtils.Encoding)CertificateUtils.Encoding.PEM);
            KeyAndCertCredential keyAndCertCredential = new KeyAndCertCredential(pk, new X509Certificate[]{caCert});
            return keyAndCertCredential;
        }
        finally {
            if (isKey != null) {
                ((InputStream)isKey).close();
            }
            if (isCert != null) {
                ((InputStream)isCert).close();
            }
        }
    }

    static {
        try {
            X509SecurityContext.setUpTrustedCertificatePath();
            dcValidator = X509SecurityContext.getTrustedCerts();
        }
        catch (Exception e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
        }
    }
}

