/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.bes.security;

import de.fzj.unicore.uas.security.ProxyCertOutHandler;
import eu.emi.security.authn.x509.X509CertChainValidatorExt;
import eu.emi.security.authn.x509.X509Credential;
import eu.emi.security.authn.x509.impl.KeyAndCertCredential;
import eu.emi.security.authn.x509.impl.X500NameUtils;
import eu.unicore.util.httpclient.DefaultClientConfiguration;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.ServerSettings;
import org.apache.airavata.credential.store.store.CredentialReader;
import org.apache.airavata.gfac.GFacException;
import org.apache.airavata.gfac.RequestData;
import org.apache.airavata.gfac.bes.security.X509SecurityContext;
import org.apache.airavata.gfac.bes.utils.SecurityUtils;
import org.apache.airavata.gfac.core.provider.GFacProviderException;
import org.apache.airavata.model.workspace.experiment.UserConfigurationData;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UNICORESecurityContext
extends X509SecurityContext {
    private static final long serialVersionUID = 1L;
    protected static final Logger log = LoggerFactory.getLogger(UNICORESecurityContext.class);
    private DefaultClientConfiguration secProperties;

    public UNICORESecurityContext(CredentialReader credentialReader, RequestData requestData) {
        super(credentialReader, requestData);
    }

    public DefaultClientConfiguration getDefaultConfiguration(Boolean enableMessageLogging) throws GFacException, ApplicationSettingsException {
        try {
            X509Credential cred = this.getX509Credentials();
            this.secProperties = new DefaultClientConfiguration((X509CertChainValidatorExt)dcValidator, cred);
            this.setExtraSettings();
        }
        catch (Exception e) {
            throw new GFacException(e.getMessage(), (Throwable)e);
        }
        if (enableMessageLogging.booleanValue()) {
            this.secProperties.setMessageLogging(true);
        }
        return this.secProperties;
    }

    public DefaultClientConfiguration getDefaultConfiguration(Boolean enableMessageLogging, UserConfigurationData userData) throws GFacException, ApplicationSettingsException {
        KeyAndCertCredential cred = null;
        try {
            boolean genCert = userData.isGenerateCert();
            if (genCert) {
                String userDN = userData.getUserDN();
                if (userDN == null || "".equals(userDN)) {
                    log.warn("Cannot generate cert, falling back to GFAC configured MyProxy credentials");
                    return this.getDefaultConfiguration(enableMessageLogging);
                }
                log.info("Generating X.509 certificate for: " + userDN);
                try {
                    String caCertPath = ServerSettings.getSetting((String)"bes.ca.cert.path", (String)"");
                    String caKeyPath = ServerSettings.getSetting((String)"bes.ca.key.path", (String)"");
                    String caKeyPass = ServerSettings.getSetting((String)"bes.ca.key.pass", (String)"");
                    if (caCertPath.equals("") || caKeyPath.equals("")) {
                        throw new Exception("CA certificate or key file path missing in the properties file. Please make sure bes.ca.cert.path or bes.ca.key.path are not empty.");
                    }
                    if ("".equals(caKeyPass)) {
                        log.warn("Caution: CA key has no password. For security reasons it is highly recommended to set a CA key password");
                    }
                    cred = this.generateShortLivedCredential(userDN, caCertPath, caKeyPath, caKeyPass);
                }
                catch (Exception e) {
                    throw new GFacProviderException("Error occured while generating a short lived credential for user:" + userDN, (Throwable)e);
                }
            } else {
                return this.getDefaultConfiguration(enableMessageLogging);
            }
            this.secProperties = new DefaultClientConfiguration((X509CertChainValidatorExt)dcValidator, (X509Credential)cred);
            this.setExtraSettings();
        }
        catch (Exception e) {
            throw new GFacException(e.getMessage(), (Throwable)e);
        }
        this.secProperties.getETDSettings().setExtendTrustDelegation(true);
        if (enableMessageLogging.booleanValue()) {
            this.secProperties.setMessageLogging(true);
        }
        this.secProperties.getETDSettings().setIssuerCertificateChain(this.secProperties.getCredential().getCertificateChain());
        return this.secProperties;
    }

    public DefaultClientConfiguration getServerSignedConfiguration(String userID, String userDN, String caCertPath, String caKeyPath, String caKeyPwd) throws GFacException {
        try {
            KeyAndCertCredential cred = SecurityUtils.generateShortLivedCertificate(userDN, caCertPath, caKeyPath, caKeyPwd);
            this.secProperties = new DefaultClientConfiguration((X509CertChainValidatorExt)dcValidator, (X509Credential)cred);
            this.setExtraSettings();
        }
        catch (Exception e) {
            throw new GFacException(e.getMessage(), (Throwable)e);
        }
        return this.secProperties;
    }

    private void setExtraSettings() {
        this.secProperties.getETDSettings().setExtendTrustDelegation(true);
        this.secProperties.setDoSignMessage(true);
        String[] outHandlers = this.secProperties.getOutHandlerClassNames();
        HashSet<Object> outHandlerLst = null;
        Properties p = this.secProperties.getExtraSettings();
        if (p == null) {
            p = new Properties();
        }
        p.setProperty("http.connection.timeout", "5000");
        p.setProperty("http.socket.timeout", "5000");
        outHandlerLst = outHandlers == null ? new HashSet<String>() : new HashSet<String>(Arrays.asList(outHandlers));
        outHandlerLst.add(ProxyCertOutHandler.class.getName());
        this.secProperties.setOutHandlerClassNames(outHandlerLst.toArray(new String[outHandlerLst.size()]));
        this.secProperties.getETDSettings().setExtendTrustDelegation(true);
    }

    private String getCNFromUserDN(String userDN) {
        return X500NameUtils.getAttributeValues((String)userDN, (ASN1ObjectIdentifier)BCStyle.CN)[0];
    }
}

