/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.bes.provider.impl;

import de.fzj.unicore.bes.client.ActivityClient;
import de.fzj.unicore.bes.client.FactoryClient;
import de.fzj.unicore.bes.faults.UnknownActivityIdentifierFault;
import de.fzj.unicore.uas.client.StorageClient;
import de.fzj.unicore.wsrflite.xmlbeans.WSUtilities;
import eu.emi.security.authn.x509.impl.X500NameUtils;
import eu.unicore.util.httpclient.DefaultClientConfiguration;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.util.Calendar;
import java.util.Map;
import org.airavata.appcatalog.cpi.AppCatalogException;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.MonitorPublisher;
import org.apache.airavata.gfac.GFacException;
import org.apache.airavata.gfac.bes.security.UNICORESecurityContext;
import org.apache.airavata.gfac.bes.utils.BESConstants;
import org.apache.airavata.gfac.bes.utils.DataTransferrer;
import org.apache.airavata.gfac.bes.utils.JSDLGenerator;
import org.apache.airavata.gfac.bes.utils.SecurityUtils;
import org.apache.airavata.gfac.bes.utils.StorageCreator;
import org.apache.airavata.gfac.core.context.JobExecutionContext;
import org.apache.airavata.gfac.core.notification.events.StartExecutionEvent;
import org.apache.airavata.gfac.core.provider.AbstractProvider;
import org.apache.airavata.gfac.core.provider.GFacProvider;
import org.apache.airavata.gfac.core.provider.GFacProviderException;
import org.apache.airavata.gfac.core.utils.GFacUtils;
import org.apache.airavata.model.appcatalog.computeresource.JobSubmissionInterface;
import org.apache.airavata.model.appcatalog.computeresource.JobSubmissionProtocol;
import org.apache.airavata.model.appcatalog.computeresource.UnicoreJobSubmission;
import org.apache.airavata.model.messaging.event.JobIdentifier;
import org.apache.airavata.model.messaging.event.JobStatusChangeRequestEvent;
import org.apache.airavata.model.workspace.experiment.JobDetails;
import org.apache.airavata.model.workspace.experiment.JobState;
import org.apache.xmlbeans.XmlCursor;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.ggf.schemas.bes.x2006.x08.besFactory.ActivityStateEnumeration;
import org.ggf.schemas.bes.x2006.x08.besFactory.ActivityStatusType;
import org.ggf.schemas.bes.x2006.x08.besFactory.CreateActivityDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.CreateActivityResponseDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.GetActivityStatusesDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.GetActivityStatusesResponseDocument;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobDefinitionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class BESProvider
extends AbstractProvider
implements GFacProvider,
BESConstants {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private DefaultClientConfiguration secProperties;
    private String jobId;

    public void initialize(JobExecutionContext jobExecutionContext) throws GFacProviderException, GFacException {
        this.log.info("Initializing UNICORE Provider..");
        super.initialize(jobExecutionContext);
        this.secProperties = (DefaultClientConfiguration)jobExecutionContext.getProperty("bes.client.config");
        if (this.secProperties != null) {
            this.secProperties = this.secProperties.clone();
            return;
        }
        SecurityUtils.addSecurityContext(jobExecutionContext);
        UNICORESecurityContext unicoreContext = (UNICORESecurityContext)jobExecutionContext.getSecurityContext("x509.security.context");
        try {
            this.secProperties = jobExecutionContext.getExperiment().getUserConfigurationData().isGenerateCert() ? unicoreContext.getDefaultConfiguration(false, jobExecutionContext.getExperiment().getUserConfigurationData()) : unicoreContext.getDefaultConfiguration(false);
        }
        catch (ApplicationSettingsException e) {
            throw new GFacProviderException("Error initializing security of Unicore provider", (Throwable)e);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Security properties initialized.");
        }
    }

    public void execute(JobExecutionContext jobExecutionContext) throws GFacProviderException, GFacException {
        StorageClient sc = null;
        try {
            JobSubmissionInterface preferredJobSubmissionInterface = jobExecutionContext.getPreferredJobSubmissionInterface();
            JobSubmissionProtocol protocol = preferredJobSubmissionInterface.getJobSubmissionProtocol();
            String interfaceId = preferredJobSubmissionInterface.getJobSubmissionInterfaceId();
            String factoryUrl = null;
            if (protocol.equals((Object)JobSubmissionProtocol.UNICORE)) {
                UnicoreJobSubmission unicoreJobSubmission = GFacUtils.getUnicoreJobSubmission((String)interfaceId);
                factoryUrl = unicoreJobSubmission.getUnicoreEndPointURL();
            }
            EndpointReferenceType eprt = EndpointReferenceType.Factory.newInstance();
            eprt.addNewAddress().setStringValue(factoryUrl);
            String userDN = this.getUserName(jobExecutionContext);
            CreateActivityDocument cad = CreateActivityDocument.Factory.newInstance();
            StorageCreator storageCreator = new StorageCreator(this.secProperties, factoryUrl, 5, null);
            sc = storageCreator.createStorage();
            JobDefinitionType jobDefinition = JSDLGenerator.buildJSDLInstance(jobExecutionContext, sc.getUrl()).getJobDefinition();
            cad.addNewCreateActivity().addNewActivityDocument().setJobDefinition(jobDefinition);
            this.log.info("Submitted JSDL: " + jobDefinition.getJobDescription());
            DataTransferrer dt = new DataTransferrer(jobExecutionContext, sc);
            dt.uploadLocalFiles();
            JobDetails jobDetails = new JobDetails();
            FactoryClient factory = new FactoryClient(eprt, (IClientConfiguration)this.secProperties);
            this.log.info(String.format("Activity Submitting to %s ... \n", factoryUrl));
            this.monitorPublisher.publish((Object)new StartExecutionEvent());
            CreateActivityResponseDocument response = factory.createActivity(cad);
            this.log.info(String.format("Activity Submitted to %s \n", factoryUrl));
            EndpointReferenceType activityEpr = response.getCreateActivityResponse().getActivityIdentifier();
            this.log.info("Activity : " + activityEpr.getAddress().getStringValue() + " Submitted.");
            this.jobId = WSUtilities.extractResourceID((EndpointReferenceType)activityEpr);
            if (this.jobId == null) {
                this.jobId = new Long(Calendar.getInstance().getTimeInMillis()).toString();
            }
            this.log.info("JobID: " + this.jobId);
            jobDetails.setJobID(this.jobId);
            jobDetails.setJobDescription(activityEpr.toString());
            jobExecutionContext.setJobDetails(jobDetails);
            GFacUtils.saveJobStatus((JobExecutionContext)jobExecutionContext, (JobDetails)jobDetails, (JobState)JobState.SUBMITTED, (MonitorPublisher)this.monitorPublisher);
            this.log.info(this.formatStatusMessage(activityEpr.getAddress().getStringValue(), factory.getActivityStatus(activityEpr).toString()));
            this.waitUntilDone(eprt, activityEpr, jobDetails, this.secProperties);
            ActivityStatusType activityStatus = null;
            activityStatus = this.getStatus(factory, activityEpr);
            this.log.info(this.formatStatusMessage(activityEpr.getAddress().getStringValue(), activityStatus.getState().toString()));
            ActivityClient activityClient = new ActivityClient(activityEpr, (IClientConfiguration)this.secProperties);
            dt.setStorageClient(activityClient.getUspaceClient());
            if (activityStatus.getState() == ActivityStateEnumeration.FAILED) {
                String error = activityStatus.getFault().getFaultcode().getLocalPart() + "\n" + activityStatus.getFault().getFaultstring() + "\n EXITCODE: " + activityStatus.getExitCode();
                this.log.info(error);
                JobState applicationJobStatus = JobState.FAILED;
                this.sendNotification(jobExecutionContext, applicationJobStatus);
                GFacUtils.updateJobStatus((JobExecutionContext)jobExecutionContext, (JobDetails)jobDetails, (JobState)applicationJobStatus);
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.log.debug("Downloading any standard output and error files, if they were produced.");
                dt.downloadStdOuts();
            } else {
                if (activityStatus.getState() == ActivityStateEnumeration.CANCELLED) {
                    JobState applicationJobStatus = JobState.CANCELED;
                    this.sendNotification(jobExecutionContext, applicationJobStatus);
                    GFacUtils.updateJobStatus((JobExecutionContext)jobExecutionContext, (JobDetails)jobDetails, (JobState)applicationJobStatus);
                    throw new GFacProviderException(jobExecutionContext.getExperimentID() + "Job Canceled");
                }
                if (activityStatus.getState() == ActivityStateEnumeration.FINISHED) {
                    try {
                        Thread.sleep(5000L);
                        JobState applicationJobStatus = JobState.COMPLETE;
                        this.sendNotification(jobExecutionContext, applicationJobStatus);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (activityStatus.getExitCode() == 0) {
                        dt.downloadRemoteFiles();
                    } else {
                        dt.downloadStdOuts();
                    }
                }
            }
            dt.publishFinalOutputs();
        }
        catch (AppCatalogException e) {
            this.log.error("Error while retrieving UNICORE job submission..");
            throw new GFacProviderException("Error while retrieving UNICORE job submission..", (Throwable)e);
        }
        catch (Exception e) {
            this.log.error("Cannot create storage..");
            throw new GFacProviderException("Cannot create storage..", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JobState getApplicationJobStatus(ActivityStatusType activityStatus) {
        if (activityStatus == null) {
            return JobState.UNKNOWN;
        }
        ActivityStateEnumeration.Enum state = activityStatus.getState();
        String status = null;
        XmlCursor acursor = activityStatus.newCursor();
        try {
            if (acursor.toFirstChild() && acursor.getName().getNamespaceURI().equals("http://schemas.ogf.org/hpcp/2007/01/fs")) {
                status = acursor.getName().getLocalPart();
            }
            if (status != null) {
                if (status.equalsIgnoreCase("Queued") || status.equalsIgnoreCase("Starting") || status.equalsIgnoreCase("Ready")) {
                    JobState jobState = JobState.QUEUED;
                    return jobState;
                }
                if (status.equalsIgnoreCase("Staging-In")) {
                    JobState jobState = JobState.SUBMITTED;
                    return jobState;
                }
                if (status.equalsIgnoreCase("FINISHED")) {
                    JobState jobState = JobState.COMPLETE;
                    return jobState;
                }
                if (status.equalsIgnoreCase("Staging-Out")) {
                    JobState jobState = JobState.ACTIVE;
                    return jobState;
                }
                if (status.equalsIgnoreCase("Executing")) {
                    JobState jobState = JobState.ACTIVE;
                    return jobState;
                }
                if (status.equalsIgnoreCase("FAILED")) {
                    JobState jobState = JobState.FAILED;
                    return jobState;
                }
                if (status.equalsIgnoreCase("CANCELLED")) {
                    JobState jobState = JobState.CANCELED;
                    return jobState;
                }
            } else {
                if (ActivityStateEnumeration.CANCELLED.equals(state)) {
                    JobState jobState = JobState.CANCELED;
                    return jobState;
                }
                if (ActivityStateEnumeration.FAILED.equals(state)) {
                    JobState jobState = JobState.FAILED;
                    return jobState;
                }
                if (ActivityStateEnumeration.FINISHED.equals(state)) {
                    JobState jobState = JobState.COMPLETE;
                    return jobState;
                }
                if (ActivityStateEnumeration.RUNNING.equals(state)) {
                    JobState jobState = JobState.ACTIVE;
                    return jobState;
                }
            }
        }
        finally {
            if (acursor != null) {
                acursor.dispose();
            }
        }
        return JobState.UNKNOWN;
    }

    public boolean cancelJob(JobExecutionContext jobExecutionContext) throws GFacProviderException {
        try {
            String activityEpr = jobExecutionContext.getJobDetails().getJobDescription();
            EndpointReferenceType eprt = EndpointReferenceType.Factory.parse((String)activityEpr);
            JobSubmissionInterface preferredJobSubmissionInterface = jobExecutionContext.getPreferredJobSubmissionInterface();
            JobSubmissionProtocol protocol = preferredJobSubmissionInterface.getJobSubmissionProtocol();
            String interfaceId = preferredJobSubmissionInterface.getJobSubmissionInterfaceId();
            String factoryUrl = null;
            if (protocol.equals((Object)JobSubmissionProtocol.UNICORE)) {
                UnicoreJobSubmission unicoreJobSubmission = GFacUtils.getUnicoreJobSubmission((String)interfaceId);
                factoryUrl = unicoreJobSubmission.getUnicoreEndPointURL();
            }
            EndpointReferenceType epr = EndpointReferenceType.Factory.newInstance();
            epr.addNewAddress().setStringValue(factoryUrl);
            FactoryClient factory = new FactoryClient(epr, (IClientConfiguration)this.secProperties);
            factory.terminateActivity(eprt);
            return true;
        }
        catch (Exception e) {
            throw new GFacProviderException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private String getUserName(JobExecutionContext context) {
        return "";
    }

    protected ActivityStatusType getStatus(FactoryClient fc, EndpointReferenceType activityEpr) throws UnknownActivityIdentifierFault {
        GetActivityStatusesDocument stats = GetActivityStatusesDocument.Factory.newInstance();
        stats.addNewGetActivityStatuses().setActivityIdentifierArray(new EndpointReferenceType[]{activityEpr});
        GetActivityStatusesResponseDocument resDoc = fc.getActivityStatuses(stats);
        ActivityStatusType activityStatus = resDoc.getGetActivityStatusesResponse().getResponseArray()[0].getActivityStatus();
        return activityStatus;
    }

    protected String formatStatusMessage(String activityUrl, String status) {
        return String.format("Activity %s is %s.\n", activityUrl, status);
    }

    protected String subStatusAsString(ActivityStatusType statusType) {
        StringBuffer sb = new StringBuffer();
        sb.append(statusType.getState().toString());
        XmlCursor acursor = statusType.newCursor();
        if (acursor.toFirstChild()) {
            do {
                if (!acursor.getName().getNamespaceURI().equals("http://schemas.ogf.org/hpcp/2007/01/fs")) continue;
                sb.append(":");
                sb.append(acursor.getName().getLocalPart());
            } while (acursor.toNextSibling());
            acursor.dispose();
            return sb.toString();
        }
        acursor.dispose();
        return sb.toString();
    }

    private String getCNFromUserDN(String userDN) {
        return X500NameUtils.getAttributeValues((String)userDN, (ASN1ObjectIdentifier)BCStyle.CN)[0];
    }

    public void initProperties(Map<String, String> properties) throws GFacProviderException, GFacException {
    }

    public void dispose(JobExecutionContext jobExecutionContext) throws GFacProviderException, GFacException {
        this.secProperties = null;
    }

    public void recover(JobExecutionContext jobExecutionContext) throws GFacProviderException, GFacException {
    }

    public void monitor(JobExecutionContext jobExecutionContext) throws GFacProviderException, GFacException {
    }

    protected void waitUntilDone(EndpointReferenceType factoryEpr, EndpointReferenceType activityEpr, JobDetails jobDetails, DefaultClientConfiguration secProperties) throws Exception {
        try {
            FactoryClient factoryClient = new FactoryClient(factoryEpr, (IClientConfiguration)secProperties);
            JobState applicationJobStatus = null;
            while (factoryClient.getActivityStatus(activityEpr) != ActivityStateEnumeration.FINISHED && factoryClient.getActivityStatus(activityEpr) != ActivityStateEnumeration.FAILED && factoryClient.getActivityStatus(activityEpr) != ActivityStateEnumeration.CANCELLED && applicationJobStatus != JobState.COMPLETE) {
                ActivityStatusType activityStatus = this.getStatus(factoryClient, activityEpr);
                applicationJobStatus = this.getApplicationJobStatus(activityStatus);
                this.sendNotification(this.jobExecutionContext, applicationJobStatus);
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (Exception e) {
            this.log.error("Error monitoring job status..");
            throw e;
        }
    }

    private void sendNotification(JobExecutionContext jobExecutionContext, JobState status) {
        JobStatusChangeRequestEvent jobStatus = new JobStatusChangeRequestEvent();
        JobIdentifier jobIdentity = new JobIdentifier(jobExecutionContext.getJobDetails().getJobID(), jobExecutionContext.getTaskData().getTaskID(), jobExecutionContext.getWorkflowNodeDetails().getNodeInstanceId(), jobExecutionContext.getExperimentID(), jobExecutionContext.getGatewayID());
        jobStatus.setJobIdentity(jobIdentity);
        jobStatus.setState(status);
        this.log.debug(jobStatus.getJobIdentity().getJobId(), new Object[]{"Published job status change request, experiment {} , task {}", jobStatus.getJobIdentity().getExperimentId(), jobStatus.getJobIdentity().getTaskId()});
        this.monitorPublisher.publish((Object)jobStatus);
    }
}

