/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.bes.handlers;

import org.apache.airavata.gfac.bes.handlers.AbstractSMSHandler;
import org.apache.airavata.gfac.bes.utils.ActivityInfo;
import org.apache.airavata.gfac.core.context.JobExecutionContext;
import org.apache.airavata.gfac.core.handler.GFacHandler;
import org.apache.airavata.gfac.core.handler.GFacHandlerException;
import org.apache.airavata.gfac.core.provider.GFacProviderException;
import org.ggf.schemas.bes.x2006.x08.besFactory.ActivityStateEnumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMSByteIOOutHandler
extends AbstractSMSHandler
implements GFacHandler {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke(JobExecutionContext jobExecutionContext) throws GFacHandlerException {
        block23: {
            super.invoke(jobExecutionContext);
            ActivityInfo activityInfo = (ActivityInfo)jobExecutionContext.getProperty("bes.activity.info");
            try {
                if (activityInfo == null) {
                    this.log.error("No ActivityInfo instance found. The activity execution is ended due to an exception, see provider logs");
                    return;
                }
                if (activityInfo.getActivityStatus().getState() == ActivityStateEnumeration.FAILED) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    try {
                        this.dataTransferrer.downloadStdOuts();
                        break block23;
                    }
                    catch (GFacProviderException e) {
                        throw new GFacHandlerException("Cannot download stdout data", (Throwable)e);
                    }
                }
                if (activityInfo.getActivityStatus().getState() != ActivityStateEnumeration.FINISHED) break block23;
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                try {
                    if (activityInfo.getActivityStatus().getExitCode() == 0) {
                        this.dataTransferrer.downloadRemoteFiles();
                    } else {
                        this.dataTransferrer.downloadStdOuts();
                    }
                }
                catch (GFacProviderException e) {
                    throw new GFacHandlerException("Cannot download stdout data", (Throwable)e);
                }
            }
            finally {
                try {
                    if (this.storageClient != null) {
                        this.storageClient.destroy();
                    }
                }
                catch (Exception e) {
                    this.log.warn("Cannot destroy temporary SMS instance", (Throwable)e);
                }
            }
        }
    }

    public void recover(JobExecutionContext jobExecutionContext) throws GFacHandlerException {
    }
}

