/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.bes.handlers;

import de.fzj.unicore.uas.client.StorageClient;
import eu.unicore.util.httpclient.DefaultClientConfiguration;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Properties;
import org.airavata.appcatalog.cpi.AppCatalogException;
import org.apache.airavata.gfac.GFacException;
import org.apache.airavata.gfac.bes.security.UNICORESecurityContext;
import org.apache.airavata.gfac.bes.utils.BESConstants;
import org.apache.airavata.gfac.bes.utils.DataTransferrer;
import org.apache.airavata.gfac.bes.utils.SecurityUtils;
import org.apache.airavata.gfac.bes.utils.StorageCreator;
import org.apache.airavata.gfac.core.context.JobExecutionContext;
import org.apache.airavata.gfac.core.handler.GFacHandler;
import org.apache.airavata.gfac.core.handler.GFacHandlerException;
import org.apache.airavata.gfac.core.utils.GFacUtils;
import org.apache.airavata.model.appcatalog.computeresource.JobSubmissionInterface;
import org.apache.airavata.model.appcatalog.computeresource.JobSubmissionProtocol;
import org.apache.airavata.model.appcatalog.computeresource.UnicoreJobSubmission;
import org.apache.airavata.model.workspace.experiment.CorrectiveAction;
import org.apache.airavata.model.workspace.experiment.ErrorCategory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public abstract class AbstractSMSHandler
implements BESConstants,
GFacHandler {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    protected DefaultClientConfiguration secProperties;
    protected StorageClient storageClient;
    protected DataTransferrer dataTransferrer;

    public void initProperties(Properties properties) throws GFacHandlerException {
    }

    public void invoke(JobExecutionContext jobExecutionContext) throws GFacHandlerException {
        try {
            EndpointReferenceType eprt;
            this.initSecurityProperties(jobExecutionContext);
            JobSubmissionInterface preferredJobSubmissionInterface = jobExecutionContext.getPreferredJobSubmissionInterface();
            JobSubmissionProtocol protocol = preferredJobSubmissionInterface.getJobSubmissionProtocol();
            String interfaceId = preferredJobSubmissionInterface.getJobSubmissionInterfaceId();
            String factoryUrl = null;
            if (protocol.equals((Object)JobSubmissionProtocol.UNICORE)) {
                UnicoreJobSubmission unicoreJobSubmission = GFacUtils.getUnicoreJobSubmission((String)interfaceId);
                factoryUrl = unicoreJobSubmission.getUnicoreEndPointURL();
            }
            this.storageClient = null;
            if (!this.isSMSInstanceExisting(jobExecutionContext)) {
                eprt = EndpointReferenceType.Factory.newInstance();
                eprt.addNewAddress().setStringValue(factoryUrl);
                StorageCreator storageCreator = new StorageCreator(this.secProperties, factoryUrl, 5, null);
                try {
                    this.storageClient = storageCreator.createStorage();
                }
                catch (Exception e2) {
                    this.log.error("Cannot create storage..");
                    throw new GFacHandlerException("Cannot create storage..", (Throwable)e2);
                }
                jobExecutionContext.setProperty("unicore.sms.epr", (Object)this.storageClient.getEPR());
            } else {
                eprt = (EndpointReferenceType)jobExecutionContext.getProperty("unicore.sms.epr");
                try {
                    this.storageClient = new StorageClient(eprt, (IClientConfiguration)this.secProperties);
                }
                catch (Exception e) {
                    throw new GFacHandlerException("Cannot create storage..", (Throwable)e);
                }
            }
            this.dataTransferrer = new DataTransferrer(jobExecutionContext, this.storageClient);
        }
        catch (AppCatalogException e) {
            throw new GFacHandlerException("Error occurred while retrieving unicore job submission interface..", (Throwable)e);
        }
    }

    protected void initSecurityProperties(JobExecutionContext jobExecutionContext) throws GFacHandlerException {
        UNICORESecurityContext unicoreContext;
        this.log.debug("Initializing SMSInHandler security properties ..");
        if (this.secProperties != null) {
            this.secProperties = this.secProperties.clone();
            return;
        }
        try {
            if (jobExecutionContext.getSecurityContext("x509.security.context") == null) {
                SecurityUtils.addSecurityContext(jobExecutionContext);
                this.log.info("Successfully added the UNICORE Security Context");
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage());
            try {
                StringWriter errors = new StringWriter();
                e.printStackTrace(new PrintWriter(errors));
                GFacUtils.saveErrorDetails((JobExecutionContext)jobExecutionContext, (String)errors.toString(), (CorrectiveAction)CorrectiveAction.CONTACT_SUPPORT, (ErrorCategory)ErrorCategory.AIRAVATA_INTERNAL_ERROR);
            }
            catch (GFacException e1) {
                this.log.error(e1.getLocalizedMessage());
            }
            throw new GFacHandlerException("Error while creating UNICORESecurityContext", e, new String[]{e.getLocalizedMessage()});
        }
        try {
            unicoreContext = (UNICORESecurityContext)jobExecutionContext.getSecurityContext("x509.security.context");
            this.log.info("Successfully retrieved the UNICORE Security Context");
        }
        catch (GFacException e) {
            throw new GFacHandlerException((Exception)((Object)e));
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Generating client's default security configuration..");
        }
        try {
            this.secProperties = unicoreContext.getDefaultConfiguration(false);
        }
        catch (Exception e) {
            throw new GFacHandlerException(e);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Security properties are initialized.");
        }
        jobExecutionContext.setProperty("bes.client.config", (Object)this.secProperties);
    }

    protected boolean isSMSInstanceExisting(JobExecutionContext jec) {
        boolean hasSMS = true;
        if (null == jec.getProperty("unicore.sms.epr")) {
            hasSMS = false;
        }
        return hasSMS;
    }

    protected boolean isSMSEnabled(JobExecutionContext jobExecutionContext) {
        return false;
    }
}

