/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.bes.utils;

import de.fzj.unicore.uas.StorageFactory;
import de.fzj.unicore.uas.client.StorageClient;
import de.fzj.unicore.uas.client.StorageFactoryClient;
import de.fzj.unicore.wsrflite.xmlbeans.WSUtilities;
import de.fzj.unicore.wsrflite.xmlbeans.client.RegistryClient;
import de.fzj.unicore.wsrflite.xmlbeans.sg.Registry;
import eu.unicore.util.httpclient.DefaultClientConfiguration;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.util.Calendar;
import javax.security.auth.x500.X500Principal;
import javax.xml.namespace.QName;
import org.oasisOpen.docs.wsrf.sg2.EntryType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.unigrids.services.atomic.types.PropertyType;
import org.unigrids.x2006.x04.services.smf.CreateSMSDocument;
import org.unigrids.x2006.x04.services.smf.StorageBackendParametersDocument;
import org.unigrids.x2006.x04.services.smf.StorageDescriptionType;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class StorageCreator {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private int initialLifeTime;
    private String factoryUrl;
    private String siteName;
    private String storageType;
    private DefaultClientConfiguration secProps;
    private String userName;

    public StorageCreator(DefaultClientConfiguration secProps, String besUrl, int initialLifetime, String storageType, String userName) {
        this.secProps = secProps;
        this.factoryUrl = StorageCreator.getStorageFactoryUrl(besUrl);
        this.storageType = storageType;
        this.initialLifeTime = initialLifetime;
        this.userName = userName;
    }

    public StorageCreator(DefaultClientConfiguration secProps, String besUrl, int initialLifetime, String userName) {
        this.secProps = secProps;
        this.factoryUrl = StorageCreator.getStorageFactoryUrl(besUrl);
        this.initialLifeTime = initialLifetime;
        this.userName = userName;
    }

    public StorageClient createStorage() throws Exception {
        if (this.factoryUrl == null) {
            throw new Exception("Cannot create Storage Factory Url");
        }
        EndpointReferenceType sfEpr = WSUtilities.makeServiceEPR((String)this.factoryUrl, (QName)StorageFactory.SMF_PORT);
        String dn = this.findServerName(this.factoryUrl, sfEpr);
        WSUtilities.addServerIdentity((EndpointReferenceType)sfEpr, (String)dn);
        this.secProps.getETDSettings().setReceiver(new X500Principal(dn));
        this.secProps.getETDSettings().setIssuerCertificateChain(this.secProps.getCredential().getCertificateChain());
        if (this.userName != null) {
            this.secProps.getETDSettings().getRequestedUserAttributes2().put("xlogin", new String[]{this.userName});
        }
        StorageFactoryClient sfc = new StorageFactoryClient(sfEpr, (IClientConfiguration)this.secProps);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Using storage factory at <" + sfc.getUrl() + ">");
        }
        StorageClient sc = null;
        try {
            sc = sfc.createSMS(this.getCreateSMSDocument(new String[0]));
            String addr = sc.getEPR().getAddress().getStringValue();
            this.log.info(addr);
        }
        catch (Exception ex) {
            this.log.error("Could not create storage", (Throwable)ex);
            throw new Exception(ex);
        }
        return sc;
    }

    protected String findServerName(String besUrl, EndpointReferenceType smsEpr) throws Exception {
        int besIndex = besUrl.indexOf("StorageFactory?res");
        String ss = besUrl.substring(0, besIndex);
        ss = ss + "Registry";
        EndpointReferenceType eprt = WSUtilities.makeServiceEPR((String)ss, (String)"default_registry", (QName)Registry.REGISTRY_PORT);
        RegistryClient registry = new RegistryClient(eprt, (IClientConfiguration)this.secProps);
        String dn = WSUtilities.extractServerIDFromEPR((EndpointReferenceType)smsEpr);
        if (dn != null) {
            return dn;
        }
        String url = smsEpr.getAddress().getStringValue();
        if (url.contains("/services/")) {
            url = url.substring(0, url.indexOf("/services"));
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Checking for services at " + url);
        }
        for (EntryType entry : registry.listEntries()) {
            if (!entry.getMemberServiceEPR().getAddress().getStringValue().startsWith(url) || (dn = WSUtilities.extractServerIDFromEPR((EndpointReferenceType)entry.getMemberServiceEPR())) == null) continue;
            return dn;
        }
        return null;
    }

    public static String getStorageFactoryUrl(String besUrl) {
        int besIndex = besUrl.indexOf("BESFactory?res");
        String ss = besUrl.substring(0, besIndex);
        ss = ss + "StorageFactory?res=default_storage_factory";
        return ss;
    }

    protected CreateSMSDocument getCreateSMSDocument(String ... keyValueParams) {
        CreateSMSDocument in = CreateSMSDocument.Factory.newInstance();
        in.addNewCreateSMS();
        if (this.initialLifeTime > 0) {
            in.getCreateSMS().addNewTerminationTime().setCalendarValue(this.getTermTime());
        }
        if (this.storageType != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Will create storage of type : " + this.storageType);
            }
            StorageDescriptionType desc = in.getCreateSMS().addNewStorageDescription();
            desc.setStorageBackendType(this.storageType);
            if (keyValueParams.length > 1) {
                StorageBackendParametersDocument.StorageBackendParameters params = desc.addNewStorageBackendParameters();
                for (int i = 1; i < keyValueParams.length; ++i) {
                    String arg = keyValueParams[i];
                    String[] sp = arg.split("=", 2);
                    PropertyType prop = params.addNewProperty();
                    prop.setName(sp[0]);
                    prop.setValue(sp[1]);
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug("Have parameter : " + arg);
                }
            }
        }
        return in;
    }

    protected Calendar getTermTime() {
        Calendar c = Calendar.getInstance();
        c.add(5, this.initialLifeTime);
        return c;
    }
}

