/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.bes.utils;

import java.io.File;
import java.net.URI;
import java.util.Map;
import org.apache.airavata.commons.gfac.type.ActualParameter;
import org.apache.airavata.gfac.bes.utils.ApplicationProcessor;
import org.apache.airavata.gfac.bes.utils.JSDLUtils;
import org.apache.airavata.gfac.bes.utils.URIUtils;
import org.apache.airavata.gfac.core.context.JobExecutionContext;
import org.apache.airavata.gfac.core.utils.GFacUtils;
import org.apache.airavata.schemas.gfac.HpcApplicationDeploymentType;
import org.apache.airavata.schemas.gfac.StringArrayType;
import org.apache.airavata.schemas.gfac.StringParameterType;
import org.apache.airavata.schemas.gfac.URIArrayType;
import org.apache.airavata.schemas.gfac.URIParameterType;
import org.apache.airavata.schemas.gfac.UnicoreHostType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobDefinitionType;

public class DataStagingProcessor {
    public static void generateDataStagingElements(JobDefinitionType value, JobExecutionContext context) throws Exception {
        HpcApplicationDeploymentType appDepType = (HpcApplicationDeploymentType)context.getApplicationContext().getApplicationDeploymentDescription().getType();
        String gridftpEndpoint = ((UnicoreHostType)context.getApplicationContext().getHostDescription().getType()).getGridFTPEndPointArray()[0];
        if (context.getInMessageContext().getParameters().size() > 0) {
            DataStagingProcessor.buildDataStagingFromInputContext(context, value, gridftpEndpoint, appDepType);
        }
        if (context.getOutMessageContext().getParameters().size() > 0) {
            DataStagingProcessor.buildFromOutputContext(context, value, gridftpEndpoint, appDepType);
        }
        DataStagingProcessor.createStdOutURIs(value, appDepType, gridftpEndpoint, DataStagingProcessor.isUnicoreEndpoint(context));
    }

    private static void createInURIElement(JobDefinitionType value, String endpoint, String inputDir, ActualParameter inParam) throws Exception {
        String uri = ((URIParameterType)inParam.getType()).getValue();
        String fileName = new File(uri).getName();
        if (uri.startsWith("file")) {
            URI gridFTPInputDirURI = URIUtils.createGsiftpURI(endpoint, inputDir);
            String filePath = gridFTPInputDirURI.toString() + File.separator + fileName;
            JSDLUtils.addDataStagingSourceElement(value, filePath, null, fileName);
        } else if (uri.startsWith("gsiftp") || uri.startsWith("http") || uri.startsWith("rns")) {
            JSDLUtils.addDataStagingSourceElement(value, uri, null, fileName);
        }
    }

    private static void createStdOutURIs(JobDefinitionType value, HpcApplicationDeploymentType appDepType, String endpoint, boolean isUnicore) throws Exception {
        URI remoteOutputDir = URIUtils.createGsiftpURI(endpoint, appDepType.getOutputDataDirectory());
        String stdout = ApplicationProcessor.getApplicationStdOut(value, appDepType);
        String stderr = ApplicationProcessor.getApplicationStdErr(value, appDepType);
        String stdoutFileName = stdout == null || stdout.equals("") ? "stdout" : stdout;
        String stdoutURI = GFacUtils.createGsiftpURIAsString((String)remoteOutputDir.toString(), (String)stdoutFileName);
        JSDLUtils.addDataStagingTargetElement(value, null, stdoutFileName, stdoutURI);
        String stderrFileName = stdout == null || stderr.equals("") ? "stderr" : stderr;
        String stderrURI = GFacUtils.createGsiftpURIAsString((String)remoteOutputDir.toString(), (String)stderrFileName);
        JSDLUtils.addDataStagingTargetElement(value, null, stderrFileName, stderrURI);
        if (isUnicore) {
            String scriptExitCodeFName = "UNICORE_SCRIPT_EXIT_CODE";
            String scriptExitCode = GFacUtils.createGsiftpURIAsString((String)remoteOutputDir.toString(), (String)scriptExitCodeFName);
            JSDLUtils.addDataStagingTargetElement(value, null, scriptExitCodeFName, scriptExitCode.toString());
        }
    }

    private static void createOutStringElements(JobDefinitionType value, HpcApplicationDeploymentType appDeptype, String endpoint, String prmValue) throws Exception {
        if (prmValue == null || "".equals(prmValue)) {
            return;
        }
        String outputUri = GFacUtils.createGsiftpURIAsString((String)endpoint, (String)appDeptype.getOutputDataDirectory());
        URI finalOutputUri = URIUtils.createGsiftpURI(outputUri, prmValue);
        JSDLUtils.addDataStagingTargetElement(value, null, prmValue, finalOutputUri.toString());
    }

    private static void createOutURIElement(JobDefinitionType value, String prmValue) throws Exception {
        String fileName = new File(prmValue.toString()).getName();
        JSDLUtils.addDataStagingTargetElement(value, null, fileName, prmValue);
    }

    private static JobDefinitionType buildFromOutputContext(JobExecutionContext context, JobDefinitionType value, String gridftpEndpoint, HpcApplicationDeploymentType appDepType) throws Exception {
        Map outputParams = context.getOutMessageContext().getParameters();
        for (String paramKey : outputParams.keySet()) {
            ActualParameter outParam = (ActualParameter)outputParams.get(paramKey);
            String paramDataType = outParam.getType().getType().toString();
            if ("URI".equals(paramDataType)) {
                String uriPrm = ((URIParameterType)outParam.getType()).getValue();
                DataStagingProcessor.createOutURIElement(value, uriPrm);
                continue;
            }
            if ("URIArray".equals(paramDataType)) {
                String[] uriArray;
                for (String u : uriArray = ((URIArrayType)outParam.getType()).getValueArray()) {
                    DataStagingProcessor.createOutURIElement(value, u);
                }
                continue;
            }
            if ("String".equals(paramDataType)) {
                String stringPrm = ((StringParameterType)outParam.getType()).getValue();
                DataStagingProcessor.createOutStringElements(value, appDepType, gridftpEndpoint, stringPrm);
                continue;
            }
            if (!"StringArray".equals(paramDataType)) continue;
            String[] valueArray = ((StringArrayType)outParam.getType()).getValueArray();
            for (String v : valueArray) {
                DataStagingProcessor.createOutStringElements(value, appDepType, gridftpEndpoint, v);
            }
        }
        return value;
    }

    private static void buildDataStagingFromInputContext(JobExecutionContext context, JobDefinitionType value, String gridftpEndpoint, HpcApplicationDeploymentType appDepType) throws Exception {
        Map inputParams = context.getInMessageContext().getParameters();
        for (String paramKey : inputParams.keySet()) {
            ActualParameter inParam = (ActualParameter)inputParams.get(paramKey);
            String paramDataType = inParam.getType().getType().toString();
            if ("URI".equals(paramDataType)) {
                DataStagingProcessor.createInURIElement(value, gridftpEndpoint, appDepType.getInputDataDirectory(), inParam);
                continue;
            }
            if (!"String".equals(paramDataType)) continue;
            String stringPrm = ((StringParameterType)inParam.getType()).getValue();
            ApplicationProcessor.addApplicationArgument(value, appDepType, stringPrm);
        }
    }

    public static boolean isUnicoreEndpoint(JobExecutionContext context) {
        return context.getApplicationContext().getHostDescription().getType() instanceof UnicoreHostType;
    }
}

