/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.bes.utils;

import org.apache.airavata.gfac.bes.utils.ApplicationProcessor;
import org.apache.airavata.gfac.bes.utils.DataStagingProcessor;
import org.apache.airavata.gfac.bes.utils.JSDLUtils;
import org.apache.airavata.gfac.bes.utils.ResourceProcessor;
import org.apache.airavata.gfac.bes.utils.UASDataStagingProcessor;
import org.apache.airavata.gfac.core.context.JobExecutionContext;
import org.apache.airavata.schemas.gfac.HpcApplicationDeploymentType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobDefinitionDocument;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobDefinitionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSDLGenerator {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    public static synchronized JobDefinitionDocument buildJSDLInstance(JobExecutionContext context) throws Exception {
        JobDefinitionDocument jobDefDoc = JobDefinitionDocument.Factory.newInstance();
        JobDefinitionType value = jobDefDoc.addNewJobDefinition();
        HpcApplicationDeploymentType appDepType = (HpcApplicationDeploymentType)context.getApplicationContext().getApplicationDeploymentDescription().getType();
        JSDLGenerator.createJobIdentification(value, appDepType);
        ResourceProcessor.generateResourceElements(value, context);
        ApplicationProcessor.generateJobSpecificAppElements(value, context);
        DataStagingProcessor.generateDataStagingElements(value, context);
        return jobDefDoc;
    }

    public static synchronized JobDefinitionDocument buildJSDLInstance(JobExecutionContext context, String smsUrl) throws Exception {
        JobDefinitionDocument jobDefDoc = JobDefinitionDocument.Factory.newInstance();
        JobDefinitionType value = jobDefDoc.addNewJobDefinition();
        HpcApplicationDeploymentType appDepType = (HpcApplicationDeploymentType)context.getApplicationContext().getApplicationDeploymentDescription().getType();
        JSDLGenerator.createJobIdentification(value, appDepType);
        ResourceProcessor.generateResourceElements(value, context);
        ApplicationProcessor.generateJobSpecificAppElements(value, context);
        UASDataStagingProcessor.generateDataStagingElements(value, context, smsUrl);
        return jobDefDoc;
    }

    private static void createJobIdentification(JobDefinitionType value, HpcApplicationDeploymentType appDepType) {
        if (appDepType.getProjectAccount() != null) {
            if (appDepType.getProjectAccount().getProjectAccountNumber() != null) {
                JSDLUtils.addProjectName(value, appDepType.getProjectAccount().getProjectAccountNumber());
            }
            if (appDepType.getProjectAccount().getProjectAccountDescription() != null) {
                JSDLUtils.getOrCreateJobIdentification(value).setDescription(appDepType.getProjectAccount().getProjectAccountDescription());
            }
        }
    }
}

