/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.bes.utils;

import de.fzj.unicore.uas.client.StorageClient;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.airavata.commons.gfac.type.ActualParameter;
import org.apache.airavata.commons.gfac.type.ApplicationDescription;
import org.apache.airavata.gfac.Constants;
import org.apache.airavata.gfac.bes.utils.FileDownloader;
import org.apache.airavata.gfac.bes.utils.FileUploader;
import org.apache.airavata.gfac.bes.utils.Mode;
import org.apache.airavata.gfac.core.context.JobExecutionContext;
import org.apache.airavata.gfac.core.provider.GFacProviderException;
import org.apache.airavata.model.workspace.experiment.TaskDetails;
import org.apache.airavata.schemas.gfac.ApplicationDeploymentDescriptionType;
import org.apache.airavata.schemas.gfac.HpcApplicationDeploymentType;
import org.apache.airavata.schemas.gfac.StringArrayType;
import org.apache.airavata.schemas.gfac.StringParameterType;
import org.apache.airavata.schemas.gfac.URIParameterType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataTransferrer {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private JobExecutionContext jobContext;
    private StorageClient storageClient;

    public DataTransferrer(JobExecutionContext jobContext, StorageClient storageClient) {
        this.jobContext = jobContext;
        this.storageClient = storageClient;
    }

    public void uploadLocalFiles() throws GFacProviderException {
        Map inputParams = this.jobContext.getInMessageContext().getParameters();
        for (String paramKey : inputParams.keySet()) {
            ActualParameter inParam = (ActualParameter)inputParams.get(paramKey);
            String paramDataType = inParam.getType().getType().toString();
            if (!"URI".equals(paramDataType)) continue;
            String uri = ((URIParameterType)inParam.getType()).getValue();
            String fileName = new File(uri).getName();
            if (!uri.startsWith("file")) continue;
            try {
                String uriWithoutProtocol = uri.substring(uri.lastIndexOf("://") + 1, uri.length());
                FileUploader fileUploader = new FileUploader(uriWithoutProtocol, "input/" + fileName, Mode.overwrite);
                fileUploader.perform(this.storageClient);
            }
            catch (FileNotFoundException e3) {
                throw new GFacProviderException("Error while staging-in, local file " + fileName + " not found", (Throwable)e3);
            }
            catch (Exception e) {
                throw new GFacProviderException("Cannot upload files", (Throwable)e);
            }
        }
    }

    public void downloadRemoteFiles() throws GFacProviderException {
        String downloadLocation = this.getDownloadLocation();
        File file = new File(downloadLocation);
        if (!file.exists()) {
            file.mkdirs();
        }
        HashMap<String, ActualParameter> stringMap = new HashMap<String, ActualParameter>();
        Map outputParams = this.jobContext.getOutMessageContext().getParameters();
        for (String paramKey : outputParams.keySet()) {
            String[] valueArray;
            ActualParameter outParam = (ActualParameter)outputParams.get(paramKey);
            String paramDataType = outParam.getType().getType().toString();
            if ("String".equals(paramDataType)) {
                String stringPrm = ((StringParameterType)outParam.getType()).getValue();
                String localFileName = null;
                localFileName = stringPrm == null || stringPrm.isEmpty() ? "analysis-results.tar" : stringPrm.substring(stringPrm.lastIndexOf("/") + 1);
                String outputLocation = downloadLocation + File.separator + localFileName;
                FileDownloader fileDownloader = new FileDownloader("output/" + stringPrm, outputLocation, Mode.overwrite);
                try {
                    fileDownloader.perform(this.storageClient);
                    ((StringParameterType)outParam.getType()).setValue(outputLocation);
                    stringMap.put(paramKey, outParam);
                    continue;
                }
                catch (Exception e) {
                    throw new GFacProviderException(e.getLocalizedMessage(), (Throwable)e);
                }
            }
            if (!"StringArray".equals(paramDataType)) continue;
            for (String v : valueArray = ((StringArrayType)outParam.getType()).getValueArray()) {
                String localFileName = v.substring(v.lastIndexOf("/") + 1);
                String outputLocation = downloadLocation + File.separator + localFileName;
                FileDownloader fileDownloader = new FileDownloader("output/" + v, outputLocation, Mode.overwrite);
                try {
                    fileDownloader.perform(this.storageClient);
                    ((StringParameterType)outParam.getType()).setValue(outputLocation);
                    stringMap.put(paramKey, outParam);
                }
                catch (Exception e) {
                    throw new GFacProviderException(e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
        if (stringMap == null || stringMap.isEmpty()) {
            throw new GFacProviderException("Empty Output returned from the Application, Double check the applicationand ApplicationDescriptor output Parameter Names");
        }
        this.downloadStdOuts();
    }

    public void downloadStdOuts() throws GFacProviderException {
        String downloadLocation = this.getDownloadLocation();
        File file = new File(downloadLocation);
        if (!file.exists()) {
            file.mkdirs();
        }
        HpcApplicationDeploymentType appDepType = (HpcApplicationDeploymentType)this.jobContext.getApplicationContext().getApplicationDeploymentDescription().getType();
        String stdout = appDepType.getStandardOutput();
        String stderr = appDepType.getStandardError();
        if (stdout != null) {
            stdout = stdout.substring(stdout.lastIndexOf(47) + 1);
        }
        if (stderr != null) {
            stderr = stderr.substring(stderr.lastIndexOf(47) + 1);
        }
        String stdoutFileName = stdout == null || stdout.equals("") ? "stdout" : stdout;
        String stderrFileName = stdout == null || stderr.equals("") ? "stderr" : stderr;
        ApplicationDescription application = this.jobContext.getApplicationContext().getApplicationDeploymentDescription();
        ApplicationDeploymentDescriptionType appDesc = application.getType();
        String stdoutLocation = downloadLocation + File.separator + stdoutFileName;
        FileDownloader f1 = new FileDownloader("output/" + stdoutFileName, stdoutLocation, Mode.overwrite);
        try {
            f1.perform(this.storageClient);
            String stdoutput = this.readFile(stdoutLocation);
            appDesc.setStandardOutput(stdoutput);
        }
        catch (Exception e) {
            throw new GFacProviderException(e.getLocalizedMessage(), (Throwable)e);
        }
        String stderrLocation = downloadLocation + File.separator + stderrFileName;
        FileDownloader f2 = new FileDownloader("output/" + stderrFileName, stderrLocation, Mode.overwrite);
        try {
            f2.perform(this.storageClient);
            String stderror = this.readFile(stderrLocation);
            appDesc.setStandardError(stderror);
        }
        catch (Exception e) {
            throw new GFacProviderException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private String readFile(String localFile) throws IOException {
        BufferedReader instream = new BufferedReader(new FileReader(localFile));
        StringBuffer buff = new StringBuffer();
        String temp = null;
        while ((temp = instream.readLine()) != null) {
            buff.append(temp);
            buff.append(Constants.NEWLINE);
        }
        this.log.info("finish read file:" + localFile);
        return buff.toString();
    }

    private String getDownloadLocation() {
        TaskDetails taskData = this.jobContext.getTaskData();
        if (taskData != null && taskData.getAdvancedOutputDataHandling() != null) {
            String outputDataDirectory = taskData.getAdvancedOutputDataHandling().getOutputDataDir();
            return outputDataDirectory;
        }
        return null;
    }
}

