/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.bes.utils;

import java.io.File;
import org.apache.airavata.gfac.bes.utils.JSDLUtils;
import org.apache.airavata.gfac.bes.utils.SPMDVariations;
import org.apache.airavata.gfac.core.context.JobExecutionContext;
import org.apache.airavata.schemas.gfac.ExtendedKeyValueType;
import org.apache.airavata.schemas.gfac.HpcApplicationDeploymentType;
import org.apache.airavata.schemas.gfac.NameValuePairType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.ApplicationType;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobDefinitionType;
import org.ggf.schemas.jsdl.x2005.x11.jsdlPosix.EnvironmentType;
import org.ggf.schemas.jsdl.x2005.x11.jsdlPosix.FileNameType;
import org.ggf.schemas.jsdl.x2005.x11.jsdlPosix.UserNameType;
import org.ogf.schemas.jsdl.x2007.x02.jsdlSpmd.NumberOfProcessesType;
import org.ogf.schemas.jsdl.x2007.x02.jsdlSpmd.ProcessesPerHostType;
import org.ogf.schemas.jsdl.x2007.x02.jsdlSpmd.ThreadsPerProcessType;

public class ApplicationProcessor {
    public static void generateJobSpecificAppElements(JobDefinitionType value, JobExecutionContext context) {
        String userName = ApplicationProcessor.getUserNameFromContext(context);
        if (userName.equalsIgnoreCase("admin")) {
            userName = "CN=zdv575, O=Ultrascan Gateway, C=DE";
        }
        HpcApplicationDeploymentType appDepType = (HpcApplicationDeploymentType)context.getApplicationContext().getApplicationDeploymentDescription().getType();
        ApplicationProcessor.createGenericApplication(value, appDepType);
        if (appDepType.getApplicationEnvironmentArray().length > 0) {
            ApplicationProcessor.createApplicationEnvironment(value, appDepType.getApplicationEnvironmentArray(), appDepType);
        }
        if (appDepType.getExecutableLocation() != null) {
            UserNameType userNameType;
            FileNameType fNameType = FileNameType.Factory.newInstance();
            fNameType.setStringValue(appDepType.getExecutableLocation());
            if (ApplicationProcessor.isParallelJob(appDepType)) {
                JSDLUtils.getOrCreateSPMDApplication(value).setExecutable(fNameType);
                JSDLUtils.getSPMDApplication(value).setSPMDVariation(ApplicationProcessor.getSPMDVariation(appDepType));
                if (ApplicationProcessor.getValueFromMap(appDepType, "NumberOfProcesses") != null) {
                    NumberOfProcessesType num = NumberOfProcessesType.Factory.newInstance();
                    num.setStringValue(ApplicationProcessor.getValueFromMap(appDepType, "NumberOfProcesses"));
                    JSDLUtils.getSPMDApplication(value).setNumberOfProcesses(num);
                }
                if (ApplicationProcessor.getValueFromMap(appDepType, "ProcessesPerHost") != null) {
                    ProcessesPerHostType pph = ProcessesPerHostType.Factory.newInstance();
                    pph.setStringValue(ApplicationProcessor.getValueFromMap(appDepType, "ProcessesPerHost"));
                    JSDLUtils.getSPMDApplication(value).setProcessesPerHost(pph);
                }
                if (ApplicationProcessor.getValueFromMap(appDepType, "ThreadsPerHost") != null) {
                    ThreadsPerProcessType tpp = ThreadsPerProcessType.Factory.newInstance();
                    tpp.setStringValue(ApplicationProcessor.getValueFromMap(appDepType, "ThreadsPerHost"));
                    JSDLUtils.getSPMDApplication(value).setThreadsPerProcess(tpp);
                }
                if (userName != null) {
                    userNameType = UserNameType.Factory.newInstance();
                    userNameType.setStringValue(userName);
                    JSDLUtils.getSPMDApplication(value).setUserName(userNameType);
                }
            } else {
                JSDLUtils.getOrCreatePOSIXApplication(value).setExecutable(fNameType);
                if (userName != null) {
                    userNameType = UserNameType.Factory.newInstance();
                    userNameType.setStringValue(userName);
                    JSDLUtils.getOrCreatePOSIXApplication(value).setUserName(userNameType);
                }
            }
        }
        String stdout = appDepType.getStandardOutput() != null ? new File(appDepType.getStandardOutput()).getName() : "stdout";
        ApplicationProcessor.setApplicationStdOut(value, appDepType, stdout);
        String stderr = appDepType.getStandardError() != null ? new File(appDepType.getStandardError()).getName() : "stderr";
        ApplicationProcessor.setApplicationStdErr(value, appDepType, stderr);
    }

    public static String getUserNameFromContext(JobExecutionContext jobContext) {
        if (jobContext.getTaskData() == null) {
            return null;
        }
        return "admin";
    }

    public static boolean isParallelJob(HpcApplicationDeploymentType appDepType) {
        boolean isParallel = false;
        if (appDepType.getJobType() != null) {
            int status = appDepType.getJobType().intValue();
            switch (status) {
                case 2: 
                case 3: {
                    isParallel = true;
                    break;
                }
                case 1: 
                case 4: {
                    isParallel = false;
                    break;
                }
                default: {
                    isParallel = false;
                }
            }
        }
        return isParallel;
    }

    public static void createApplicationEnvironment(JobDefinitionType value, NameValuePairType[] nameValuePairs, HpcApplicationDeploymentType appDepType) {
        if (ApplicationProcessor.isParallelJob(appDepType)) {
            for (NameValuePairType nv : nameValuePairs) {
                EnvironmentType envType = JSDLUtils.getOrCreateSPMDApplication(value).addNewEnvironment();
                envType.setName(nv.getName());
                envType.setStringValue(nv.getValue());
            }
        } else {
            for (NameValuePairType nv : nameValuePairs) {
                EnvironmentType envType = JSDLUtils.getOrCreatePOSIXApplication(value).addNewEnvironment();
                envType.setName(nv.getName());
                envType.setStringValue(nv.getValue());
            }
        }
    }

    public static String getSPMDVariation(HpcApplicationDeploymentType appDepType) {
        String variation = null;
        if (appDepType.getJobType() != null) {
            int status = appDepType.getJobType().intValue();
            switch (status) {
                case 2: {
                    variation = SPMDVariations.MPI.value();
                    break;
                }
                case 3: {
                    variation = SPMDVariations.OpenMPI.value();
                }
            }
        }
        return variation;
    }

    public static void addApplicationArgument(JobDefinitionType value, HpcApplicationDeploymentType appDepType, String stringPrm) {
        if (ApplicationProcessor.isParallelJob(appDepType)) {
            JSDLUtils.getOrCreateSPMDApplication(value).addNewArgument().setStringValue(stringPrm);
        } else {
            JSDLUtils.getOrCreatePOSIXApplication(value).addNewArgument().setStringValue(stringPrm);
        }
    }

    public static void setApplicationStdErr(JobDefinitionType value, HpcApplicationDeploymentType appDepType, String stderr) {
        FileNameType fName = FileNameType.Factory.newInstance();
        fName.setStringValue(stderr);
        if (ApplicationProcessor.isParallelJob(appDepType)) {
            JSDLUtils.getOrCreateSPMDApplication(value).setError(fName);
        } else {
            JSDLUtils.getOrCreatePOSIXApplication(value).setError(fName);
        }
    }

    public static void setApplicationStdOut(JobDefinitionType value, HpcApplicationDeploymentType appDepType, String stderr) {
        FileNameType fName = FileNameType.Factory.newInstance();
        fName.setStringValue(stderr);
        if (ApplicationProcessor.isParallelJob(appDepType)) {
            JSDLUtils.getOrCreateSPMDApplication(value).setOutput(fName);
        } else {
            JSDLUtils.getOrCreatePOSIXApplication(value).setOutput(fName);
        }
    }

    public static String getApplicationStdOut(JobDefinitionType value, HpcApplicationDeploymentType appDepType) throws RuntimeException {
        if (ApplicationProcessor.isParallelJob(appDepType)) {
            return JSDLUtils.getOrCreateSPMDApplication(value).getOutput().getStringValue();
        }
        return JSDLUtils.getOrCreatePOSIXApplication(value).getOutput().getStringValue();
    }

    public static String getApplicationStdErr(JobDefinitionType value, HpcApplicationDeploymentType appDepType) throws RuntimeException {
        if (ApplicationProcessor.isParallelJob(appDepType)) {
            return JSDLUtils.getOrCreateSPMDApplication(value).getError().getStringValue();
        }
        return JSDLUtils.getOrCreatePOSIXApplication(value).getError().getStringValue();
    }

    public static void createGenericApplication(JobDefinitionType value, HpcApplicationDeploymentType appDepType) {
        if (appDepType.getApplicationName() != null) {
            ApplicationType appType = JSDLUtils.getOrCreateApplication(value);
            String appName = appDepType.getApplicationName().getStringValue();
            appType.setApplicationName(appName);
            JSDLUtils.getOrCreateJobIdentification(value).setJobName(appName);
        }
    }

    public static String getValueFromMap(HpcApplicationDeploymentType appDepType, String name) {
        ExtendedKeyValueType[] extended;
        for (ExtendedKeyValueType e : extended = appDepType.getKeyValuePairsArray()) {
            if (!e.getName().equalsIgnoreCase(name)) continue;
            return e.getStringValue();
        }
        return null;
    }
}

