/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.gfac.bes.provider.impl;

import de.fzj.unicore.bes.client.FactoryClient;
import de.fzj.unicore.bes.faults.UnknownActivityIdentifierFault;
import de.fzj.unicore.uas.client.StorageClient;
import de.fzj.unicore.wsrflite.xmlbeans.WSUtilities;
import eu.emi.security.authn.x509.X509CertChainValidatorExt;
import eu.emi.security.authn.x509.X509Credential;
import eu.emi.security.authn.x509.helpers.CertificateHelpers;
import eu.emi.security.authn.x509.helpers.proxy.X509v3CertificateBuilder;
import eu.emi.security.authn.x509.impl.CertificateUtils;
import eu.emi.security.authn.x509.impl.DirectoryCertChainValidator;
import eu.emi.security.authn.x509.impl.KeyAndCertCredential;
import eu.emi.security.authn.x509.impl.X500NameUtils;
import eu.unicore.util.httpclient.DefaultClientConfiguration;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import javax.security.auth.x500.X500Principal;
import org.apache.airavata.gfac.GFacException;
import org.apache.airavata.gfac.bes.security.GSISecurityContext;
import org.apache.airavata.gfac.bes.utils.DataTransferrer;
import org.apache.airavata.gfac.bes.utils.JSDLGenerator;
import org.apache.airavata.gfac.bes.utils.StorageCreator;
import org.apache.airavata.gfac.core.context.JobExecutionContext;
import org.apache.airavata.gfac.core.notification.events.GFacEvent;
import org.apache.airavata.gfac.core.notification.events.StatusChangeEvent;
import org.apache.airavata.gfac.core.notification.events.UnicoreJobIDEvent;
import org.apache.airavata.gfac.core.provider.AbstractProvider;
import org.apache.airavata.gfac.core.provider.GFacProviderException;
import org.apache.airavata.gfac.core.utils.GFacUtils;
import org.apache.airavata.model.workspace.experiment.JobDetails;
import org.apache.airavata.model.workspace.experiment.JobState;
import org.apache.airavata.registry.api.workflow.ApplicationJob;
import org.apache.airavata.schemas.gfac.UnicoreHostType;
import org.apache.xmlbeans.XmlCursor;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.ggf.schemas.bes.x2006.x08.besFactory.ActivityStateEnumeration;
import org.ggf.schemas.bes.x2006.x08.besFactory.ActivityStatusType;
import org.ggf.schemas.bes.x2006.x08.besFactory.CreateActivityDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.CreateActivityResponseDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.GetActivityStatusesDocument;
import org.ggf.schemas.bes.x2006.x08.besFactory.GetActivityStatusesResponseDocument;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobDefinitionDocument;
import org.ggf.schemas.jsdl.x2005.x11.jsdl.JobDefinitionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3.x2005.x08.addressing.EndpointReferenceType;

public class BESProvider
extends AbstractProvider {
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private DefaultClientConfiguration secProperties;
    private String jobId;

    public void initialize(JobExecutionContext jobExecutionContext) throws GFacProviderException, GFacException {
        this.log.info("Initializing UNICORE Provider");
        super.initialize(jobExecutionContext);
        this.initSecurityProperties(jobExecutionContext);
        this.log.debug("initialized security properties");
    }

    public void execute(JobExecutionContext jobExecutionContext) throws GFacProviderException {
        block38: {
            UnicoreHostType host = (UnicoreHostType)jobExecutionContext.getApplicationContext().getHostDescription().getType();
            String factoryUrl = host.getUnicoreBESEndPointArray()[0];
            EndpointReferenceType eprt = EndpointReferenceType.Factory.newInstance();
            eprt.addNewAddress().setStringValue(factoryUrl);
            String userDN = this.getUserName(jobExecutionContext);
            if (userDN == null || userDN.equalsIgnoreCase("admin")) {
                userDN = "CN=zdv575, O=Ultrascan Gateway, C=DE";
            }
            String xlogin = this.getCNFromUserDN(userDN);
            StorageCreator storageCreator = new StorageCreator(this.secProperties, factoryUrl, 5, xlogin);
            StorageClient sc = null;
            try {
                ActivityStatusType activityStatus;
                try {
                    sc = storageCreator.createStorage();
                }
                catch (Exception e2) {
                    this.log.error("Cannot create storage..");
                    throw new GFacProviderException("Cannot create storage..", (Throwable)e2);
                }
                CreateActivityDocument cad = CreateActivityDocument.Factory.newInstance();
                JobDefinitionDocument jobDefDoc = JobDefinitionDocument.Factory.newInstance();
                JobDefinitionType jobDefinition = jobDefDoc.addNewJobDefinition();
                try {
                    jobDefinition = JSDLGenerator.buildJSDLInstance(jobExecutionContext, sc.getUrl()).getJobDefinition();
                    cad.addNewCreateActivity().addNewActivityDocument().setJobDefinition(jobDefinition);
                    this.log.info("JSDL" + jobDefDoc.toString());
                }
                catch (Exception e1) {
                    throw new GFacProviderException("Cannot generate JSDL instance from the JobExecutionContext.", (Throwable)e1);
                }
                DataTransferrer dt = new DataTransferrer(jobExecutionContext, sc);
                dt.uploadLocalFiles();
                FactoryClient factory = null;
                try {
                    factory = new FactoryClient(eprt, (IClientConfiguration)this.secProperties);
                }
                catch (Exception e) {
                    throw new GFacProviderException(e.getLocalizedMessage(), (Throwable)e);
                }
                CreateActivityResponseDocument response = null;
                try {
                    this.log.info(String.format("Activity Submitting to %s ... \n", factoryUrl));
                    response = factory.createActivity(cad);
                    this.log.info(String.format("Activity Submitted to %s \n", factoryUrl));
                }
                catch (Exception e) {
                    throw new GFacProviderException("Cannot create activity.", (Throwable)e);
                }
                EndpointReferenceType activityEpr = response.getCreateActivityResponse().getActivityIdentifier();
                this.log.info("Activity : " + activityEpr.getAddress().getStringValue() + " Submitted.");
                this.jobId = WSUtilities.extractResourceID((EndpointReferenceType)activityEpr);
                if (this.jobId == null) {
                    this.jobId = new Long(Calendar.getInstance().getTimeInMillis()).toString();
                }
                this.log.info("JobID: " + this.jobId);
                jobExecutionContext.getNotifier().publish((GFacEvent)new UnicoreJobIDEvent(this.jobId));
                this.saveApplicationJob(jobExecutionContext, jobDefinition, activityEpr.toString());
                factory.getActivityStatus(activityEpr);
                this.log.info(this.formatStatusMessage(activityEpr.getAddress().getStringValue(), factory.getActivityStatus(activityEpr).toString()));
                while (factory.getActivityStatus(activityEpr) != ActivityStateEnumeration.FINISHED && factory.getActivityStatus(activityEpr) != ActivityStateEnumeration.FAILED && factory.getActivityStatus(activityEpr) != ActivityStateEnumeration.CANCELLED) {
                    activityStatus = null;
                    try {
                        activityStatus = this.getStatus(factory, activityEpr);
                        JobState jobStatus = this.getApplicationJobStatus(activityStatus);
                        String jobStatusMessage = "Status of job " + this.jobId + "is " + jobStatus;
                        jobExecutionContext.getNotifier().publish((GFacEvent)new StatusChangeEvent(jobStatusMessage));
                        this.details.setJobID(this.jobId);
                        GFacUtils.updateJobStatus((JobExecutionContext)jobExecutionContext, (JobDetails)this.details, (JobState)jobStatus);
                    }
                    catch (UnknownActivityIdentifierFault e) {
                        throw new GFacProviderException(e.getMessage(), e.getCause());
                    }
                    catch (GFacException e) {
                        throw new GFacProviderException(e.getMessage(), e.getCause());
                    }
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e) {}
                }
                activityStatus = null;
                try {
                    activityStatus = this.getStatus(factory, activityEpr);
                }
                catch (UnknownActivityIdentifierFault e) {
                    throw new GFacProviderException(e.getMessage(), e.getCause());
                }
                this.log.info(this.formatStatusMessage(activityEpr.getAddress().getStringValue(), activityStatus.getState().toString()));
                if (activityStatus.getState() == ActivityStateEnumeration.FAILED) {
                    String error = activityStatus.getFault().getFaultcode().getLocalPart() + "\n" + activityStatus.getFault().getFaultstring() + "\n EXITCODE: " + activityStatus.getExitCode();
                    this.log.info(error);
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    dt.downloadStdOuts();
                    break block38;
                }
                if (activityStatus.getState() == ActivityStateEnumeration.CANCELLED) {
                    String experimentID = (String)jobExecutionContext.getProperty("topic");
                    JobState jobStatus = JobState.CANCELED;
                    String jobStatusMessage = "Status of job " + this.jobId + "is " + jobStatus;
                    jobExecutionContext.getNotifier().publish((GFacEvent)new StatusChangeEvent(jobStatusMessage));
                    this.details.setJobID(this.jobId);
                    try {
                        GFacUtils.saveJobStatus((JobExecutionContext)jobExecutionContext, (JobDetails)this.details, (JobState)jobStatus);
                    }
                    catch (GFacException e) {
                        throw new GFacProviderException(e.getLocalizedMessage(), (Throwable)e);
                    }
                    throw new GFacProviderException(experimentID + "Job Canceled");
                }
                if (activityStatus.getState() != ActivityStateEnumeration.FINISHED) break block38;
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (activityStatus.getExitCode() == 0) {
                    dt.downloadRemoteFiles();
                } else {
                    dt.downloadStdOuts();
                }
            }
            catch (UnknownActivityIdentifierFault e1) {
                throw new GFacProviderException(e1.getLocalizedMessage(), (Throwable)e1);
            }
            finally {
                try {
                    if (sc != null) {
                        sc.destroy();
                    }
                }
                catch (Exception e) {
                    this.log.warn("Cannot destroy temporary SMS instance:" + sc.getUrl(), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JobState getApplicationJobStatus(ActivityStatusType activityStatus) {
        if (activityStatus == null) {
            return JobState.UNKNOWN;
        }
        ActivityStateEnumeration.Enum state = activityStatus.getState();
        String status = null;
        XmlCursor acursor = activityStatus.newCursor();
        try {
            if (acursor.toFirstChild() && acursor.getName().getNamespaceURI().equals("http://schemas.ogf.org/hpcp/2007/01/fs")) {
                status = acursor.getName().getLocalPart();
            }
            if (status != null) {
                if (status.equalsIgnoreCase("Queued") || status.equalsIgnoreCase("Starting") || status.equalsIgnoreCase("Ready")) {
                    JobState jobState = JobState.QUEUED;
                    return jobState;
                }
                if (status.equalsIgnoreCase("Staging-In")) {
                    JobState jobState = JobState.SUBMITTED;
                    return jobState;
                }
                if (status.equalsIgnoreCase("Staging-Out") || status.equalsIgnoreCase("FINISHED")) {
                    JobState jobState = JobState.COMPLETE;
                    return jobState;
                }
                if (status.equalsIgnoreCase("Executing")) {
                    JobState jobState = JobState.ACTIVE;
                    return jobState;
                }
                if (status.equalsIgnoreCase("FAILED")) {
                    JobState jobState = JobState.FAILED;
                    return jobState;
                }
                if (status.equalsIgnoreCase("CANCELLED")) {
                    JobState jobState = JobState.CANCELED;
                    return jobState;
                }
            } else {
                if (ActivityStateEnumeration.CANCELLED.equals(state)) {
                    JobState jobState = JobState.CANCELED;
                    return jobState;
                }
                if (ActivityStateEnumeration.FAILED.equals(state)) {
                    JobState jobState = JobState.FAILED;
                    return jobState;
                }
                if (ActivityStateEnumeration.FINISHED.equals(state)) {
                    JobState jobState = JobState.COMPLETE;
                    return jobState;
                }
                if (ActivityStateEnumeration.RUNNING.equals(state)) {
                    JobState jobState = JobState.ACTIVE;
                    return jobState;
                }
            }
        }
        finally {
            if (acursor != null) {
                acursor.dispose();
            }
        }
        return JobState.UNKNOWN;
    }

    private void saveApplicationJob(JobExecutionContext jobExecutionContext, JobDefinitionType jobDefinition, String metadata) {
        ApplicationJob appJob = GFacUtils.createApplicationJob((JobExecutionContext)jobExecutionContext);
        appJob.setJobId(this.jobId);
        appJob.setJobData(jobDefinition.toString());
        appJob.setSubmittedTime(Calendar.getInstance().getTime());
        appJob.setStatus(ApplicationJob.ApplicationJobStatus.SUBMITTED);
        appJob.setStatusUpdateTime(appJob.getSubmittedTime());
        appJob.setMetadata(metadata);
        GFacUtils.recordApplicationJob((JobExecutionContext)jobExecutionContext, (ApplicationJob)appJob);
    }

    public void dispose(JobExecutionContext jobExecutionContext) throws GFacProviderException {
        this.secProperties = null;
    }

    public void cancelJob(String activityEpr, JobExecutionContext jobExecutionContext) throws GFacProviderException {
        try {
            this.initSecurityProperties(jobExecutionContext);
            EndpointReferenceType eprt = EndpointReferenceType.Factory.parse((String)activityEpr);
            UnicoreHostType host = (UnicoreHostType)jobExecutionContext.getApplicationContext().getHostDescription().getType();
            String factoryUrl = host.getUnicoreBESEndPointArray()[0];
            EndpointReferenceType epr = EndpointReferenceType.Factory.newInstance();
            epr.addNewAddress().setStringValue(factoryUrl);
            FactoryClient factory = new FactoryClient(epr, (IClientConfiguration)this.secProperties);
            factory.terminateActivity(eprt);
        }
        catch (Exception e) {
            throw new GFacProviderException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    protected void downloadOffline(String smsEpr, JobExecutionContext jobExecutionContext) throws GFacProviderException {
        try {
            this.initSecurityProperties(jobExecutionContext);
            EndpointReferenceType eprt = EndpointReferenceType.Factory.parse((String)smsEpr);
            StorageClient sms = new StorageClient(eprt, (IClientConfiguration)this.secProperties);
            DataTransferrer dt = new DataTransferrer(jobExecutionContext, sms);
            dt.downloadRemoteFiles();
        }
        catch (Exception e) {
            throw new GFacProviderException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    protected void initSecurityProperties(JobExecutionContext jobExecutionContext) throws GFacProviderException, GFacException {
        if (this.secProperties != null) {
            return;
        }
        GSISecurityContext gssContext = (GSISecurityContext)jobExecutionContext.getSecurityContext("gsi");
        try {
            String certLocation = gssContext.getTrustedCertificatePath();
            ArrayList<String> trustedCert = new ArrayList<String>();
            trustedCert.add(certLocation + "/*.0");
            trustedCert.add(certLocation + "/*.pem");
            DirectoryCertChainValidator dcValidator = new DirectoryCertChainValidator(trustedCert, CertificateUtils.Encoding.PEM, -1L, 60000, null);
            String userID = this.getUserName(jobExecutionContext);
            if (userID == null || "".equals(userID) || userID.equalsIgnoreCase("admin")) {
                userID = "CN=zdv575, O=Ultrascan Gateway, C=DE";
            }
            String userDN = userID.replaceAll("^\"|\"$", "");
            KeyAndCertCredential cred = this.generateShortLivedCertificate(userDN, certLocation + "/cacert.pem", certLocation + "/cakey.pem", "ultrascan3");
            this.secProperties = new DefaultClientConfiguration((X509CertChainValidatorExt)dcValidator, (X509Credential)cred);
            this.secProperties.getETDSettings().setExtendTrustDelegation(true);
            this.secProperties.setDoSignMessage(true);
            String[] outHandlers = this.secProperties.getOutHandlerClassNames();
            HashSet<Object> outHandlerLst = null;
            Properties p = this.secProperties.getExtraSettings();
            p.setProperty("http.connection.timeout", "300000");
            p.setProperty("http.socket.timeout", "300000");
            outHandlerLst = outHandlers == null ? new HashSet<String>() : new HashSet<String>(Arrays.asList(outHandlers));
            outHandlerLst.add("de.fzj.unicore.uas.security.ProxyCertOutHandler");
            this.secProperties.setOutHandlerClassNames(outHandlerLst.toArray(new String[outHandlerLst.size()]));
        }
        catch (Exception e) {
            throw new GFacProviderException(e.getMessage(), (Throwable)e);
        }
    }

    private String getUserName(JobExecutionContext context) {
        return "";
    }

    protected ActivityStatusType getStatus(FactoryClient fc, EndpointReferenceType activityEpr) throws UnknownActivityIdentifierFault {
        GetActivityStatusesDocument stats = GetActivityStatusesDocument.Factory.newInstance();
        stats.addNewGetActivityStatuses().setActivityIdentifierArray(new EndpointReferenceType[]{activityEpr});
        GetActivityStatusesResponseDocument resDoc = fc.getActivityStatuses(stats);
        ActivityStatusType activityStatus = resDoc.getGetActivityStatusesResponse().getResponseArray()[0].getActivityStatus();
        return activityStatus;
    }

    protected String formatStatusMessage(String activityUrl, String status) {
        return String.format("Activity %s is %s.\n", activityUrl, status);
    }

    protected String subStatusAsString(ActivityStatusType statusType) {
        StringBuffer sb = new StringBuffer();
        sb.append(statusType.getState().toString());
        XmlCursor acursor = statusType.newCursor();
        if (acursor.toFirstChild()) {
            do {
                if (!acursor.getName().getNamespaceURI().equals("http://schemas.ogf.org/hpcp/2007/01/fs")) continue;
                sb.append(":");
                sb.append(acursor.getName().getLocalPart());
            } while (acursor.toNextSibling());
            acursor.dispose();
            return sb.toString();
        }
        acursor.dispose();
        return sb.toString();
    }

    public void initProperties(Map<String, String> properties) throws GFacProviderException, GFacException {
    }

    protected KeyAndCertCredential generateShortLivedCertificate(String userDN, String caCertPath, String caKeyPath, String caPwd) throws Exception {
        SubjectPublicKeyInfo publicKeyInfo;
        long CredentialGoodFromOffset = 900000L;
        long startTime = System.currentTimeMillis() - 900000L;
        long endTime = startTime + 108000000L;
        String keyLengthProp = "1024";
        int keyLength = Integer.parseInt(keyLengthProp);
        String signatureAlgorithm = "SHA1withRSA";
        KeyAndCertCredential caCred = this.getCACredential(caCertPath, caKeyPath, caPwd);
        KeyPairGenerator kpg = KeyPairGenerator.getInstance(caCred.getKey().getAlgorithm());
        kpg.initialize(keyLength);
        KeyPair pair = kpg.generateKeyPair();
        X500Principal subjectDN = new X500Principal(userDN);
        Random rand = new Random();
        try {
            publicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)new ASN1InputStream(pair.getPublic().getEncoded()).readObject());
        }
        catch (IOException e) {
            throw new InvalidKeyException("Can not parse the public keybeing included in the short lived certificate", e);
        }
        X500Name issuerX500Name = CertificateHelpers.toX500Name((X500Principal)caCred.getCertificate().getSubjectX500Principal());
        X500Name subjectX500Name = CertificateHelpers.toX500Name((X500Principal)subjectDN);
        X509v3CertificateBuilder certBuilder = new X509v3CertificateBuilder(issuerX500Name, new BigInteger(20, rand), new Date(startTime), new Date(endTime), subjectX500Name, publicKeyInfo);
        AlgorithmIdentifier sigAlgId = X509v3CertificateBuilder.extractAlgorithmId((X509Certificate)caCred.getCertificate());
        X509Certificate certificate = certBuilder.build(caCred.getKey(), sigAlgId, signatureAlgorithm, null, null);
        certificate.checkValidity(new Date());
        certificate.verify(caCred.getCertificate().getPublicKey());
        KeyAndCertCredential result = new KeyAndCertCredential(pair.getPrivate(), new X509Certificate[]{certificate, caCred.getCertificate()});
        return result;
    }

    private KeyAndCertCredential getCACredential(String caCertPath, String caKeyPath, String password) throws Exception {
        FileInputStream isKey = new FileInputStream(caKeyPath);
        PrivateKey pk = CertificateUtils.loadPrivateKey((InputStream)isKey, (CertificateUtils.Encoding)CertificateUtils.Encoding.PEM, (char[])password.toCharArray());
        FileInputStream isCert = new FileInputStream(caCertPath);
        X509Certificate caCert = CertificateUtils.loadCertificate((InputStream)isCert, (CertificateUtils.Encoding)CertificateUtils.Encoding.PEM);
        if (isKey != null) {
            ((InputStream)isKey).close();
        }
        if (isCert != null) {
            ((InputStream)isCert).close();
        }
        return new KeyAndCertCredential(pk, new X509Certificate[]{caCert});
    }

    private String getCNFromUserDN(String userDN) {
        return X500NameUtils.getAttributeValues((String)userDN, (ASN1ObjectIdentifier)BCStyle.CN)[0];
    }
}

