/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.server;

import java.io.File;
import org.apache.airavata.common.utils.AiravataUtils;
import org.apache.airavata.common.utils.ServerSettings;
import org.apache.airavata.server.BetterTomcat;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.deploy.FilterDef;
import org.apache.catalina.deploy.FilterMap;
import org.apache.catalina.startup.Tomcat;

public class ServerMain {
    private Tomcat embedded = null;

    public void startTomcat() throws Exception {
        AiravataUtils.setExecutionAsServer();
        BetterTomcat tomcat = new BetterTomcat(Integer.parseInt(ServerSettings.getTomcatPort()));
        tomcat.addContext("/axis2", System.getenv("AIRAVATA_HOME"));
        Wrapper axis2Servlet = tomcat.addServlet("/axis2", "AxisServlet", "org.apache.axis2.transport.http.AxisServlet");
        axis2Servlet.addMapping("/servlet/AxisServlet");
        axis2Servlet.addMapping("*.jws");
        axis2Servlet.addMapping("/services/*");
        axis2Servlet.addInitParameter("axis2.repository.path", System.getenv("AIRAVATA_HOME") + File.separator + "repository");
        axis2Servlet.addInitParameter("axis2.xml.path", System.getenv("AIRAVATA_HOME") + File.separator + "bin" + File.separator + "axis2.xml");
        axis2Servlet.setLoadOnStartup(1);
        StandardContext context = (StandardContext)tomcat.getTomcat().addContext("/airavata-registry", System.getenv("AIRAVATA_HOME"));
        Wrapper registryServlet = tomcat.addServlet("/airavata-registry", "Airavata Web Application", "com.sun.jersey.spi.container.servlet.ServletContainer");
        registryServlet.addInitParameter("com.sun.jersey.config.property.packages", "org.apache.airavata.services.registry.rest;org.codehaus.jackson.jaxrs");
        registryServlet.setLoadOnStartup(1);
        FilterDef filter1definition = new FilterDef();
        filter1definition.setFilterName("AuthenticationFilter");
        filter1definition.setFilterClass("org.apache.airavata.services.registry.rest.security.HttpAuthenticatorFilter");
        filter1definition.addInitParameter("authenticatorConfigurations", "authenticators.xml");
        context.addFilterDef(filter1definition);
        FilterMap filter1mapping = new FilterMap();
        filter1mapping.setFilterName("AuthenticationFilter");
        filter1mapping.addURLPattern("/user-store/*");
        filter1mapping.addURLPattern("/api/*");
        context.addFilterMap(filter1mapping);
        registryServlet.addMapping("/api/*");
        context.addApplicationListener("org.apache.airavata.rest.mappings.utils.RegistryListener");
        tomcat.start();
    }

    public void stopTomcat() throws Exception {
        this.embedded.stop();
    }

    public static void main(String[] args) {
        try {
            new Thread(){

                @Override
                public void run() {
                    ServerMain tomcat = new ServerMain();
                    try {
                        tomcat.startTomcat();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }.start();
            while (true) {
                Thread.sleep(10000L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }
}

