/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.server;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.airavata.server.BetterTomcatException;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Realm;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.startup.Tomcat;
import org.apache.coyote.http11.AbstractHttp11JsseProtocol;
import org.apache.tomcat.util.IntrospectionUtils;

public class BetterTomcat {
    private Tomcat tomcat = new Tomcat();
    private static Map<String, Connector> connectors = new HashMap<String, Connector>();
    private boolean unpackWars = true;

    public BetterTomcat() {
        this.tomcat.setConnector(new Connector(Protocol.HTTP_11.getProtocolName()));
    }

    public BetterTomcat(int port) {
        this();
        this.addConnector(Protocol.HTTP_11, null, port);
    }

    public void setUnpackWars(boolean unpackWars) {
        this.unpackWars = unpackWars;
    }

    public void start() throws LifecycleException {
        this.tomcat.start();
    }

    public void stop() throws LifecycleException {
        this.tomcat.stop();
    }

    public Host getHost() {
        Host host = this.tomcat.getHost();
        ((StandardHost)host).setUnpackWARs(this.unpackWars);
        return host;
    }

    public Context addWebapp(String contextPath, String webappFilePath) throws BetterTomcatException {
        try {
            Context context = this.tomcat.addWebapp(contextPath, webappFilePath);
            if (context.getState().equals((Object)LifecycleState.STOPPED)) {
                throw new BetterTomcatException("Webapp " + context + " failed to deploy");
            }
            if (!this.unpackWars) {
                context.addParameter("antiJARLocking", "false");
                context.addParameter("antiResourceLocking", "false");
            }
            return context;
        }
        catch (ServletException e) {
            throw new BetterTomcatException("Webapp failed to deploy", e);
        }
    }

    public Context addWebapp(Host host, String contextPath, String webappFilePath) {
        return this.tomcat.addWebapp(host, contextPath, webappFilePath);
    }

    public Context addContext(String contextPath, String baseDir) {
        return this.tomcat.addContext(contextPath, baseDir);
    }

    public Context addContext(Host host, String contextPath, String dir) {
        return this.tomcat.addContext(host, contextPath, dir);
    }

    public Wrapper addServlet(String contextPath, String servletName, String servletClass) {
        return this.tomcat.addServlet(contextPath, servletName, servletClass);
    }

    public Wrapper addServlet(String contextPath, String servletName, Servlet servlet) {
        return this.tomcat.addServlet(contextPath, servletName, servlet);
    }

    public void enableNaming() {
        this.tomcat.enableNaming();
    }

    public Connector addConnector(int port) {
        return this.addConnector(Protocol.HTTP_11, null, port);
    }

    public Connector addConnector(Protocol protocol, String address, int port) {
        Connector connector = connectors.get((Object)((Object)protocol) + "-" + address + "-" + port);
        if (connector == null) {
            connector = new Connector(protocol.getProtocolClass());
            if (address != null) {
                IntrospectionUtils.setProperty((Object)connector, (String)"address", (String)address);
            }
            connector.setPort(port);
            connector.setEnableLookups(true);
            connector.setProperty("bindOnInit", "false");
            if (protocol.equals((Object)Protocol.HTTPS_11) || protocol.equals((Object)Protocol.HTTPS_11_NIO)) {
                connector.setSecure(true);
                connector.setAttribute("SSLEnabled", (Object)"true");
                connector.setScheme("https");
            }
            this.tomcat.getService().addConnector(connector);
        }
        return connector;
    }

    public void setClientAuth(Connector connector, String clientAuth) {
        ((AbstractHttp11JsseProtocol)connector.getProtocolHandler()).setClientAuth(clientAuth);
    }

    public Connector getConnector(Protocol protocol, String address, int port) {
        return this.addConnector(protocol, address, port);
    }

    public void setBaseDir(String baseDir) {
        this.tomcat.setBaseDir(baseDir);
    }

    public void setDefaultHost(String defaultHostName) {
        this.tomcat.setHostname(defaultHostName);
        this.tomcat.getEngine().setDefaultHost(defaultHostName);
    }

    public void setDefaultRealm(Realm realm) {
        this.tomcat.setDefaultRealm(realm);
    }

    public Tomcat getTomcat() {
        return this.tomcat;
    }

    public static enum Protocol {
        HTTP_11("HTTP/1.1", "HTTP/1.1"),
        HTTPS_11("HTTPS/1.1", "HTTP/1.1"),
        HTTP_11_NIO("HTTP/1.1/NIO", "org.apache.coyote.http11.Http11NioProtocol"),
        HTTPS_11_NIO("HTTPS/1.1/NIO", "org.apache.coyote.http11.Http11NioProtocol"),
        HTTP_11_APR("HTTP/1.1/APR", "org.apache.coyote.http11.Http11AprProtocol"),
        HTTPS_11_APR("HTTPS/1.1/APR", "org.apache.coyote.http11.Http11AprProtocol"),
        MEMORY("memory", "org.apache.coyote.memory.MemoryProtocolHandler"),
        AJP("ajp", "org.apache.coyote.ajp.AjpProtocol");

        private String protocolName;
        private String protocolClass;

        private Protocol(String protocolName, String protocolClass) {
            this.protocolName = protocolName;
            this.protocolClass = protocolClass;
        }

        public String getProtocolName() {
            return this.protocolName;
        }

        public String getProtocolClass() {
            return this.protocolClass;
        }
    }
}

