/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.server;

import java.io.File;
import org.apache.airavata.common.utils.AiravataUtils;
import org.apache.airavata.common.utils.ServerSettings;
import org.apache.airavata.server.BetterTomcat;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.deploy.FilterDef;
import org.apache.catalina.deploy.FilterMap;
import org.apache.catalina.startup.Tomcat;

public class ServerMain {
    private Tomcat embedded = null;

    public void startTomcat() throws Exception {
        AiravataUtils.setExecutionAsServer();
        String protocol = ServerSettings.isEnableHttps() ? "https" : "http";
        BetterTomcat tomcat = new BetterTomcat(Integer.parseInt(ServerSettings.getTomcatPort((String)protocol)));
        tomcat.addContext("/airavata-server", System.getenv("AIRAVATA_HOME"));
        Wrapper axis2Servlet = tomcat.addServlet("/airavata-server", "AxisServlet", "org.apache.axis2.transport.http.AxisServlet");
        axis2Servlet.addMapping("/servlet/AxisServlet");
        axis2Servlet.addMapping("*.jws");
        axis2Servlet.addMapping("/services/*");
        axis2Servlet.addInitParameter("axis2.repository.path", System.getenv("AIRAVATA_HOME") + File.separator + "repository");
        axis2Servlet.addInitParameter("axis2.xml.path", System.getenv("AIRAVATA_HOME") + File.separator + "bin" + File.separator + "axis2.xml");
        axis2Servlet.setLoadOnStartup(1);
        StandardContext context = (StandardContext)tomcat.getTomcat().addContext("/airavata", System.getenv("AIRAVATA_HOME"));
        Wrapper experimentServlet = tomcat.addServlet("/airavata", "Airavata Experiment Service", "com.sun.jersey.spi.container.servlet.ServletContainer");
        experimentServlet.addInitParameter("com.sun.jersey.config.property.packages", "org.apache.airavata.services.experiment;org.codehaus.jackson.jaxrs");
        experimentServlet.setLoadOnStartup(1);
        Wrapper configurationServlet = tomcat.addServlet("/airavata", "Airavata Server Configuration Service", "com.sun.jersey.spi.container.servlet.ServletContainer");
        configurationServlet.addInitParameter("com.sun.jersey.config.property.packages", "org.apache.airavata.services.server;org.codehaus.jackson.jaxrs");
        configurationServlet.setLoadOnStartup(1);
        Wrapper registryServlet = tomcat.addServlet("/airavata", "Airavata Registry Service", "com.sun.jersey.spi.container.servlet.ServletContainer");
        registryServlet.addInitParameter("com.sun.jersey.config.property.packages", "org.apache.airavata.services.registry.rest;org.codehaus.jackson.jaxrs");
        registryServlet.setLoadOnStartup(1);
        FilterDef corsFilter = new FilterDef();
        corsFilter.setFilterName("CORS Filter");
        corsFilter.setFilterClass("org.ebaysf.web.cors.CORSFilter");
        corsFilter.addInitParameter("cors.allowed.origins", "*");
        corsFilter.addInitParameter("cors.allowed.methods", "GET,POST,HEAD,PUT,OPTIONS");
        corsFilter.addInitParameter("cors.allowed.headers", "Origin,Accept,X-Requested-With,Content-Type,Access-Control-Request-Method,Access-Control-Request-Headers,Authorization");
        corsFilter.addInitParameter("cors.exposed.headers", "");
        corsFilter.addInitParameter("cors.preflight.maxage", "1800");
        corsFilter.addInitParameter("cors.support.credentials", "true");
        corsFilter.addInitParameter("cors.logging.enabled", "false");
        corsFilter.addInitParameter("cors.request.decorate", "true");
        context.addFilterDef(corsFilter);
        FilterDef filter1definition = new FilterDef();
        filter1definition.setFilterName("AuthenticationFilter");
        filter1definition.setFilterClass("org.apache.airavata.services.registry.rest.security.HttpAuthenticatorFilter");
        filter1definition.addInitParameter("authenticatorConfigurations", "authenticators.xml");
        context.addFilterDef(filter1definition);
        FilterMap corsFilterMapping = new FilterMap();
        corsFilterMapping.setFilterName("CORS Filter");
        corsFilterMapping.addURLPattern("/user-store/*");
        corsFilterMapping.addURLPattern("/services/registry/*");
        corsFilterMapping.addURLPattern("/services/server/*");
        corsFilterMapping.addURLPattern("/services/experiment/*");
        context.addFilterMap(corsFilterMapping);
        FilterMap filter1mapping = new FilterMap();
        filter1mapping.setFilterName("AuthenticationFilter");
        filter1mapping.addURLPattern("/user-store/*");
        filter1mapping.addURLPattern("/services/registry/*");
        filter1mapping.addURLPattern("/services/server/*");
        filter1mapping.addURLPattern("/services/experiment/*");
        context.addFilterMap(filter1mapping);
        registryServlet.addMapping("/services/registry/*");
        configurationServlet.addMapping("/services/server/*");
        experimentServlet.addMapping("/services/experiment/*");
        context.addApplicationListener("org.apache.airavata.rest.mappings.utils.RegistryListener");
        tomcat.start();
    }

    public void stopTomcat() throws Exception {
        this.embedded.stop();
    }

    public static void main(String[] args) {
        try {
            new Thread(){

                @Override
                public void run() {
                    ServerMain tomcat = new ServerMain();
                    try {
                        tomcat.startTomcat();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }.start();
            while (true) {
                Thread.sleep(10000L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }
}

