/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.common.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.airavata.common.exception.AiravataException;
import org.apache.airavata.common.utils.IOUtil;
import org.apache.xmlbeans.XmlError;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;
import org.xmlpull.infoset.XmlAttribute;
import org.xmlpull.infoset.XmlDocument;
import org.xmlpull.infoset.XmlInfosetBuilder;
import org.xmlpull.mxp1.MXParserFactory;
import org.xmlpull.mxp1_serializer.MXSerializer;
import org.xmlpull.v1.XmlPullParserFactory;
import org.xmlpull.v1.XmlSerializer;
import org.xmlpull.v1.builder.XmlElement;
import org.xmlpull.v1.builder.XmlNamespace;

public class XMLUtil {
    public static final XmlInfosetBuilder BUILDER = XmlInfosetBuilder.newInstance();
    public static final org.xmlpull.v1.builder.XmlInfosetBuilder BUILDER3 = org.xmlpull.v1.builder.XmlInfosetBuilder.newInstance((XmlPullParserFactory)new MXParserFactory());
    private static final Logger logger = LoggerFactory.getLogger(XMLUtil.class);
    private static final String PROPERTY_SERIALIZER_INDENTATION = "http://xmlpull.org/v1/doc/properties.html#serializer-indentation";
    private static final String INDENT = "    ";

    public static XmlElement stringToXmlElement3(String string) {
        return BUILDER3.parseFragmentFromReader((Reader)new StringReader(string));
    }

    public static org.xmlpull.infoset.XmlElement stringToXmlElement(String string) {
        XmlDocument document = BUILDER.parseString(string);
        org.xmlpull.infoset.XmlElement element = document.getDocumentElement();
        return element;
    }

    public static org.xmlpull.infoset.XmlElement xmlElement3ToXmlElement5(XmlElement element) {
        String string = XMLUtil.xmlElementToString(element);
        return XMLUtil.stringToXmlElement(string);
    }

    public static XmlElement xmlElement5ToXmlElement3(org.xmlpull.infoset.XmlElement element) {
        String string = XMLUtil.xmlElementToString(element);
        return XMLUtil.stringToXmlElement3(string);
    }

    public static String xmlElementToString(XmlElement element) {
        MXSerializer serializer = new MXSerializer();
        StringWriter writer = new StringWriter();
        serializer.setOutput((Writer)writer);
        serializer.setProperty(PROPERTY_SERIALIZER_INDENTATION, (Object)INDENT);
        BUILDER3.serialize((Object)element, (XmlSerializer)serializer);
        String xmlText = writer.toString();
        return xmlText;
    }

    public static String xmlElementToString(org.xmlpull.infoset.XmlElement element) {
        String string = element == null ? "" : BUILDER.serializeToStringPretty((Object)element);
        return string;
    }

    public static Element xppElementToDomElement(org.xmlpull.infoset.XmlElement xppElement, Document document) {
        Element domElement = document.createElement(xppElement.getName());
        for (org.xmlpull.infoset.XmlNamespace namespace : xppElement.namespaces()) {
            logger.debug("namespace: " + namespace);
        }
        for (XmlAttribute attribute : xppElement.attributes()) {
            domElement.setAttribute(attribute.getName(), attribute.getValue());
        }
        for (Object object : xppElement.children()) {
            if (object instanceof org.xmlpull.infoset.XmlElement) {
                domElement.appendChild(XMLUtil.xppElementToDomElement((org.xmlpull.infoset.XmlElement)object, document));
                continue;
            }
            if (object instanceof String) {
                Text text = document.createTextNode((String)object);
                domElement.appendChild(text);
                continue;
            }
            logger.debug("object.getClass(): " + object.getClass());
        }
        return domElement;
    }

    public static Element xppElementToDomElement(XmlElement xppElement, Document document) {
        Element domElement = document.createElement(xppElement.getName());
        Iterator nsIt = xppElement.namespaces();
        while (nsIt.hasNext()) {
            XmlNamespace namespace = (XmlNamespace)nsIt.next();
            logger.debug("namespace: " + namespace);
        }
        Iterator attrIt = xppElement.attributes();
        while (attrIt.hasNext()) {
            org.xmlpull.v1.builder.XmlAttribute attribute = (org.xmlpull.v1.builder.XmlAttribute)attrIt.next();
            domElement.setAttribute(attribute.getName(), attribute.getValue());
        }
        Iterator elementIt = xppElement.children();
        while (elementIt.hasNext()) {
            Object object = elementIt.next();
            if (object instanceof XmlElement) {
                domElement.appendChild(XMLUtil.xppElementToDomElement((XmlElement)object, document));
                continue;
            }
            if (object instanceof String) {
                Text text = document.createTextNode((String)object);
                domElement.appendChild(text);
                continue;
            }
            logger.debug("object.getClass(): " + object.getClass());
        }
        return domElement;
    }

    public static org.xmlpull.infoset.XmlElement deepClone(org.xmlpull.infoset.XmlElement element) throws AiravataException {
        try {
            org.xmlpull.infoset.XmlElement clonedElement = element.clone();
            clonedElement.setParent(null);
            return clonedElement;
        }
        catch (CloneNotSupportedException e) {
            throw new AiravataException(e.getMessage(), e);
        }
    }

    public static void saveXML(org.xmlpull.infoset.XmlElement element, File file) throws IOException {
        XmlDocument document = BUILDER.newDocument();
        document.setDocumentElement(element);
        String xmlText = BUILDER.serializeToStringPretty((Object)document);
        IOUtil.writeToFile(xmlText, file);
    }

    public static void saveXML(XmlElement element, File file) throws IOException {
        XMLUtil.saveXML(XMLUtil.xmlElement3ToXmlElement5(element), file);
    }

    public static org.xmlpull.infoset.XmlElement loadXML(InputStream stream) throws IOException {
        String xmlText = IOUtil.readToString(stream);
        XmlDocument document = BUILDER.parseString(xmlText);
        return document.getDocumentElement();
    }

    public static org.xmlpull.infoset.XmlElement loadXML(File file) throws IOException {
        return XMLUtil.loadXML(new FileInputStream(file));
    }

    public static boolean isXML(String string) {
        try {
            XMLUtil.stringToXmlElement(string);
            return true;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public static void validate(XmlObject xmlObject) throws AiravataException {
        XmlOptions validateOptions = new XmlOptions();
        ArrayList errorList = new ArrayList();
        validateOptions.setErrorListener(errorList);
        boolean isValid = xmlObject.validate(validateOptions);
        if (isValid) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < errorList.size(); ++i) {
            XmlError error = (XmlError)errorList.get(i);
            logger.warn("Message: " + error.getMessage());
            logger.warn("Location of invalid XML: " + error.getCursorLocation().xmlText());
            stringBuilder.append("Message:" + error.getMessage());
            stringBuilder.append("Location of invalid XML: " + error.getCursorLocation().xmlText());
        }
        throw new AiravataException(stringBuilder.toString());
    }

    public static String getLocalPartOfQName(String qname) {
        int index = qname.indexOf(58);
        if (index < 0) {
            return qname;
        }
        return qname.substring(index + 1);
    }

    public static String getPrefixOfQName(String qname) {
        int index = qname.indexOf(58);
        if (index < 0) {
            return null;
        }
        return qname.substring(0, index);
    }

    public static org.xmlpull.infoset.XmlNamespace declareNamespaceIfNecessary(String prefixCandidate, String uri, boolean alwaysUseSuffix, org.xmlpull.infoset.XmlElement element) {
        org.xmlpull.infoset.XmlNamespace namespace = element.lookupNamespaceByName(uri);
        if (namespace == null) {
            return XMLUtil.declareNamespace(prefixCandidate, uri, alwaysUseSuffix, element);
        }
        return namespace;
    }

    public static org.xmlpull.infoset.XmlNamespace declareNamespace(String prefixCandidate, String uri, boolean alwaysUseSuffix, org.xmlpull.infoset.XmlElement element) {
        if (prefixCandidate == null || prefixCandidate.length() == 0) {
            prefixCandidate = "a";
        }
        String prefix = prefixCandidate;
        if (alwaysUseSuffix) {
            prefix = prefix + "0";
        }
        if (element.lookupNamespaceByPrefix(prefix) != null) {
            int i = 1;
            prefix = prefixCandidate + i;
            while (element.lookupNamespaceByPrefix(prefix) != null) {
                ++i;
            }
        }
        org.xmlpull.infoset.XmlNamespace namespace = element.declareNamespace(prefix, uri);
        return namespace;
    }

    public static void removeElements(org.xmlpull.infoset.XmlElement xml, String name) {
        Iterable removeElements = xml.elements(null, name);
        LinkedList<org.xmlpull.infoset.XmlElement> removeList = new LinkedList<org.xmlpull.infoset.XmlElement>();
        for (org.xmlpull.infoset.XmlElement xmlElement : removeElements) {
            removeList.add(xmlElement);
        }
        for (org.xmlpull.infoset.XmlElement xmlElement : removeList) {
            xml.removeChild((Object)xmlElement);
        }
        Iterable children = xml.children();
        for (Object object : children) {
            if (!(object instanceof org.xmlpull.infoset.XmlElement)) continue;
            org.xmlpull.infoset.XmlElement element = (org.xmlpull.infoset.XmlElement)object;
            XMLUtil.removeElements(element, name);
        }
    }

    public static Document retrievalXMLDocFromUrl(String url) {
        try {
            URL xmlUrl = new URL(url);
            InputStream in = xmlUrl.openStream();
            Document ret = null;
            DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
            domFactory.setValidating(false);
            domFactory.setNamespaceAware(false);
            DocumentBuilder builder = domFactory.newDocumentBuilder();
            ret = builder.parse(in);
            return ret;
        }
        catch (MalformedURLException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (SAXException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public static Document retrievalXMLDocForParse(String url) {
        try {
            URL xmlUrl = new URL(url);
            InputStream in = xmlUrl.openStream();
            DocumentBuilderFactory xmlFact = DocumentBuilderFactory.newInstance();
            xmlFact.setNamespaceAware(true);
            DocumentBuilder builder = xmlFact.newDocumentBuilder();
            Document doc = builder.parse(in);
            return doc;
        }
        catch (MalformedURLException e) {
            logger.error("Malformed URL", (Throwable)e);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (SAXException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public static boolean isEqual(org.xmlpull.infoset.XmlElement elem1, org.xmlpull.infoset.XmlElement elem2) throws Exception {
        if (elem1 == null && elem2 == null) {
            return true;
        }
        if (elem1 == null) {
            return false;
        }
        if (elem2 == null) {
            return false;
        }
        if (!elem1.getName().equals(elem2.getName())) {
            return false;
        }
        Iterator children1 = elem1.children().iterator();
        Iterator children2 = elem2.children().iterator();
        Object child1 = null;
        Object child2 = null;
        if (children1.hasNext() && children2.hasNext()) {
            child1 = children1.next();
            child2 = children2.next();
            if (!children1.hasNext() && !children2.hasNext()) {
                return XMLUtil.compareObjs(child1, child2);
            }
            List<org.xmlpull.infoset.XmlElement> elemSet1 = XMLUtil.getXmlElementsOnly(elem1.children().iterator());
            List<org.xmlpull.infoset.XmlElement> elemSet2 = XMLUtil.getXmlElementsOnly(elem2.children().iterator());
            if (elemSet1.size() != elemSet2.size()) {
                return false;
            }
            for (int i = 0; i < elemSet1.size(); ++i) {
                if (XMLUtil.isEqual(elemSet1.get(i), elemSet2.get(i))) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    private static List<org.xmlpull.infoset.XmlElement> getXmlElementsOnly(Iterator itr) {
        LinkedList<org.xmlpull.infoset.XmlElement> list = new LinkedList<org.xmlpull.infoset.XmlElement>();
        while (itr.hasNext()) {
            Object obj = itr.next();
            if (!(obj instanceof org.xmlpull.infoset.XmlElement)) continue;
            list.add((org.xmlpull.infoset.XmlElement)obj);
        }
        return list;
    }

    private static boolean compareObjs(Object child1, Object child2) throws Exception {
        if (child1 instanceof String && child2 instanceof String) {
            return child1.equals(child2);
        }
        if (child1 instanceof org.xmlpull.infoset.XmlElement && child2 instanceof org.xmlpull.infoset.XmlElement) {
            return XMLUtil.isEqual((org.xmlpull.infoset.XmlElement)child1, (org.xmlpull.infoset.XmlElement)child2);
        }
        return false;
    }
}

