/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.common.utils;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.SecurityUtil;
import org.apache.airavata.common.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationSettings {
    public static final String SERVER_PROPERTIES = "airavata-server.properties";
    public static String ADDITIONAL_SETTINGS_FILES = "external.settings";
    protected Properties properties = new Properties();
    private Exception propertyLoadException;
    protected static final String TRUST_STORE_PATH = "trust.store";
    protected static final String TRUST_STORE_PASSWORD = "trust.store.password";
    private static final String REGULAR_EXPRESSION = "\\$\\{[a-zA-Z.-]*\\}";
    private static final Logger logger = LoggerFactory.getLogger(ApplicationSettings.class);
    private static final String SHUTDOWN_STATEGY_STRING = "shutdown.strategy";
    protected static ApplicationSettings INSTANCE;

    public ApplicationSettings() {
        this.loadProperties();
    }

    private void loadProperties() {
        URL url = this.getPropertyFileURL();
        try {
            URL[] externalSettingsFileURLs;
            this.properties.load(url.openStream());
            logger.info("Settings loaded from " + url.toString());
            for (URL externalSettings : externalSettingsFileURLs = this.getExternalSettingsFileURLs()) {
                this.mergeSettingsImpl(externalSettings.openStream());
                logger.info("External settings merged from " + url.toString());
            }
        }
        catch (Exception e) {
            this.propertyLoadException = e;
        }
    }

    protected URL getPropertyFileURL() {
        return ApplicationSettings.class.getClassLoader().getResource(SERVER_PROPERTIES);
    }

    protected URL[] getExternalSettingsFileURLs() {
        try {
            String[] externalSettingFiles;
            ArrayList<URL> externalSettingsFileURLs = new ArrayList<URL>();
            String externalSettingsFileNames = this.getSettingImpl(ADDITIONAL_SETTINGS_FILES);
            for (String externalSettingFile : externalSettingFiles = externalSettingsFileNames.split(",")) {
                URL externalSettingFileURL = ApplicationSettings.class.getClassLoader().getResource(externalSettingFile);
                if (externalSettingFileURL == null) {
                    logger.warn("Could not file external settings file " + externalSettingFile);
                    continue;
                }
                externalSettingsFileURLs.add(externalSettingFileURL);
            }
            return externalSettingsFileURLs.toArray(new URL[0]);
        }
        catch (ApplicationSettingsException e) {
            return new URL[0];
        }
    }

    protected static ApplicationSettings getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ApplicationSettings();
        }
        return INSTANCE;
    }

    protected static void setInstance(ApplicationSettings settingsInstance) {
        INSTANCE = settingsInstance;
    }

    private void saveProperties() throws ApplicationSettingsException {
        URL url = this.getPropertyFileURL();
        if (url.getProtocol().equalsIgnoreCase("file")) {
            try {
                this.properties.store(new FileOutputStream(url.getPath()), Calendar.getInstance().toString());
            }
            catch (Exception e) {
                throw new ApplicationSettingsException(url.getPath(), e);
            }
        } else {
            logger.warn("Properties cannot be updated to location " + url.toString());
        }
    }

    private void validateSuccessfulPropertyFileLoad() throws ApplicationSettingsException {
        if (this.propertyLoadException != null) {
            throw new ApplicationSettingsException(this.propertyLoadException.getMessage(), this.propertyLoadException);
        }
    }

    public String getAbsoluteSetting(String key) throws ApplicationSettingsException {
        String configurationValueWithVariables = ApplicationSettings.getSetting(key);
        List<String> variableList = ApplicationSettings.getAllMatches(configurationValueWithVariables, REGULAR_EXPRESSION);
        if (variableList == null || variableList.isEmpty()) {
            return configurationValueWithVariables;
        }
        for (String variableIdentifier : variableList) {
            String variableName = ApplicationSettings.getVariableNameOnly(variableIdentifier);
            String value = this.getAbsoluteSetting(variableName);
            configurationValueWithVariables = configurationValueWithVariables.replace(variableIdentifier, value);
        }
        return configurationValueWithVariables;
    }

    private static String getVariableNameOnly(String variableWithIdentifiers) {
        return variableWithIdentifiers.substring(2, variableWithIdentifiers.length() - 1);
    }

    private static List<String> getAllMatches(String text, String regex) {
        ArrayList<String> matches = new ArrayList<String>();
        Matcher m = Pattern.compile("(?=(" + regex + "))").matcher(text);
        while (m.find()) {
            matches.add(m.group(1));
        }
        return matches;
    }

    public String getSettingImpl(String key) throws ApplicationSettingsException {
        String rawValue = null;
        if (System.getProperties().containsKey(key)) {
            rawValue = System.getProperties().getProperty(key);
        } else {
            this.validateSuccessfulPropertyFileLoad();
            if (this.properties.containsKey(key)) {
                rawValue = this.properties.getProperty(key);
            } else {
                throw new ApplicationSettingsException(key);
            }
        }
        return this.deriveAbsoluteValueImpl(rawValue);
    }

    public String getSettingImpl(String key, String defaultValue) {
        try {
            return this.getSettingImpl(key);
        }
        catch (ApplicationSettingsException applicationSettingsException) {
            return defaultValue;
        }
    }

    private String deriveAbsoluteValueImpl(String property) {
        if (property != null) {
            Map<Integer, String> containedParameters = StringUtil.getContainedParameters(property);
            ArrayList<String> parametersAlreadyProcessed = new ArrayList<String>();
            for (String parameter : containedParameters.values()) {
                if (parametersAlreadyProcessed.contains(parameter)) continue;
                String parameterName = parameter.substring(2, parameter.length() - 1);
                String parameterValue = ApplicationSettings.getSetting(parameterName, parameter);
                property = property.replaceAll(Pattern.quote(parameter), parameterValue);
                parametersAlreadyProcessed.add(parameter);
            }
        }
        return property;
    }

    public void setSettingImpl(String key, String value) throws ApplicationSettingsException {
        this.properties.setProperty(key, value);
        this.saveProperties();
    }

    public boolean isSettingDefinedImpl(String key) throws ApplicationSettingsException {
        this.validateSuccessfulPropertyFileLoad();
        return this.properties.containsKey(key);
    }

    public String getTrustStorePathImpl() throws ApplicationSettingsException {
        return ApplicationSettings.getSetting(TRUST_STORE_PATH);
    }

    public String getTrustStorePasswordImpl() throws ApplicationSettingsException {
        return ApplicationSettings.getSetting(TRUST_STORE_PASSWORD);
    }

    public String getCredentialStoreKeyStorePathImpl() throws ApplicationSettingsException {
        return ApplicationSettings.getSetting("credential.store.keystore.url");
    }

    public String getCredentialStoreKeyAliasImpl() throws ApplicationSettingsException {
        return ApplicationSettings.getSetting("credential.store.keystore.alias");
    }

    public String getCredentialStoreKeyStorePasswordImpl() throws ApplicationSettingsException {
        return ApplicationSettings.getSetting("credential.store.keystore.password");
    }

    public String getCredentialStoreNotifierEnabledImpl() throws ApplicationSettingsException {
        return ApplicationSettings.getSetting("notifier.enabled");
    }

    public String getCredentialStoreNotifierDurationImpl() throws ApplicationSettingsException {
        return ApplicationSettings.getSetting("notifier.duration");
    }

    public String getCredentialStoreEmailServerImpl() throws ApplicationSettingsException {
        return ApplicationSettings.getSetting("email.server");
    }

    public String getCredentialStoreEmailServerPortImpl() throws ApplicationSettingsException {
        return ApplicationSettings.getSetting("email.server.port");
    }

    public String getCredentialStoreEmailUserImpl() throws ApplicationSettingsException {
        return ApplicationSettings.getSetting("email.user");
    }

    public String getCredentialStoreEmailPasswordImpl() throws ApplicationSettingsException {
        return ApplicationSettings.getSetting("email.password");
    }

    public String getCredentialStoreEmailSSLConnectImpl() throws ApplicationSettingsException {
        return ApplicationSettings.getSetting("email.ssl");
    }

    public String getCredentialStoreEmailFromEmailImpl() throws ApplicationSettingsException {
        return ApplicationSettings.getSetting("email.from");
    }

    public Properties getPropertiesImpl() {
        return this.properties;
    }

    public void mergeSettingsImpl(Map<String, String> props) {
        this.properties.putAll(props);
    }

    public void mergeSettingsImpl(InputStream stream) throws IOException {
        Properties tmpProp = new Properties();
        tmpProp.load(stream);
        this.properties.putAll((Map<?, ?>)tmpProp);
    }

    public void mergeSettingsCommandLineArgsImpl(String[] args) {
        this.properties.putAll(StringUtil.parseCommandLineOptions(args));
    }

    public ShutdownStrategy getShutdownStrategyImpl() throws Exception {
        String strategy = null;
        try {
            strategy = ApplicationSettings.getSetting(SHUTDOWN_STATEGY_STRING, ShutdownStrategy.SELF_TERMINATE.toString());
            return ShutdownStrategy.valueOf(strategy);
        }
        catch (Exception e) {
            throw new Exception("Invalid shutdown strategy configured : " + strategy);
        }
    }

    public static String getSetting(String key) throws ApplicationSettingsException {
        return ApplicationSettings.getInstance().getSettingImpl(key);
    }

    public static String getSetting(String key, String defaultValue) {
        return ApplicationSettings.getInstance().getSettingImpl(key, defaultValue);
    }

    public static void setSetting(String key, String value) throws ApplicationSettingsException {
        ApplicationSettings.getInstance().properties.setProperty(key, value);
        ApplicationSettings.getInstance().saveProperties();
    }

    public static boolean isSettingDefined(String key) throws ApplicationSettingsException {
        return ApplicationSettings.getInstance().properties.containsKey(key);
    }

    public static String getTrustStorePath() throws ApplicationSettingsException {
        return ApplicationSettings.getSetting(TRUST_STORE_PATH);
    }

    public static String getTrustStorePassword() throws ApplicationSettingsException {
        return ApplicationSettings.getSetting(TRUST_STORE_PASSWORD);
    }

    public static void initializeTrustStore() throws ApplicationSettingsException {
        SecurityUtil.setTrustStoreParameters(ApplicationSettings.getTrustStorePath(), ApplicationSettings.getTrustStorePassword());
    }

    public static String getCredentialStoreKeyStorePath() throws ApplicationSettingsException {
        return ApplicationSettings.getSetting("credential.store.keystore.url");
    }

    public static String getCredentialStoreKeyAlias() throws ApplicationSettingsException {
        return ApplicationSettings.getSetting("credential.store.keystore.alias");
    }

    public static String getCredentialStoreKeyStorePassword() throws ApplicationSettingsException {
        return ApplicationSettings.getSetting("credential.store.keystore.password");
    }

    public static String getCredentialStoreServerHost() throws ApplicationSettingsException {
        return ApplicationSettings.getSetting("credential.store.server.host");
    }

    public static String getCredentialStoreServerPort() throws ApplicationSettingsException {
        return ApplicationSettings.getSetting("credential.store.server.port");
    }

    public static String getCredentialStoreNotifierEnabled() throws ApplicationSettingsException {
        return ApplicationSettings.getSetting("notifier.enabled");
    }

    public static String getCredentialStoreNotifierDuration() throws ApplicationSettingsException {
        return ApplicationSettings.getSetting("notifier.duration");
    }

    public static String getCredentialStoreEmailServer() throws ApplicationSettingsException {
        return ApplicationSettings.getSetting("email.server");
    }

    public static String getCredentialStoreEmailServerPort() throws ApplicationSettingsException {
        return ApplicationSettings.getSetting("email.server.port");
    }

    public static String getCredentialStoreEmailUser() throws ApplicationSettingsException {
        return ApplicationSettings.getSetting("email.user");
    }

    public static String getCredentialStoreEmailPassword() throws ApplicationSettingsException {
        return ApplicationSettings.getSetting("email.password");
    }

    public static String getCredentialStoreEmailSSLConnect() throws ApplicationSettingsException {
        return ApplicationSettings.getSetting("email.ssl");
    }

    public static String getCredentialStoreEmailFromEmail() throws ApplicationSettingsException {
        return ApplicationSettings.getSetting("email.from");
    }

    public static Properties getProperties() throws ApplicationSettingsException {
        return ApplicationSettings.getInstance().properties;
    }

    public static void mergeSettings(Map<String, String> props) {
        ApplicationSettings.getInstance().mergeSettingsImpl(props);
    }

    public static void mergeSettings(InputStream stream) throws IOException {
        ApplicationSettings.getInstance().mergeSettingsImpl(stream);
    }

    public static void mergeSettingsCommandLineArgs(String[] args) {
        ApplicationSettings.getInstance().mergeSettingsCommandLineArgsImpl(args);
    }

    public static ShutdownStrategy getShutdownStrategy() throws Exception {
        return ApplicationSettings.getInstance().getShutdownStrategyImpl();
    }

    public static enum ShutdownStrategy {
        NONE,
        SELF_TERMINATE;

    }
}

