/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.common.utils;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.ByteBuffer;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.ServerSettings;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.WatchPathable;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.ServerConfig;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AiravataZKUtils
implements Watcher {
    private static final Logger logger = LoggerFactory.getLogger(AiravataZKUtils.class);
    public static final String ZK_EXPERIMENT_STATE_NODE = "state";
    public static final String DELIVERY_TAG_POSTFIX = "-deliveryTag";
    public static final String CANCEL_DELIVERY_TAG_POSTFIX = "-cancel-deliveryTag";

    public void process(WatchedEvent event) {
    }

    public static String getExpZnodePath(String experimentId) throws ApplicationSettingsException {
        return "/experiments" + File.separator + ServerSettings.getGFacServerName() + File.separator + experimentId;
    }

    public static String getExpZnodeHandlerPath(String experimentId, String className) throws ApplicationSettingsException {
        return "/experiments" + File.separator + ServerSettings.getGFacServerName() + File.separator + experimentId + File.separator + className;
    }

    public static String getZKhostPort() throws ApplicationSettingsException {
        return ServerSettings.getZookeeperConnection();
    }

    public static int getZKTimeout() throws ApplicationSettingsException {
        return ServerSettings.getZookeeperTimeout();
    }

    public static String getExpStatePath(String experimentId) throws ApplicationSettingsException {
        return AiravataZKUtils.getExpZnodePath(experimentId) + File.separator + ZK_EXPERIMENT_STATE_NODE;
    }

    public static String getExpState(CuratorFramework curatorClient, String expId) throws Exception {
        Stat exists = (Stat)curatorClient.checkExists().forPath(AiravataZKUtils.getExpStatePath(expId));
        if (exists != null) {
            return new String((byte[])((WatchPathable)curatorClient.getData().storingStatIn(exists)).forPath(AiravataZKUtils.getExpStatePath(expId)));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runZKFromConfig(ServerConfig config, ServerCnxnFactory cnxnFactory) throws IOException {
        logger.info("Starting Zookeeper server...");
        try (FileTxnSnapLog txnLog = null;){
            ZooKeeperServer zkServer = new ZooKeeperServer();
            txnLog = new FileTxnSnapLog(new File(config.getDataDir()), new File(config.getDataDir()));
            zkServer.setTxnLogFactory(txnLog);
            zkServer.setTickTime(config.getTickTime());
            zkServer.setMinSessionTimeout(config.getMinSessionTimeout());
            zkServer.setMaxSessionTimeout(config.getMaxSessionTimeout());
            cnxnFactory = ServerCnxnFactory.createFactory();
            cnxnFactory.configure(config.getClientPortAddress(), config.getMaxClientCnxns());
            cnxnFactory.startup(zkServer);
            cnxnFactory.join();
            if (zkServer.isRunning()) {
                zkServer.shutdown();
            }
        }
    }

    public static void startEmbeddedZK(ServerCnxnFactory cnxnFactory) {
        if (ServerSettings.isEmbeddedZK()) {
            ServerConfig serverConfig = new ServerConfig();
            URL resource = AiravataZKUtils.class.getClassLoader().getResource("zoo.cfg");
            if (resource == null) {
                logger.error("There is no zoo.cfg file in the classpath... Failed to start Zookeeper Server");
                System.exit(1);
            }
            try {
                serverConfig.parse(resource.getPath());
            }
            catch (QuorumPeerConfig.ConfigException e) {
                logger.error("Error while starting embedded Zookeeper", (Throwable)e);
                System.exit(2);
            }
            final ServerConfig fServerConfig = serverConfig;
            final ServerCnxnFactory fserverCnxnFactory = cnxnFactory;
            new Thread(){

                @Override
                public void run() {
                    try {
                        AiravataZKUtils.runZKFromConfig(fServerConfig, fserverCnxnFactory);
                    }
                    catch (IOException e) {
                        logger.error("Error while starting embedded Zookeeper", (Throwable)e);
                        System.exit(3);
                    }
                }
            }.start();
        } else {
            logger.info("Skipping Zookeeper embedded startup ...");
        }
    }

    public static byte[] toByteArray(double value) {
        byte[] bytes = new byte[8];
        ByteBuffer.wrap(bytes).putDouble(value);
        return bytes;
    }

    public static long getDeliveryTag(String experimentID, CuratorFramework curatorClient, String experimentNode, String pickedChild) throws Exception {
        String deliveryTagPath = experimentNode + File.separator + pickedChild + File.separator + experimentID + DELIVERY_TAG_POSTFIX;
        Stat exists = (Stat)curatorClient.checkExists().forPath(deliveryTagPath);
        if (exists == null) {
            logger.error("Cannot find delivery Tag in path:" + deliveryTagPath + " for this experiment");
            return -1L;
        }
        return AiravataZKUtils.bytesToLong((byte[])((WatchPathable)curatorClient.getData().storingStatIn(exists)).forPath(deliveryTagPath));
    }

    public static byte[] longToBytes(long x) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(x);
        return buffer.array();
    }

    public static long bytesToLong(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.put(bytes);
        buffer.flip();
        return buffer.getLong();
    }

    public static double toDouble(byte[] bytes) {
        return ByteBuffer.wrap(bytes).getDouble();
    }

    public static long getCancelDeliveryTagIfExist(String experimentId, CuratorFramework curatorClient, String experimentNode, String pickedChild) throws Exception {
        String cancelDeliveryTagPath = experimentNode + File.separator + pickedChild + File.separator + experimentId + CANCEL_DELIVERY_TAG_POSTFIX;
        Stat exists = (Stat)curatorClient.checkExists().forPath(cancelDeliveryTagPath);
        if (exists == null) {
            return -1L;
        }
        return AiravataZKUtils.bytesToLong((byte[])((WatchPathable)curatorClient.getData().storingStatIn(exists)).forPath(cancelDeliveryTagPath));
    }
}

