/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.ra;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.JMSException;
import javax.jms.ServerSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.resource.spi.UnavailableException;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.transaction.xa.XAResource;
import org.apache.activemq.ActiveMQQueueSession;
import org.apache.activemq.ActiveMQSession;
import org.apache.activemq.ActiveMQTopicSession;
import org.apache.activemq.command.MessageDispatch;
import org.apache.activemq.ra.ActiveMQEndpointWorker;
import org.apache.activemq.ra.LocalAndXATransaction;
import org.apache.activemq.ra.MessageActivationSpec;
import org.apache.activemq.ra.MessageEndpointProxy;
import org.apache.activemq.ra.ServerSessionImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServerSessionPoolImpl
implements ServerSessionPool {
    private static final Log LOG = LogFactory.getLog(ServerSessionPoolImpl.class);
    private final ActiveMQEndpointWorker activeMQAsfEndpointWorker;
    private final int maxSessions;
    private List<ServerSessionImpl> idleSessions = new CopyOnWriteArrayList<ServerSessionImpl>();
    private List<ServerSessionImpl> activeSessions = new CopyOnWriteArrayList<ServerSessionImpl>();
    private AtomicBoolean closing = new AtomicBoolean(false);

    public ServerSessionPoolImpl(ActiveMQEndpointWorker activeMQAsfEndpointWorker, int maxSessions) {
        this.activeMQAsfEndpointWorker = activeMQAsfEndpointWorker;
        this.maxSessions = maxSessions;
    }

    private ServerSessionImpl createServerSessionImpl() throws JMSException {
        MessageActivationSpec activationSpec = this.activeMQAsfEndpointWorker.endpointActivationKey.getActivationSpec();
        int acknowledge = this.activeMQAsfEndpointWorker.transacted ? 0 : activationSpec.getAcknowledgeModeForSession();
        ActiveMQSession session = (ActiveMQSession)this.activeMQAsfEndpointWorker.connection.createSession(this.activeMQAsfEndpointWorker.transacted, acknowledge);
        try {
            int batchSize = 0;
            if (activationSpec.getEnableBatchBooleanValue()) {
                batchSize = activationSpec.getMaxMessagesPerBatchIntValue();
            }
            if (activationSpec.isUseRAManagedTransactionEnabled()) {
                MessageEndpoint endpoint = this.createEndpoint(null);
                return new ServerSessionImpl(this, session, this.activeMQAsfEndpointWorker.workManager, endpoint, true, batchSize);
            }
            MessageEndpoint endpoint = this.createEndpoint(new LocalAndXATransaction(session.getTransactionContext()));
            return new ServerSessionImpl(this, session, this.activeMQAsfEndpointWorker.workManager, endpoint, false, batchSize);
        }
        catch (UnavailableException e) {
            LOG.debug((Object)"Could not create an endpoint.", (Throwable)e);
            session.close();
            return null;
        }
    }

    private MessageEndpoint createEndpoint(LocalAndXATransaction txResourceProxy) throws UnavailableException {
        MessageEndpoint endpoint = this.activeMQAsfEndpointWorker.endpointFactory.createEndpoint((XAResource)txResourceProxy);
        MessageEndpointProxy endpointProxy = new MessageEndpointProxy(endpoint);
        return endpointProxy;
    }

    public ServerSession getServerSession() throws JMSException {
        LOG.debug((Object)"ServerSession requested.");
        if (this.closing.get()) {
            throw new JMSException("Session Pool Shutting Down.");
        }
        if (this.idleSessions.size() > 0) {
            ServerSessionImpl ss = this.idleSessions.remove(this.idleSessions.size() - 1);
            this.activeSessions.add(ss);
            LOG.debug((Object)("Using idle session: " + ss));
            return ss;
        }
        if (this.activeSessions.size() >= this.maxSessions) {
            return this.getExistingServerSession();
        }
        ServerSessionImpl ss = this.createServerSessionImpl();
        if (ss == null) {
            if (this.idleSessions.size() == 0) {
                throw new JMSException("Endpoint factory did not allows to any endpoints.");
            }
            return this.getExistingServerSession();
        }
        this.activeSessions.add(ss);
        LOG.debug((Object)("Created a new session: " + ss));
        return ss;
    }

    private void dispatchToSession(MessageDispatch messageDispatch) throws JMSException {
        ServerSession serverSession = this.getServerSession();
        Session s = serverSession.getSession();
        ActiveMQSession session = null;
        if (s instanceof ActiveMQSession) {
            session = (ActiveMQSession)s;
        } else if (s instanceof ActiveMQQueueSession) {
            session = (ActiveMQSession)s;
        } else if (s instanceof ActiveMQTopicSession) {
            session = (ActiveMQSession)s;
        } else {
            this.activeMQAsfEndpointWorker.connection.onAsyncException((Throwable)new JMSException("Session pool provided an invalid session type: " + s.getClass()));
        }
        session.dispatch(messageDispatch);
        serverSession.start();
    }

    private ServerSession getExistingServerSession() {
        ServerSessionImpl ss = this.activeSessions.remove(0);
        this.activeSessions.add(ss);
        LOG.debug((Object)("Reusing an active session: " + ss));
        return ss;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnToPool(ServerSessionImpl ss) {
        LOG.debug((Object)("Session returned to pool: " + ss));
        this.activeSessions.remove(ss);
        this.idleSessions.add(ss);
        AtomicBoolean atomicBoolean = this.closing;
        synchronized (atomicBoolean) {
            this.closing.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromPool(ServerSessionImpl ss) {
        this.activeSessions.remove(ss);
        try {
            ActiveMQSession session = (ActiveMQSession)ss.getSession();
            List l = session.getUnconsumedMessages();
            Iterator i = l.iterator();
            while (i.hasNext()) {
                this.dispatchToSession((MessageDispatch)i.next());
            }
        }
        catch (Throwable t) {
            LOG.error((Object)"Error redispatching unconsumed messages from stale session", t);
        }
        ss.close();
        AtomicBoolean atomicBoolean = this.closing;
        synchronized (atomicBoolean) {
            this.closing.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        AtomicBoolean atomicBoolean = this.closing;
        synchronized (atomicBoolean) {
            this.closing.set(true);
            this.closeIdleSessions();
            while (this.activeSessions.size() > 0) {
                System.out.println("ACtive Sessions = " + this.activeSessions.size());
                try {
                    this.closing.wait(1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
                this.closeIdleSessions();
            }
        }
    }

    private void closeIdleSessions() {
        for (ServerSessionImpl ss : this.idleSessions) {
            ss.close();
        }
    }

    public boolean isClosing() {
        return this.closing.get();
    }

    public void setClosing(boolean closing) {
        this.closing.set(closing);
    }
}

