/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.ra;

import java.io.Serializable;
import java.net.URI;
import java.util.HashMap;
import javax.jms.JMSException;
import javax.jms.XAConnection;
import javax.jms.XASession;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.xa.XAResource;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.RedeliveryPolicy;
import org.apache.activemq.Service;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.ra.ActiveMQConnectionRequestInfo;
import org.apache.activemq.ra.ActiveMQEndpointActivationKey;
import org.apache.activemq.ra.ActiveMQEndpointWorker;
import org.apache.activemq.ra.MessageActivationSpec;
import org.apache.activemq.ra.MessageResourceAdapter;
import org.apache.activemq.util.ServiceSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ActiveMQResourceAdapter
implements MessageResourceAdapter,
Serializable {
    private static final long serialVersionUID = -5417363537865649130L;
    private static final Log LOG = LogFactory.getLog(ActiveMQResourceAdapter.class);
    private final HashMap<ActiveMQEndpointActivationKey, ActiveMQEndpointWorker> endpointWorkers = new HashMap();
    private final ActiveMQConnectionRequestInfo info = new ActiveMQConnectionRequestInfo();
    private BootstrapContext bootstrapContext;
    private String brokerXmlConfig;
    private BrokerService broker;
    private ActiveMQConnectionFactory connectionFactory;

    public void start(BootstrapContext bootstrapContext) throws ResourceAdapterInternalException {
        this.bootstrapContext = bootstrapContext;
        if (this.brokerXmlConfig != null && this.brokerXmlConfig.trim().length() > 0) {
            try {
                this.broker = BrokerFactory.createBroker((URI)new URI(this.brokerXmlConfig));
                this.broker.start();
            }
            catch (Throwable e) {
                throw new ResourceAdapterInternalException("Failed to startup an embedded broker: " + this.brokerXmlConfig + ", due to: " + e, e);
            }
        }
    }

    public ActiveMQConnection makeConnection() throws JMSException {
        if (this.connectionFactory != null) {
            return this.makeConnection(this.info, this.connectionFactory);
        }
        return this.makeConnection(this.info);
    }

    public ActiveMQConnection makeConnection(ActiveMQConnectionRequestInfo info) throws JMSException {
        ActiveMQConnectionFactory connectionFactory = this.createConnectionFactory(info);
        return this.makeConnection(info, connectionFactory);
    }

    public ActiveMQConnection makeConnection(ActiveMQConnectionRequestInfo info, ActiveMQConnectionFactory connectionFactory) throws JMSException {
        String userName = info.getUserName();
        String password = info.getPassword();
        ActiveMQConnection physicalConnection = (ActiveMQConnection)connectionFactory.createConnection(userName, password);
        String clientId = info.getClientid();
        if (clientId != null && clientId.length() > 0) {
            physicalConnection.setClientID(clientId);
        }
        return physicalConnection;
    }

    public ActiveMQConnection makeConnection(MessageActivationSpec activationSpec) throws JMSException {
        ActiveMQConnectionFactory connectionFactory = this.createConnectionFactory(this.info);
        String userName = this.defaultValue(activationSpec.getUserName(), this.info.getUserName());
        String password = this.defaultValue(activationSpec.getPassword(), this.info.getPassword());
        String clientId = activationSpec.getClientId();
        if (clientId != null) {
            connectionFactory.setClientID(clientId);
        } else if (activationSpec.isDurableSubscription()) {
            LOG.warn((Object)("No clientID specified for durable subscription: " + activationSpec));
        }
        ActiveMQConnection physicalConnection = (ActiveMQConnection)connectionFactory.createConnection(userName, password);
        RedeliveryPolicy redeliveryPolicy = activationSpec.redeliveryPolicy();
        if (redeliveryPolicy != null) {
            physicalConnection.setRedeliveryPolicy(redeliveryPolicy);
        }
        return physicalConnection;
    }

    private synchronized ActiveMQConnectionFactory createConnectionFactory(ActiveMQConnectionRequestInfo info) throws JMSException {
        ActiveMQConnectionFactory factory = this.connectionFactory;
        if (factory != null && info.isConnectionFactoryConfigured()) {
            factory = factory.copy();
        } else if (factory == null) {
            factory = new ActiveMQConnectionFactory();
        }
        info.configure(factory);
        return factory;
    }

    private String defaultValue(String value, String defaultValue) {
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public void stop() {
        while (this.endpointWorkers.size() > 0) {
            ActiveMQEndpointActivationKey key = this.endpointWorkers.keySet().iterator().next();
            this.endpointDeactivation(key.getMessageEndpointFactory(), key.getActivationSpec());
        }
        if (this.broker != null) {
            ServiceSupport.dispose((Service)this.broker);
            this.broker = null;
        }
        this.bootstrapContext = null;
    }

    public BootstrapContext getBootstrapContext() {
        return this.bootstrapContext;
    }

    public void endpointActivation(MessageEndpointFactory endpointFactory, ActivationSpec activationSpec) throws ResourceException {
        if (!this.equals(activationSpec.getResourceAdapter())) {
            throw new ResourceException("Activation spec not initialized with this ResourceAdapter instance (" + activationSpec.getResourceAdapter() + " != " + this + ")");
        }
        if (!(activationSpec instanceof MessageActivationSpec)) {
            throw new NotSupportedException("That type of ActicationSpec not supported: " + activationSpec.getClass());
        }
        ActiveMQEndpointActivationKey key = new ActiveMQEndpointActivationKey(endpointFactory, (MessageActivationSpec)activationSpec);
        if (this.endpointWorkers.containsKey(key)) {
            throw new IllegalStateException("Endpoint previously activated");
        }
        ActiveMQEndpointWorker worker = new ActiveMQEndpointWorker(this, key);
        this.endpointWorkers.put(key, worker);
        worker.start();
    }

    public void endpointDeactivation(MessageEndpointFactory endpointFactory, ActivationSpec activationSpec) {
        if (activationSpec instanceof MessageActivationSpec) {
            ActiveMQEndpointActivationKey key = new ActiveMQEndpointActivationKey(endpointFactory, (MessageActivationSpec)activationSpec);
            ActiveMQEndpointWorker worker = this.endpointWorkers.remove(key);
            if (worker == null) {
                return;
            }
            try {
                worker.stop();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public XAResource[] getXAResources(ActivationSpec[] activationSpecs) throws ResourceException {
        XAResource[] session2;
        ActiveMQConnection connection = null;
        try {
            connection = this.makeConnection();
            if (connection instanceof XAConnection) {
                XASession session2 = ((XAConnection)connection).createXASession();
                XAResource xaResource = session2.getXAResource();
                XAResource[] xAResourceArray = new XAResource[]{xaResource};
                return xAResourceArray;
            }
            session2 = new XAResource[]{};
        }
        catch (JMSException e) {
            throw new ResourceException((Throwable)e);
        }
        finally {
            try {
                connection.close();
            }
            catch (Throwable ignore) {}
        }
        return session2;
    }

    public String getClientid() {
        return this.emptyToNull(this.info.getClientid());
    }

    public String getPassword() {
        return this.emptyToNull(this.info.getPassword());
    }

    public String getServerUrl() {
        return this.info.getServerUrl();
    }

    public String getUserName() {
        return this.emptyToNull(this.info.getUserName());
    }

    public void setClientid(String clientid) {
        this.info.setClientid(clientid);
    }

    public void setPassword(String password) {
        this.info.setPassword(password);
    }

    public void setServerUrl(String url) {
        this.info.setServerUrl(url);
    }

    public void setUserName(String userid) {
        this.info.setUserName(userid);
    }

    public String getBrokerXmlConfig() {
        return this.brokerXmlConfig;
    }

    public void setBrokerXmlConfig(String brokerXmlConfig) {
        this.brokerXmlConfig = brokerXmlConfig;
    }

    public Integer getDurableTopicPrefetch() {
        return this.info.getDurableTopicPrefetch();
    }

    public Long getInitialRedeliveryDelay() {
        return this.info.getInitialRedeliveryDelay();
    }

    public Integer getInputStreamPrefetch() {
        return this.info.getInputStreamPrefetch();
    }

    public Integer getMaximumRedeliveries() {
        return this.info.getMaximumRedeliveries();
    }

    public Integer getQueueBrowserPrefetch() {
        return this.info.getQueueBrowserPrefetch();
    }

    public Integer getQueuePrefetch() {
        return this.info.getQueuePrefetch();
    }

    public Short getRedeliveryBackOffMultiplier() {
        return this.info.getRedeliveryBackOffMultiplier();
    }

    public Boolean getRedeliveryUseExponentialBackOff() {
        return this.info.getRedeliveryUseExponentialBackOff();
    }

    public Integer getTopicPrefetch() {
        return this.info.getTopicPrefetch();
    }

    public boolean isUseInboundSessionEnabled() {
        return this.info.isUseInboundSessionEnabled();
    }

    public void setAllPrefetchValues(Integer i) {
        this.info.setAllPrefetchValues(i);
    }

    public void setDurableTopicPrefetch(Integer durableTopicPrefetch) {
        this.info.setDurableTopicPrefetch(durableTopicPrefetch);
    }

    public void setInitialRedeliveryDelay(Long value) {
        this.info.setInitialRedeliveryDelay(value);
    }

    public void setInputStreamPrefetch(Integer inputStreamPrefetch) {
        this.info.setInputStreamPrefetch(inputStreamPrefetch);
    }

    public void setMaximumRedeliveries(Integer value) {
        this.info.setMaximumRedeliveries(value);
    }

    public void setQueueBrowserPrefetch(Integer queueBrowserPrefetch) {
        this.info.setQueueBrowserPrefetch(queueBrowserPrefetch);
    }

    public void setQueuePrefetch(Integer queuePrefetch) {
        this.info.setQueuePrefetch(queuePrefetch);
    }

    public void setRedeliveryBackOffMultiplier(Short value) {
        this.info.setRedeliveryBackOffMultiplier(value);
    }

    public void setRedeliveryUseExponentialBackOff(Boolean value) {
        this.info.setRedeliveryUseExponentialBackOff(value);
    }

    public void setTopicPrefetch(Integer topicPrefetch) {
        this.info.setTopicPrefetch(topicPrefetch);
    }

    public ActiveMQConnectionRequestInfo getInfo() {
        return this.info;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MessageResourceAdapter)) {
            return false;
        }
        MessageResourceAdapter activeMQResourceAdapter = (MessageResourceAdapter)o;
        if (!this.info.equals(activeMQResourceAdapter.getInfo())) {
            return false;
        }
        return !this.notEqual(this.brokerXmlConfig, activeMQResourceAdapter.getBrokerXmlConfig());
    }

    private boolean notEqual(Object o1, Object o2) {
        return o1 == null ^ o2 == null || o1 != null && !o1.equals(o2);
    }

    public int hashCode() {
        int result = this.info.hashCode();
        if (this.brokerXmlConfig != null) {
            result ^= this.brokerXmlConfig.hashCode();
        }
        return result;
    }

    private String emptyToNull(String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        return value;
    }

    public Boolean getUseInboundSession() {
        return this.info.getUseInboundSession();
    }

    public void setUseInboundSession(Boolean useInboundSession) {
        this.info.setUseInboundSession(useInboundSession);
    }

    public ActiveMQConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(ActiveMQConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }
}

