/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.ra;

import java.io.PrintWriter;
import java.util.Set;
import javax.jms.JMSException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterAssociation;
import javax.security.auth.Subject;
import org.apache.activemq.ra.ActiveMQConnectionFactory;
import org.apache.activemq.ra.ActiveMQConnectionRequestInfo;
import org.apache.activemq.ra.ActiveMQManagedConnection;
import org.apache.activemq.ra.MessageResourceAdapter;
import org.apache.activemq.ra.SimpleConnectionManager;

public class ActiveMQManagedConnectionFactory
implements ManagedConnectionFactory,
ResourceAdapterAssociation {
    private static final long serialVersionUID = 6196921962230582875L;
    private MessageResourceAdapter adapter;
    private PrintWriter logWriter;
    private ActiveMQConnectionRequestInfo info = new ActiveMQConnectionRequestInfo();

    public void setResourceAdapter(ResourceAdapter adapter) throws ResourceException {
        if (!(adapter instanceof MessageResourceAdapter)) {
            throw new ResourceException("ResourceAdapter is not of type: " + MessageResourceAdapter.class.getName());
        }
        this.adapter = (MessageResourceAdapter)adapter;
        ActiveMQConnectionRequestInfo baseInfo = this.adapter.getInfo().copy();
        if (this.info.getClientid() == null) {
            this.info.setClientid(baseInfo.getClientid());
        }
        if (this.info.getPassword() == null) {
            this.info.setPassword(baseInfo.getPassword());
        }
        if (this.info.getServerUrl() == null) {
            this.info.setServerUrl(baseInfo.getServerUrl());
        }
        if (this.info.getUseInboundSession() == null) {
            this.info.setUseInboundSession(baseInfo.getUseInboundSession());
        }
        if (this.info.getUserName() == null) {
            this.info.setUserName(baseInfo.getUserName());
        }
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != ActiveMQManagedConnectionFactory.class) {
            return false;
        }
        return ((ActiveMQManagedConnectionFactory)object).info.equals(this.info);
    }

    public int hashCode() {
        return this.info.hashCode();
    }

    public ResourceAdapter getResourceAdapter() {
        return this.adapter;
    }

    public Object createConnectionFactory(ConnectionManager manager) throws ResourceException {
        return new ActiveMQConnectionFactory(this, manager, this.info);
    }

    public Object createConnectionFactory() throws ResourceException {
        return new ActiveMQConnectionFactory(this, new SimpleConnectionManager(), this.info);
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo info) throws ResourceException {
        try {
            if (info == null) {
                info = this.info;
            }
            ActiveMQConnectionRequestInfo amqInfo = (ActiveMQConnectionRequestInfo)info;
            return new ActiveMQManagedConnection(subject, this.adapter.makeConnection(amqInfo), amqInfo);
        }
        catch (JMSException e) {
            throw new ResourceException("Could not create connection.", (Throwable)e);
        }
    }

    public ManagedConnection matchManagedConnections(Set connections, Subject subject, ConnectionRequestInfo info) throws ResourceException {
        for (ActiveMQManagedConnection c : connections) {
            if (!c.matches(subject, info)) continue;
            try {
                c.associate(subject, (ActiveMQConnectionRequestInfo)info);
                return c;
            }
            catch (JMSException e) {
                throw new ResourceException((Throwable)e);
            }
        }
        return null;
    }

    public void setLogWriter(PrintWriter logWriter) throws ResourceException {
        this.logWriter = logWriter;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.logWriter;
    }

    public String getClientid() {
        return this.info.getClientid();
    }

    public String getPassword() {
        return this.info.getPassword();
    }

    public String getUserName() {
        return this.info.getUserName();
    }

    public void setClientid(String clientid) {
        this.info.setClientid(clientid);
    }

    public void setPassword(String password) {
        this.info.setPassword(password);
    }

    public void setUserName(String userid) {
        this.info.setUserName(userid);
    }

    public Boolean getUseInboundSession() {
        return this.info.getUseInboundSession();
    }

    public void setUseInboundSession(Boolean useInboundSession) {
        this.info.setUseInboundSession(useInboundSession);
    }

    public boolean isUseInboundSessionEnabled() {
        return this.info.isUseInboundSessionEnabled();
    }

    public Long getInitialRedeliveryDelay() {
        return this.info.getInitialRedeliveryDelay();
    }

    public Integer getMaximumRedeliveries() {
        return this.info.getMaximumRedeliveries();
    }

    public Short getRedeliveryBackOffMultiplier() {
        return this.info.getRedeliveryBackOffMultiplier();
    }

    public Boolean getRedeliveryUseExponentialBackOff() {
        return this.info.getRedeliveryUseExponentialBackOff();
    }

    public void setInitialRedeliveryDelay(Long value) {
        this.info.setInitialRedeliveryDelay(value);
    }

    public void setMaximumRedeliveries(Integer value) {
        this.info.setMaximumRedeliveries(value);
    }

    public void setRedeliveryBackOffMultiplier(Short value) {
        this.info.setRedeliveryBackOffMultiplier(value);
    }

    public void setRedeliveryUseExponentialBackOff(Boolean value) {
        this.info.setRedeliveryUseExponentialBackOff(value);
    }

    public Integer getDurableTopicPrefetch() {
        return this.info.getDurableTopicPrefetch();
    }

    public Integer getInputStreamPrefetch() {
        return this.info.getInputStreamPrefetch();
    }

    public Integer getQueueBrowserPrefetch() {
        return this.info.getQueueBrowserPrefetch();
    }

    public Integer getQueuePrefetch() {
        return this.info.getQueuePrefetch();
    }

    public Integer getTopicPrefetch() {
        return this.info.getTopicPrefetch();
    }

    public void setAllPrefetchValues(Integer i) {
        this.info.setAllPrefetchValues(i);
    }

    public void setDurableTopicPrefetch(Integer durableTopicPrefetch) {
        this.info.setDurableTopicPrefetch(durableTopicPrefetch);
    }

    public void setInputStreamPrefetch(Integer inputStreamPrefetch) {
        this.info.setInputStreamPrefetch(inputStreamPrefetch);
    }

    public void setQueueBrowserPrefetch(Integer queueBrowserPrefetch) {
        this.info.setQueueBrowserPrefetch(queueBrowserPrefetch);
    }

    public void setQueuePrefetch(Integer queuePrefetch) {
        this.info.setQueuePrefetch(queuePrefetch);
    }

    public void setTopicPrefetch(Integer topicPrefetch) {
        this.info.setTopicPrefetch(topicPrefetch);
    }
}

