/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.mqtt;

import java.io.IOException;
import org.apache.activemq.transport.tcp.TcpTransport;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtbuf.DataByteArrayInputStream;
import org.fusesource.mqtt.codec.MQTTFrame;

public class MQTTCodec {
    private final MQTTFrameSink frameSink;
    private byte header;
    private int contentLength = -1;
    private FrameParser currentParser;
    private final Buffer scratch = new Buffer(8192);
    private Buffer currentBuffer;
    private final FrameParser headerParser = new FrameParser(){

        @Override
        public void parse(DataByteArrayInputStream data, int readSize) throws IOException {
            while (readSize-- > 0) {
                byte b = data.readByte();
                if (b == 0) continue;
                MQTTCodec.this.header = b;
                MQTTCodec.this.currentParser = MQTTCodec.this.initializeVariableLengthParser();
                if (readSize > 0) {
                    MQTTCodec.this.currentParser.parse(data, readSize);
                }
                return;
            }
        }

        @Override
        public void reset() throws IOException {
            MQTTCodec.this.header = (byte)-1;
            MQTTCodec.this.contentLength = -1;
        }
    };
    private final FrameParser variableLengthParser = new FrameParser(){
        private byte digit;
        private int multiplier = 1;
        private int length;

        @Override
        public void parse(DataByteArrayInputStream data, int readSize) throws IOException {
            int i = 0;
            while (i++ < readSize) {
                this.digit = data.readByte();
                this.length += (this.digit & 0x7F) * this.multiplier;
                this.multiplier <<= 7;
                if ((this.digit & 0x80) != 0) continue;
                if (this.length == 0) {
                    MQTTCodec.this.processCommand();
                    MQTTCodec.this.currentParser = MQTTCodec.this.initializeHeaderParser();
                } else {
                    MQTTCodec.this.currentParser = MQTTCodec.this.initializeContentParser();
                    MQTTCodec.this.contentLength = this.length;
                }
                if ((readSize -= i) > 0) {
                    MQTTCodec.this.currentParser.parse(data, readSize);
                }
                return;
            }
        }

        @Override
        public void reset() throws IOException {
            this.digit = 0;
            this.multiplier = 1;
            this.length = 0;
        }
    };
    private final FrameParser contentParser = new FrameParser(){
        private int payLoadRead = 0;

        @Override
        public void parse(DataByteArrayInputStream data, int readSize) throws IOException {
            if (MQTTCodec.this.currentBuffer == null) {
                if (MQTTCodec.this.contentLength < MQTTCodec.this.scratch.length()) {
                    MQTTCodec.this.currentBuffer = MQTTCodec.this.scratch;
                    ((MQTTCodec)MQTTCodec.this).currentBuffer.length = MQTTCodec.this.contentLength;
                } else {
                    MQTTCodec.this.currentBuffer = new Buffer(MQTTCodec.this.contentLength);
                }
            }
            int length = Math.min(readSize, MQTTCodec.this.contentLength - this.payLoadRead);
            this.payLoadRead += data.read(((MQTTCodec)MQTTCodec.this).currentBuffer.data, this.payLoadRead, length);
            if (this.payLoadRead == MQTTCodec.this.contentLength) {
                MQTTCodec.this.processCommand();
                MQTTCodec.this.currentParser = MQTTCodec.this.initializeHeaderParser();
                if ((readSize -= length) > 0) {
                    MQTTCodec.this.currentParser.parse(data, readSize);
                }
            }
        }

        @Override
        public void reset() throws IOException {
            MQTTCodec.this.contentLength = -1;
            this.payLoadRead = 0;
            MQTTCodec.this.scratch.reset();
            MQTTCodec.this.currentBuffer = null;
        }
    };

    public MQTTCodec(MQTTFrameSink sink) {
        this.frameSink = sink;
    }

    public MQTTCodec(final TcpTransport transport) {
        this.frameSink = new MQTTFrameSink(){

            @Override
            public void onFrame(MQTTFrame mqttFrame) {
                transport.doConsume((Object)mqttFrame);
            }
        };
    }

    public void parse(DataByteArrayInputStream input, int readSize) throws Exception {
        if (this.currentParser == null) {
            this.currentParser = this.initializeHeaderParser();
        }
        this.currentParser.parse(input, readSize);
    }

    private void processCommand() throws IOException {
        Buffer frameContents = null;
        if (this.currentBuffer == this.scratch) {
            frameContents = this.scratch.deepCopy();
        } else {
            frameContents = this.currentBuffer;
            this.currentBuffer = null;
        }
        MQTTFrame frame = new MQTTFrame(frameContents).header(this.header);
        this.frameSink.onFrame(frame);
    }

    private FrameParser initializeHeaderParser() throws IOException {
        this.headerParser.reset();
        return this.headerParser;
    }

    private FrameParser initializeVariableLengthParser() throws IOException {
        this.variableLengthParser.reset();
        return this.variableLengthParser;
    }

    private FrameParser initializeContentParser() throws IOException {
        this.contentParser.reset();
        return this.contentParser;
    }

    private static interface FrameParser {
        public void parse(DataByteArrayInputStream var1, int var2) throws IOException;

        public void reset() throws IOException;
    }

    public static interface MQTTFrameSink {
        public void onFrame(MQTTFrame var1);
    }
}

