/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.amqp.message;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.MapMessage;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import org.apache.activemq.transport.amqp.AmqpProtocolException;
import org.apache.activemq.transport.amqp.message.AMQPNativeInboundTransformer;
import org.apache.activemq.transport.amqp.message.ActiveMQJMSVendor;
import org.apache.activemq.transport.amqp.message.AmqpMessageSupport;
import org.apache.activemq.transport.amqp.message.EncodedMessage;
import org.apache.activemq.transport.amqp.message.InboundTransformer;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.messaging.AmqpSequence;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.message.Message;

public class JMSMappingInboundTransformer
extends InboundTransformer {
    public JMSMappingInboundTransformer(ActiveMQJMSVendor vendor) {
        super(vendor);
    }

    @Override
    public String getTransformerName() {
        return "jms";
    }

    @Override
    public InboundTransformer getFallbackTransformer() {
        return new AMQPNativeInboundTransformer(this.getVendor());
    }

    @Override
    protected javax.jms.Message doTransform(EncodedMessage amqpMessage) throws Exception {
        Message amqp = amqpMessage.decode();
        javax.jms.Message result = this.createMessage(amqp, amqpMessage);
        result.setJMSDeliveryMode(this.defaultDeliveryMode);
        result.setJMSPriority(this.defaultPriority);
        result.setJMSExpiration(this.defaultTtl);
        this.populateMessage(result, amqp);
        result.setLongProperty(this.prefixVendor + "MESSAGE_FORMAT", amqpMessage.getMessageFormat());
        result.setBooleanProperty(this.prefixVendor + "NATIVE", false);
        return result;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private javax.jms.Message createMessage(Message message, EncodedMessage original) throws Exception {
        void var4_24;
        Section body = message.getBody();
        if (body == null) {
            void var4_8;
            if (AmqpMessageSupport.isContentType("application/x-java-serialized-object", message)) {
                ObjectMessage objectMessage = this.vendor.createObjectMessage();
            } else if (AmqpMessageSupport.isContentType("application/octet-stream", message) || AmqpMessageSupport.isContentType(null, message)) {
                BytesMessage bytesMessage = this.vendor.createBytesMessage();
            } else {
                Charset charset = AmqpMessageSupport.getCharsetForTextualContent(message.getContentType());
                if (charset != null) {
                    TextMessage textMessage = this.vendor.createTextMessage();
                } else {
                    javax.jms.Message message2 = this.vendor.createMessage();
                }
            }
            var4_8.setShortProperty("JMS_AMQP_ORIGINAL_ENCODING", (short)1);
            return var4_24;
        } else if (body instanceof Data) {
            void var4_15;
            Binary payload = ((Data)body).getValue();
            if (AmqpMessageSupport.isContentType("application/x-java-serialized-object", message)) {
                ObjectMessage objectMessage = this.vendor.createObjectMessage(payload.getArray(), payload.getArrayOffset(), payload.getLength());
            } else if (AmqpMessageSupport.isContentType("application/octet-stream", message)) {
                BytesMessage bytesMessage = this.vendor.createBytesMessage(payload.getArray(), payload.getArrayOffset(), payload.getLength());
            } else {
                Charset charset = AmqpMessageSupport.getCharsetForTextualContent(message.getContentType());
                if (StandardCharsets.UTF_8.equals(charset)) {
                    ByteBuffer buf = ByteBuffer.wrap(payload.getArray(), payload.getArrayOffset(), payload.getLength());
                    try {
                        CharBuffer chars = charset.newDecoder().decode(buf);
                        TextMessage textMessage = this.vendor.createTextMessage(String.valueOf(chars));
                    }
                    catch (CharacterCodingException e) {
                        BytesMessage bytesMessage = this.vendor.createBytesMessage(payload.getArray(), payload.getArrayOffset(), payload.getLength());
                    }
                } else {
                    BytesMessage bytesMessage = this.vendor.createBytesMessage(payload.getArray(), payload.getArrayOffset(), payload.getLength());
                }
            }
            var4_15.setShortProperty("JMS_AMQP_ORIGINAL_ENCODING", (short)2);
            return var4_24;
        } else if (body instanceof AmqpSequence) {
            AmqpSequence sequence = (AmqpSequence)body;
            StreamMessage m = this.vendor.createStreamMessage();
            for (Object item : sequence.getValue()) {
                m.writeObject(item);
            }
            StreamMessage streamMessage = m;
            streamMessage.setShortProperty("JMS_AMQP_ORIGINAL_ENCODING", (short)3);
            return var4_24;
        } else {
            if (!(body instanceof AmqpValue)) throw new RuntimeException("Unexpected body type: " + body.getClass());
            Object value = ((AmqpValue)body).getValue();
            if (value == null || value instanceof String) {
                TextMessage textMessage = this.vendor.createTextMessage((String)value);
                textMessage.setShortProperty("JMS_AMQP_ORIGINAL_ENCODING", value == null ? (short)4 : 5);
                return var4_24;
            } else if (value instanceof Binary) {
                void var4_20;
                Binary payload = (Binary)value;
                if (AmqpMessageSupport.isContentType("application/x-java-serialized-object", message)) {
                    ObjectMessage objectMessage = this.vendor.createObjectMessage(payload.getArray(), payload.getArrayOffset(), payload.getLength());
                } else {
                    BytesMessage bytesMessage = this.vendor.createBytesMessage(payload.getArray(), payload.getArrayOffset(), payload.getLength());
                }
                var4_20.setShortProperty("JMS_AMQP_ORIGINAL_ENCODING", (short)6);
                return var4_24;
            } else if (value instanceof List) {
                StreamMessage m = this.vendor.createStreamMessage();
                for (Object item : (List)value) {
                    m.writeObject(item);
                }
                StreamMessage streamMessage = m;
                streamMessage.setShortProperty("JMS_AMQP_ORIGINAL_ENCODING", (short)8);
                return var4_24;
            } else {
                if (!(value instanceof Map)) throw new AmqpProtocolException("Unable to encode to ActiveMQ JMS Message", false);
                MapMessage mapMessage = this.vendor.createMapMessage((Map)value);
                mapMessage.setShortProperty("JMS_AMQP_ORIGINAL_ENCODING", (short)7);
            }
        }
        return var4_24;
    }
}

