/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.amqp.message;

import javax.jms.BytesMessage;
import javax.jms.Message;
import org.apache.activemq.transport.amqp.message.ActiveMQJMSVendor;
import org.apache.activemq.transport.amqp.message.EncodedMessage;
import org.apache.activemq.transport.amqp.message.InboundTransformer;

public class AMQPRawInboundTransformer
extends InboundTransformer {
    public AMQPRawInboundTransformer(ActiveMQJMSVendor vendor) {
        super(vendor);
    }

    @Override
    public String getTransformerName() {
        return "raw";
    }

    @Override
    public InboundTransformer getFallbackTransformer() {
        return null;
    }

    @Override
    protected Message doTransform(EncodedMessage amqpMessage) throws Exception {
        BytesMessage result = this.vendor.createBytesMessage(amqpMessage.getArray(), amqpMessage.getArrayOffset(), amqpMessage.getLength());
        result.setJMSDeliveryMode(2);
        result.setJMSPriority(this.defaultPriority);
        long now = System.currentTimeMillis();
        result.setJMSTimestamp(now);
        if (this.defaultTtl > 0L) {
            result.setJMSExpiration(now + this.defaultTtl);
        }
        result.setLongProperty(this.prefixVendor + "MESSAGE_FORMAT", amqpMessage.getMessageFormat());
        result.setBooleanProperty(this.prefixVendor + "NATIVE", true);
        return result;
    }
}

