/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activeio.packet;

import java.util.Arrays;
import junit.framework.TestCase;
import org.apache.activeio.packet.Packet;

public abstract class PacketTestSupport
extends TestCase {
    abstract Packet createTestPacket(int var1);

    public void testInit() {
        Packet packet = this.createTestPacket(100);
        PacketTestSupport.assertEquals((int)100, (int)packet.capacity());
        PacketTestSupport.assertEquals((int)0, (int)packet.position());
        PacketTestSupport.assertEquals((int)100, (int)packet.limit());
        PacketTestSupport.assertEquals((int)100, (int)packet.remaining());
        PacketTestSupport.assertTrue((boolean)packet.hasRemaining());
    }

    public void testPosition() {
        Packet packet = this.createTestPacket(100);
        packet.position(10);
        PacketTestSupport.assertEquals((int)10, (int)packet.position());
    }

    public void testLimit() {
        Packet packet = this.createTestPacket(100);
        packet.limit(10);
        PacketTestSupport.assertEquals((int)10, (int)packet.limit());
    }

    public void testRemaining() {
        Packet packet = this.createTestPacket(100);
        packet.position(5);
        packet.limit(95);
        PacketTestSupport.assertEquals((int)90, (int)packet.remaining());
        PacketTestSupport.assertTrue((boolean)packet.hasRemaining());
        packet.position(5);
        packet.limit(5);
        PacketTestSupport.assertEquals((int)0, (int)packet.remaining());
        PacketTestSupport.assertFalse((boolean)packet.hasRemaining());
    }

    public void testFlip() {
        Packet packet = this.createTestPacket(100);
        packet.position(95);
        packet.flip();
        PacketTestSupport.assertEquals((int)0, (int)packet.position());
        PacketTestSupport.assertEquals((int)95, (int)packet.limit());
    }

    public void testClear() {
        Packet packet = this.createTestPacket(100);
        packet.position(5);
        packet.limit(95);
        packet.clear();
        PacketTestSupport.assertEquals((int)0, (int)packet.position());
        PacketTestSupport.assertEquals((int)100, (int)packet.limit());
    }

    public void testDuplicate() {
        Packet packet = this.createTestPacket(100);
        packet.position(5);
        packet.limit(95);
        Packet packet2 = packet.duplicate();
        packet2.position(10);
        packet2.limit(20);
        PacketTestSupport.assertEquals((int)5, (int)packet.position());
        PacketTestSupport.assertEquals((int)95, (int)packet.limit());
        PacketTestSupport.assertEquals((int)10, (int)packet2.position());
        PacketTestSupport.assertEquals((int)20, (int)packet2.limit());
    }

    public void testRewind() {
        Packet packet = this.createTestPacket(100);
        packet.position(5);
        packet.limit(95);
        packet.rewind();
        PacketTestSupport.assertEquals((int)0, (int)packet.position());
        PacketTestSupport.assertEquals((int)95, (int)packet.limit());
    }

    public void testSlice() {
        Packet packet = this.createTestPacket(100);
        packet.position(5);
        packet.limit(95);
        Packet packet2 = packet.slice();
        PacketTestSupport.assertEquals((int)0, (int)packet2.position());
        PacketTestSupport.assertEquals((int)90, (int)packet2.capacity());
        PacketTestSupport.assertEquals((int)90, (int)packet2.limit());
    }

    public void testWriteAndReadByte() {
        int i;
        Packet packet = this.createTestPacket(256);
        for (i = 0; i < 256; ++i) {
            PacketTestSupport.assertTrue((boolean)packet.write(i));
        }
        PacketTestSupport.assertFalse((boolean)packet.write(0));
        packet.flip();
        for (i = 0; i < 256; ++i) {
            PacketTestSupport.assertEquals((int)i, (int)packet.read());
        }
        PacketTestSupport.assertEquals((int)-1, (int)packet.read());
    }

    public void testWriteAndReadBulkByte() {
        byte[] data = new byte[10];
        Packet packet = this.createTestPacket(data.length * 10);
        for (int i = 0; i < 10; ++i) {
            Arrays.fill(data, (byte)i);
            PacketTestSupport.assertEquals((int)data.length, (int)packet.write(data, 0, data.length));
        }
        PacketTestSupport.assertEquals((int)-1, (int)packet.write(data, 0, data.length));
        byte[] buffer = new byte[data.length];
        packet.flip();
        for (int i = 0; i < 10; ++i) {
            PacketTestSupport.assertEquals((int)buffer.length, (int)packet.read(buffer, 0, buffer.length));
            Arrays.fill(data, (byte)i);
            this.assertEquals(buffer, data);
        }
        PacketTestSupport.assertEquals((int)-1, (int)packet.read(buffer, 0, buffer.length));
    }

    public void assertEquals(byte[] buffer, byte[] data) {
        PacketTestSupport.assertEquals((int)buffer.length, (int)data.length);
        for (int i = 0; i < data.length; ++i) {
            PacketTestSupport.assertEquals((byte)buffer[i], (byte)data[i]);
        }
    }
}

