/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activeio.journal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.activeio.journal.InvalidRecordLocationException;
import org.apache.activeio.journal.Journal;
import org.apache.activeio.journal.JournalEventListener;
import org.apache.activeio.journal.JournalStatsFilter;
import org.apache.activeio.journal.RecordLocation;
import org.apache.activeio.packet.ByteArrayPacket;
import org.apache.activeio.packet.Packet;

public abstract class JournalRWPerfToolSupport
implements JournalEventListener {
    private JournalStatsFilter journal;
    private Random random = new Random();
    private byte[] data;
    private int writeWorkerCount = 0;
    private int readWorkerCount = 0;
    private PrintWriter statWriter;
    protected File journalDirectory = new File("journal-logs");
    protected File statCSVFile = new File("stats.csv");
    protected int writeWorkerIncrement = 5;
    protected int initialWriteWorkers = 5;
    protected int readWorkerThinkTime = 0;
    protected int readWorkerIncrement = 5;
    protected int initialReadWorkers = 5;
    protected int writeWorkerThinkTime = 0;
    protected long incrementDelay = 20000L;
    protected boolean verbose = true;
    protected int recordSize = 1024;
    protected int syncFrequency = 15;

    protected void exec() throws Exception {
        int i;
        System.out.println("Client threads write records using: Record Size: " + this.recordSize + ", Sync Frequency: " + this.syncFrequency + ", Worker Think Time: " + this.readWorkerThinkTime);
        this.data = new byte[this.recordSize];
        for (i = 0; i < this.data.length; ++i) {
            this.data[i] = (byte)i;
        }
        if (this.statCSVFile != null) {
            this.statWriter = new PrintWriter(new FileOutputStream(this.statCSVFile));
            this.statWriter.println("Threads,Write Throughput (k/s),Forced Write latency (ms), Write Throughput (records/s),Read Throughput (k/s),Read latency (ms),Read Throughput (records/s)");
        }
        if (this.journalDirectory.exists()) {
            JournalRWPerfToolSupport.deleteDir(this.journalDirectory);
        }
        this.journal = new JournalStatsFilter(this.createJournal()).enableDetailedStats(this.verbose);
        this.journal.setJournalEventListener(this);
        try {
            System.out.println("Starting " + this.initialWriteWorkers + " Write Workers...");
            for (i = 0; i < this.initialWriteWorkers; ++i) {
                new Thread(new WriteWorker()).start();
                ++this.writeWorkerCount;
            }
            System.out.println("Starting " + this.initialReadWorkers + " Read Workers...");
            for (i = 0; i < this.initialReadWorkers; ++i) {
                new Thread(new ReadWorker()).start();
                ++this.readWorkerCount;
            }
            block5: while (true) {
                System.out.println("Waiting " + this.incrementDelay / 1000L + " seconds before next Stat sample.");
                Thread.sleep(this.incrementDelay);
                this.displayStats();
                this.journal.reset();
                System.out.println("Starting " + this.writeWorkerIncrement + " Workers...");
                i = 0;
                while (true) {
                    if (i >= this.writeWorkerIncrement) continue block5;
                    new Thread(new WriteWorker()).start();
                    ++this.writeWorkerCount;
                    ++i;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            this.journal.close();
            throw throwable;
        }
    }

    private void displayStats() {
        System.out.println("Stats at " + this.writeWorkerCount + " write workers and " + this.readWorkerCount + " read workers.");
        System.out.println(this.journal);
        if (this.statWriter != null) {
            this.statWriter.println("" + this.writeWorkerCount + "," + this.journal.getWriteThroughputKps() + "," + this.journal.getAvgSyncedLatencyMs() + "," + this.journal.getWriteThroughputRps() + "," + this.journal.getReadThroughputKps() + "," + this.journal.getAvgReadLatencyMs() + "," + this.journal.getReadThroughputRps());
            this.statWriter.flush();
        }
    }

    public abstract Journal createJournal() throws Exception;

    private static void deleteDir(File f) {
        File[] files = f.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            file.delete();
        }
        f.delete();
    }

    public void overflowNotification(RecordLocation safeLocation) {
        try {
            this.journal.setMark(safeLocation, false);
        }
        catch (InvalidRecordLocationException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private final class ReadWorker
    implements Runnable {
        AtomicLong counter = new AtomicLong();

        private ReadWorker() {
        }

        public void run() {
            while (true) {
                try {
                    block3: while (true) {
                        RecordLocation pos = null;
                        while (true) {
                            if ((pos = JournalRWPerfToolSupport.this.journal.getNextRecordLocation(pos)) == null) continue block3;
                            Packet packet = JournalRWPerfToolSupport.this.journal.read(pos);
                            this.counter.addAndGet(packet.limit());
                            Thread.sleep(JournalRWPerfToolSupport.this.readWorkerThinkTime);
                        }
                        break;
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }

    private final class WriteWorker
    implements Runnable {
        private WriteWorker() {
        }

        public void run() {
            int i = JournalRWPerfToolSupport.this.random.nextInt() % JournalRWPerfToolSupport.this.syncFrequency;
            while (true) {
                boolean sync = false;
                if (JournalRWPerfToolSupport.this.syncFrequency >= 0 && i % JournalRWPerfToolSupport.this.syncFrequency == 0) {
                    sync = true;
                }
                try {
                    JournalRWPerfToolSupport.this.journal.write((Packet)new ByteArrayPacket(JournalRWPerfToolSupport.this.data), sync);
                    Thread.sleep(JournalRWPerfToolSupport.this.writeWorkerThinkTime);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
                ++i;
            }
        }
    }
}

