/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activeio.xnet.hba;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Properties;
import junit.framework.TestCase;
import org.apache.activeio.xnet.ServerService;
import org.apache.activeio.xnet.ServiceException;
import org.apache.activeio.xnet.hba.IPAddressPermission;
import org.apache.activeio.xnet.hba.IPAddressPermissionFactory;
import org.apache.activeio.xnet.hba.ServiceAccessController;

public class ServiceAccessControllerTest
extends TestCase {
    public void testWrongExactIPAddressPermission1() throws Exception {
        try {
            IPAddressPermissionFactory.getIPAddressMask((String)"121.122.123.a");
            ServiceAccessControllerTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testWrongExactIPAddressPermission2() throws Exception {
        try {
            IPAddressPermissionFactory.getIPAddressMask((String)"121.122.123.256");
            ServiceAccessControllerTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testExactIPAddressPermission() throws Exception {
        IPAddressPermission permission = IPAddressPermissionFactory.getIPAddressMask((String)"121.122.123.124");
        ServiceAccessControllerTest.assertTrue((boolean)permission.implies(InetAddress.getByAddress(new byte[]{121, 122, 123, 124})));
        ServiceAccessControllerTest.assertFalse((boolean)permission.implies(InetAddress.getByAddress(new byte[]{121, 122, 123, 125})));
    }

    public void testWrongStartWithIPAddressPermission1() throws Exception {
        try {
            IPAddressPermissionFactory.getIPAddressMask((String)"121.0.123.0");
            ServiceAccessControllerTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testStartWithIPAddressPermission() throws Exception {
        IPAddressPermission permission = IPAddressPermissionFactory.getIPAddressMask((String)"121.122.0.0");
        ServiceAccessControllerTest.assertTrue((boolean)permission.implies(InetAddress.getByAddress(new byte[]{121, 122, 123, 124})));
        ServiceAccessControllerTest.assertFalse((boolean)permission.implies(InetAddress.getByAddress(new byte[]{121, 123, 123, 124})));
    }

    public void testFactorizedIPAddressPermission() throws Exception {
        IPAddressPermission permission = IPAddressPermissionFactory.getIPAddressMask((String)"121.122.123.{1,2,3}");
        ServiceAccessControllerTest.assertTrue((boolean)permission.implies(InetAddress.getByAddress(new byte[]{121, 122, 123, 1})));
        ServiceAccessControllerTest.assertTrue((boolean)permission.implies(InetAddress.getByAddress(new byte[]{121, 122, 123, 2})));
        ServiceAccessControllerTest.assertTrue((boolean)permission.implies(InetAddress.getByAddress(new byte[]{121, 122, 123, 3})));
        ServiceAccessControllerTest.assertFalse((boolean)permission.implies(InetAddress.getByAddress(new byte[]{121, 122, 123, 4})));
        permission = IPAddressPermissionFactory.getIPAddressMask((String)"121.122.{1,2,3}");
        ServiceAccessControllerTest.assertTrue((boolean)permission.implies(InetAddress.getByAddress(new byte[]{121, 122, 1, 1})));
        ServiceAccessControllerTest.assertTrue((boolean)permission.implies(InetAddress.getByAddress(new byte[]{121, 122, 2, 2})));
        ServiceAccessControllerTest.assertTrue((boolean)permission.implies(InetAddress.getByAddress(new byte[]{121, 122, 3, 3})));
        ServiceAccessControllerTest.assertFalse((boolean)permission.implies(InetAddress.getByAddress(new byte[]{121, 122, 4, 3})));
    }

    public void testNetmaskIPAddressPermission() throws Exception {
        IPAddressPermission permission = IPAddressPermissionFactory.getIPAddressMask((String)"121.122.123.254/31");
        ServiceAccessControllerTest.assertTrue((boolean)permission.implies(InetAddress.getByAddress(new byte[]{121, 122, 123, -2})));
        ServiceAccessControllerTest.assertTrue((boolean)permission.implies(InetAddress.getByAddress(new byte[]{121, 122, 123, -1})));
        ServiceAccessControllerTest.assertFalse((boolean)permission.implies(InetAddress.getByAddress(new byte[]{121, 122, 123, -3})));
        permission = IPAddressPermissionFactory.getIPAddressMask((String)"121.122.123.254/255.255.255.254");
        ServiceAccessControllerTest.assertTrue((boolean)permission.implies(InetAddress.getByAddress(new byte[]{121, 122, 123, -2})));
        ServiceAccessControllerTest.assertTrue((boolean)permission.implies(InetAddress.getByAddress(new byte[]{121, 122, 123, -1})));
        ServiceAccessControllerTest.assertFalse((boolean)permission.implies(InetAddress.getByAddress(new byte[]{121, 122, 123, -3})));
    }

    public void testExactIPv6AddressPermission() throws Exception {
        IPAddressPermission permission = IPAddressPermissionFactory.getIPAddressMask((String)"101:102:103:104:105:106:107:108");
        ServiceAccessControllerTest.assertTrue((boolean)permission.implies(InetAddress.getByAddress(new byte[]{1, 1, 1, 2, 1, 3, 1, 4, 1, 5, 1, 6, 1, 7, 1, 8})));
        ServiceAccessControllerTest.assertFalse((boolean)permission.implies(InetAddress.getByAddress(new byte[]{1, 1, 1, 2, 1, 3, 1, 4, 1, 5, 1, 6, 1, 7, 1, 9})));
    }

    public void testNetmaskIPv6AddressPermission() throws Exception {
        IPAddressPermission permission = IPAddressPermissionFactory.getIPAddressMask((String)"101:102:103:104:105:106:107:FFFE/127");
        ServiceAccessControllerTest.assertTrue((boolean)permission.implies(InetAddress.getByAddress(new byte[]{1, 1, 1, 2, 1, 3, 1, 4, 1, 5, 1, 6, 1, 7, -1, -2})));
        ServiceAccessControllerTest.assertTrue((boolean)permission.implies(InetAddress.getByAddress(new byte[]{1, 1, 1, 2, 1, 3, 1, 4, 1, 5, 1, 6, 1, 7, -1, -1})));
        ServiceAccessControllerTest.assertFalse((boolean)permission.implies(InetAddress.getByAddress(new byte[]{1, 1, 1, 2, 1, 3, 1, 4, 1, 5, 1, 6, 1, 7, -1, -3})));
        permission = IPAddressPermissionFactory.getIPAddressMask((String)"101:102:103:104:105:106:107:FFFE/FFFF:FFFF:FFFF:FFFF:FFFF:FFFF:FFFF:FFFE");
        ServiceAccessControllerTest.assertTrue((boolean)permission.implies(InetAddress.getByAddress(new byte[]{1, 1, 1, 2, 1, 3, 1, 4, 1, 5, 1, 6, 1, 7, -1, -2})));
        ServiceAccessControllerTest.assertTrue((boolean)permission.implies(InetAddress.getByAddress(new byte[]{1, 1, 1, 2, 1, 3, 1, 4, 1, 5, 1, 6, 1, 7, -1, -1})));
        ServiceAccessControllerTest.assertFalse((boolean)permission.implies(InetAddress.getByAddress(new byte[]{1, 1, 1, 2, 1, 3, 1, 4, 1, 5, 1, 6, 1, 7, -1, -3})));
    }

    public void testServiceOKWithConstructor() throws Exception {
        IPAddressPermission[] masks = new IPAddressPermission[]{IPAddressPermissionFactory.getIPAddressMask((String)"121.122.{56,57}")};
        MockServerService mockServerService = new MockServerService();
        ServiceAccessController controller = new ServiceAccessController(null, (ServerService)mockServerService, masks);
        this.executeTestServiceOK(mockServerService, controller);
    }

    public void testServiceNOK() throws Exception {
        IPAddressPermission[] masks = new IPAddressPermission[]{IPAddressPermissionFactory.getIPAddressMask((String)"121.122.{56,57}")};
        MockServerService mockServerService = new MockServerService();
        ServiceAccessController controller = new ServiceAccessController(null, (ServerService)mockServerService, masks);
        this.executeTestServiceNOK(controller);
    }

    public void testServiceOKWithInit() throws Exception {
        Properties properties = new Properties();
        properties.put("only_from", "121.122.{56,57}");
        MockServerService mockServerService = new MockServerService();
        ServiceAccessController controller = new ServiceAccessController((ServerService)mockServerService);
        controller.init(properties);
        this.executeTestServiceOK(mockServerService, controller);
    }

    public void testServiceNOKWithInit() throws Exception {
        Properties properties = new Properties();
        properties.put("only_from", "121.122.{56,57}");
        MockServerService mockServerService = new MockServerService();
        ServiceAccessController controller = new ServiceAccessController((ServerService)mockServerService);
        controller.init(properties);
        this.executeTestServiceOK(mockServerService, controller);
    }

    private void executeTestServiceOK(MockServerService mockServerService, ServiceAccessController controller) throws UnknownHostException, ServiceException, IOException {
        MockSocket mockSocket = new MockSocket(InetAddress.getByAddress(new byte[]{121, 122, 56, 123}));
        controller.service((Socket)mockSocket);
        ServiceAccessControllerTest.assertSame((Object)mockSocket, (Object)mockServerService.socket);
        mockSocket = new MockSocket(InetAddress.getByAddress(new byte[]{121, 122, 57, 123}));
        controller.service((Socket)mockSocket);
        ServiceAccessControllerTest.assertSame((Object)mockSocket, (Object)mockServerService.socket);
    }

    private void executeTestServiceNOK(ServiceAccessController controller) throws UnknownHostException, ServiceException, IOException {
        MockSocket mockSocket = new MockSocket(InetAddress.getByAddress(new byte[]{121, 122, 58, 123}));
        try {
            controller.service((Socket)mockSocket);
            ServiceAccessControllerTest.fail();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    private static class MockServerService
    implements ServerService {
        private Socket socket;

        private MockServerService() {
        }

        public void init(Properties props) throws Exception {
        }

        public void start() throws ServiceException {
            throw new AssertionError();
        }

        public void stop() throws ServiceException {
            throw new AssertionError();
        }

        public String getIP() {
            throw new AssertionError();
        }

        public int getPort() {
            throw new AssertionError();
        }

        public void service(Socket socket) throws ServiceException, IOException {
            this.socket = socket;
        }

        public String getName() {
            throw new AssertionError();
        }
    }

    private static class MockSocket
    extends Socket {
        private final InetAddress address;

        private MockSocket(InetAddress address) {
            this.address = address;
        }

        public InetAddress getInetAddress() {
            return this.address;
        }
    }
}

