/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activeio.journal.active;

import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import org.apache.activeio.journal.InvalidRecordLocationException;
import org.apache.activeio.journal.RecordLocation;
import org.apache.activeio.journal.active.JournalImpl;
import org.apache.activeio.journal.active.Location;
import org.apache.activeio.packet.ByteArrayPacket;
import org.apache.activeio.packet.Packet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JournalImplTest
extends TestCase {
    Log log = LogFactory.getLog((Class)JournalImplTest.class);
    int size = 10240;
    int logFileCount = 2;
    File logDirectory = new File("test-logfile");
    private JournalImpl journal;

    protected void setUp() throws Exception {
        if (this.logDirectory.exists()) {
            this.deleteDir(this.logDirectory);
        }
        JournalImplTest.assertTrue((String)("Could not delete directory: " + this.logDirectory.getCanonicalPath()), (!this.logDirectory.exists() ? 1 : 0) != 0);
        this.journal = new JournalImpl(this.logDirectory, this.logFileCount, this.size, this.logDirectory);
    }

    private void deleteDir(File f) {
        File[] files = f.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            file.delete();
        }
        f.delete();
    }

    protected void tearDown() throws Exception {
        this.journal.close();
        if (this.logDirectory.exists()) {
            this.deleteDir(this.logDirectory);
        }
        JournalImplTest.assertTrue((!this.logDirectory.exists() ? 1 : 0) != 0);
    }

    public void testLogFileCreation() throws IOException {
        RecordLocation mark = this.journal.getMark();
        JournalImplTest.assertNull((Object)mark);
    }

    public void testAppendAndRead() throws InvalidRecordLocationException, InterruptedException, IOException {
        Packet data1 = this.createPacket("Hello World 1");
        RecordLocation location1 = this.journal.write(data1, false);
        Packet data2 = this.createPacket("Hello World 2");
        RecordLocation location2 = this.journal.write(data2, false);
        Packet data3 = this.createPacket("Hello World 3");
        RecordLocation location3 = this.journal.write(data3, false);
        Packet data = this.journal.read(location2);
        JournalImplTest.assertEquals(data2, data);
        data = this.journal.read(location1);
        JournalImplTest.assertEquals(data1, data);
        data = this.journal.read(location3);
        JournalImplTest.assertEquals(data3, data);
        RecordLocation l = this.journal.getNextRecordLocation(null);
        JournalImplTest.assertEquals((int)0, (int)l.compareTo((Object)location1));
        data = this.journal.read(l);
        JournalImplTest.assertEquals(data1, data);
        l = this.journal.getNextRecordLocation(l);
        JournalImplTest.assertEquals((int)0, (int)l.compareTo((Object)location2));
        data = this.journal.read(l);
        JournalImplTest.assertEquals(data2, data);
        l = this.journal.getNextRecordLocation(l);
        JournalImplTest.assertEquals((int)0, (int)l.compareTo((Object)location3));
        data = this.journal.read(l);
        JournalImplTest.assertEquals(data3, data);
        l = this.journal.getNextRecordLocation(l);
        JournalImplTest.assertNull((Object)l);
        this.log.info((Object)this.journal);
    }

    public void testCanReadFromArchivedLogFile() throws InvalidRecordLocationException, InterruptedException, IOException {
        Packet p;
        Location pos;
        Packet data1 = this.createPacket("Hello World 1");
        RecordLocation location1 = this.journal.write(data1, false);
        do {
            p = this.createPacket("<<<data>>>");
            pos = (Location)this.journal.write(p, false);
            this.journal.setMark((RecordLocation)pos, false);
        } while (pos.getLogFileId() < 5);
        p = this.createPacket("<<<data>>>");
        pos = (Location)this.journal.write(p, true);
        Packet data = this.journal.read(location1);
        JournalImplTest.assertEquals(data1, data);
    }

    private Packet createPacket(String string) {
        return new ByteArrayPacket(string.getBytes());
    }

    public static void assertEquals(Packet arg0, Packet arg1) {
        JournalImplTest.assertEquals(arg0.sliceAsBytes(), arg1.sliceAsBytes());
    }

    public static void assertEquals(byte[] arg0, byte[] arg1) {
        if (arg0 == null ^ arg1 == null) {
            JournalImplTest.fail((String)("Not equal: " + arg0 + " != " + arg1));
        }
        if (arg0 == null) {
            return;
        }
        if (arg0.length != arg1.length) {
            JournalImplTest.fail((String)("Array lenght not equal: " + arg0.length + " != " + arg1.length));
        }
        for (int i = 0; i < arg0.length; ++i) {
            if (arg0[i] == arg1[i]) continue;
            JournalImplTest.fail((String)("Array item not equal at index " + i + ": " + arg0[i] + " != " + arg1[i]));
        }
    }
}

