/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ace.identification.ifconfig;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.ace.identification.Identification;
import org.osgi.service.log.LogService;

public class IfconfigIdentification
implements Identification {
    private static final String IFCONFIG_COMMAND = "ifconfig";
    private static final String MAC_IDENTIFIER = "HWaddr ";
    private static final String IP_IDENTIFIER = "inet addr";
    private volatile LogService m_log;
    private String m_gatewayID = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String getID() {
        if (this.m_gatewayID == null) {
            BufferedReader reader = null;
            try {
                Process process = Runtime.getRuntime().exec(IFCONFIG_COMMAND);
                InputStream inputStream = process.getInputStream();
                reader = new BufferedReader(new InputStreamReader(inputStream));
                this.m_gatewayID = this.parseIfconfigOutput(reader).toLowerCase();
            }
            catch (IOException ioe) {
                this.m_log.log(2, "Unable to determine ifconfig based mac-address gateway identification.", (Throwable)ioe);
                String string = null;
                return string;
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        return this.m_gatewayID;
    }

    protected String parseIfconfigOutput(BufferedReader ifconfigOutput) throws IOException {
        String line;
        String previousLine = "";
        while ((line = ifconfigOutput.readLine()) != null) {
            if (line.indexOf(IP_IDENTIFIER) != -1 && previousLine.indexOf(MAC_IDENTIFIER) != -1) {
                String macAddress = previousLine.substring(previousLine.lastIndexOf(MAC_IDENTIFIER) + MAC_IDENTIFIER.length(), previousLine.length());
                if (this.isValidMac(macAddress = macAddress.trim())) {
                    return macAddress;
                }
                return null;
            }
            previousLine = line;
        }
        return null;
    }

    protected boolean isValidMac(String mac) {
        if (mac.length() != 17) {
            return false;
        }
        char[] chars = mac.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (!(i % 3 == 2 ? ':' != c : !('0' <= c && c <= '9' || 'a' <= c && c <= 'f' || 'A' <= c && c <= 'F'))) continue;
            return false;
        }
        return true;
    }
}

