/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ace.deployment.streamgenerator.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.apache.ace.connectionfactory.ConnectionFactory;
import org.apache.ace.deployment.provider.ArtifactData;
import org.apache.ace.deployment.provider.DeploymentProvider;
import org.apache.ace.deployment.streamgenerator.StreamGenerator;

public class StreamGeneratorImpl
implements StreamGenerator {
    private volatile DeploymentProvider m_provider;
    private volatile ConnectionFactory m_connectionFactory;

    public InputStream getDeploymentPackage(String id, String version) throws IOException {
        List data = this.m_provider.getBundleData(id, version);
        Manifest manifest = new Manifest();
        Attributes main = manifest.getMainAttributes();
        main.putValue("Manifest-Version", "1.0");
        main.putValue("DeploymentPackage-SymbolicName", id);
        main.putValue("DeploymentPackage-Version", version);
        for (ArtifactData bd : data) {
            manifest.getEntries().put(bd.getFilename(), bd.getManifestAttributes(false));
        }
        return DeploymentPackageStream.createStreamForThread(this.m_connectionFactory, manifest, data.iterator(), false);
    }

    public InputStream getDeploymentPackage(String id, String fromVersion, String toVersion) throws IOException {
        List data = this.m_provider.getBundleData(id, fromVersion, toVersion);
        Manifest manifest = new Manifest();
        Attributes main = manifest.getMainAttributes();
        main.putValue("Manifest-Version", "1.0");
        main.putValue("DeploymentPackage-SymbolicName", id);
        main.putValue("DeploymentPackage-Version", toVersion);
        main.putValue("DeploymentPackage-FixPack", "[" + fromVersion + "," + toVersion + ")");
        for (ArtifactData bd : data) {
            manifest.getEntries().put(bd.getFilename(), bd.getManifestAttributes(true));
        }
        return DeploymentPackageStream.createStreamForThread(this.m_connectionFactory, manifest, data.iterator(), true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DeploymentPackageStream
    extends InputStream {
        private byte[] m_readBuffer;
        private byte[] m_buffer;
        private JarOutputStream m_output;
        private Iterator<ArtifactData> m_iter;
        private InputStream m_current = null;
        private int m_pos = 0;
        private int m_max = 0;
        private boolean m_fixPack;
        private final OutputBuffer m_outputBuffer = new OutputBuffer(this);
        private final ConnectionFactory m_connectionFactory;
        private static final ThreadLocal<SoftReference<DeploymentPackageStream>> m_cache = new ThreadLocal();

        private DeploymentPackageStream(ConnectionFactory connectionFactory) {
            this(connectionFactory, 65536);
        }

        private DeploymentPackageStream(ConnectionFactory connectionFactory, int bufferSize) {
            this.m_connectionFactory = connectionFactory;
            this.m_buffer = new byte[bufferSize];
            this.m_readBuffer = new byte[bufferSize];
        }

        static DeploymentPackageStream createStreamForThread(ConnectionFactory connectionFactory, Manifest man, Iterator<ArtifactData> iter, boolean fixpack) throws IOException {
            SoftReference<DeploymentPackageStream> ref = m_cache.get();
            DeploymentPackageStream dps = null;
            if (ref != null) {
                dps = ref.get();
            }
            if (dps == null) {
                dps = new DeploymentPackageStream(connectionFactory);
                m_cache.set(new SoftReference<DeploymentPackageStream>(dps));
            }
            if (dps.isInUse()) {
                dps = new DeploymentPackageStream(connectionFactory);
            }
            dps.init(man, iter, fixpack);
            return dps;
        }

        private boolean isInUse() {
            return this.m_output == null;
        }

        private void init(Manifest man, Iterator<ArtifactData> iter, boolean fixPack) throws IOException {
            this.m_max = 0;
            this.m_pos = 0;
            this.m_output = new JarOutputStream((OutputStream)this.m_outputBuffer, man);
            this.m_output.flush();
            this.m_iter = iter;
            this.m_fixPack = fixPack;
            this.next();
        }

        private void next() throws IOException {
            ArtifactData current;
            ArtifactData artifactData = current = this.m_iter.hasNext() ? this.m_iter.next() : null;
            if (current == null) {
                this.m_output.close();
            } else if (!this.m_fixPack || current.hasChanged()) {
                this.m_current = this.openStream(current);
                this.m_output.putNextEntry(new ZipEntry(current.getFilename()));
            } else {
                this.next();
            }
        }

        private InputStream openStream(ArtifactData data) throws IOException {
            URLConnection conn = this.m_connectionFactory.createConnection(data.getUrl());
            return conn.getInputStream();
        }

        @Override
        public int read() throws IOException {
            while (this.m_pos == this.m_max) {
                if (this.m_current == null) {
                    if (this.m_output != null) {
                        this.m_output.close();
                    }
                    this.m_output = null;
                    this.m_iter = null;
                    return -1;
                }
                this.m_pos = 0;
                this.m_max = 0;
                int len = this.m_current.read(this.m_readBuffer);
                if (len != -1) {
                    this.m_output.write(this.m_readBuffer, 0, len);
                    this.m_output.flush();
                    continue;
                }
                try {
                    this.m_current.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.m_current = null;
                this.m_output.closeEntry();
                this.m_output.flush();
                this.next();
            }
            return this.m_buffer[this.m_pos++] & 0xFF;
        }

        void write(int b) {
            if (this.m_max == this.m_buffer.length) {
                byte[] tmp = new byte[this.m_buffer.length + 8192];
                System.arraycopy(this.m_buffer, 0, tmp, 0, this.m_buffer.length);
                this.m_buffer = tmp;
            }
            this.m_buffer[this.m_max++] = (byte)b;
        }

        @Override
        public void close() {
            if (this.m_output != null) {
                try {
                    this.m_output.close();
                    this.m_output = null;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (this.m_current != null) {
                try {
                    this.m_current.close();
                    this.m_current = null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.m_iter = null;
        }

        private static final class OutputBuffer
        extends OutputStream {
            private final DeploymentPackageStream m_stream;

            public OutputBuffer(DeploymentPackageStream stream) {
                this.m_stream = stream;
            }

            public void write(int b) {
                this.m_stream.write(b);
            }
        }
    }
}

