/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ace.deployment.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Dictionary;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.ace.deployment.processor.DeploymentProcessor;
import org.apache.ace.deployment.provider.DeploymentProvider;
import org.apache.ace.deployment.servlet.AceRestException;
import org.apache.ace.deployment.streamgenerator.StreamGenerator;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.log.LogService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentServlet
extends HttpServlet
implements ManagedService {
    private static final long serialVersionUID = 1L;
    public static final String CURRENT = "current";
    public static final String PROCESSOR = "processor";
    public static final String VERSIONS = "versions";
    public static final String DP_MIMETYPE = "application/vnd.osgi.dp";
    public static final String TEXT_MIMETYPE = "text/plain";
    private volatile LogService m_log;
    private volatile StreamGenerator m_streamGenerator;
    private volatile DeploymentProvider m_provider;
    private final ConcurrentHashMap<String, DeploymentProcessor> m_processors = new ConcurrentHashMap();

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            String[] pathElements = this.verifyAndGetPathElements(request.getPathInfo());
            String targetID = pathElements[1];
            List<String> versions = this.getVersions(targetID);
            int numberOfElements = pathElements.length;
            if (numberOfElements == 3) {
                this.handleVersionsRequest(versions, response);
            } else {
                String version = pathElements[3];
                this.handlePackageDelivery(targetID, version, versions, request, response);
            }
        }
        catch (AceRestException e) {
            this.m_log.log(2, e.getMessage(), (Throwable)e);
            e.handleAsHttpError(response);
        }
    }

    private void handleVersionsRequest(List<String> versions, HttpServletResponse response) throws AceRestException {
        ServletOutputStream output = null;
        response.setContentType(TEXT_MIMETYPE);
        try {
            output = response.getOutputStream();
            for (String version : versions) {
                output.print(version);
                output.print("\n");
            }
        }
        catch (IOException e) {
            throw new AceRestException(400, "Request URI is invalid");
        }
        finally {
            this.tryClose((OutputStream)output);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handlePackageDelivery(String targetID, String version, List<String> versions, HttpServletRequest request, HttpServletResponse response) throws AceRestException {
        InputStream inputStream;
        ServletOutputStream output = null;
        try {
            if (!versions.contains(version)) {
                throw new AceRestException(404, "Unknown version (" + version + ")");
            }
            String current = request.getParameter(CURRENT);
            String processor = request.getParameter(PROCESSOR);
            inputStream = current != null ? this.m_streamGenerator.getDeploymentPackage(targetID, current, version) : this.m_streamGenerator.getDeploymentPackage(targetID, version);
            if (processor != null) {
                DeploymentProcessor deploymentProcessor = this.m_processors.get(processor);
                if (deploymentProcessor == null) throw new AceRestException(500, "Could not find a deployment processor called: " + processor);
                deploymentProcessor.process(inputStream, request, response);
                this.tryClose((OutputStream)output);
                return;
            }
        }
        catch (IOException e) {
            try {
                throw new AceRestException(400, "Request URI is invalid");
            }
            catch (Throwable throwable) {
                this.tryClose((OutputStream)output);
                throw throwable;
            }
        }
        {
            response.setContentType(DP_MIMETYPE);
            output = response.getOutputStream();
            byte[] buffer = new byte[32768];
            int bytesRead = inputStream.read(buffer);
            while (true) {
                if (bytesRead == -1) {
                    this.tryClose((OutputStream)output);
                    return;
                }
                output.write(buffer, 0, bytesRead);
                bytesRead = inputStream.read(buffer);
            }
        }
    }

    private List<String> getVersions(String targetID) throws AceRestException {
        try {
            return this.m_provider.getVersions(targetID);
        }
        catch (IllegalArgumentException iae) {
            throw new AceRestException(404, "Unknown target (" + targetID + ")");
        }
        catch (IOException ioe) {
            this.m_log.log(2, "Error getting available versions.", (Throwable)ioe);
            throw new AceRestException(500, "Error getting available versions.");
        }
    }

    private void tryClose(OutputStream output) {
        try {
            if (output != null) {
                output.close();
            }
        }
        catch (IOException e) {
            this.m_log.log(2, "Exception trying to close stream after request. ", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private String[] verifyAndGetPathElements(String path) throws AceRestException {
        if (path == null) {
            throw new AceRestException(400, "Request URI is invalid");
        }
        String[] elements = path.split("/");
        int numberOfElements = elements.length;
        if (numberOfElements < 3 || numberOfElements > 4 || !VERSIONS.equals(elements[2])) {
            throw new AceRestException(400, "Request URI is invalid");
        }
        return elements;
    }

    public String getServletInfo() {
        return "Ace Deployment Servlet Endpoint";
    }

    public void updated(Dictionary settings) throws ConfigurationException {
    }

    public void addProcessor(ServiceReference ref, DeploymentProcessor processor) {
        String key = (String)ref.getProperty(PROCESSOR);
        if (key == null) {
            this.m_log.log(2, "Deployment processor ignored, required service property 'processor' is missing.");
            return;
        }
        this.m_processors.putIfAbsent(key, processor);
    }

    public void removeProcessor(ServiceReference ref, DeploymentProcessor processor) {
        String key = (String)ref.getProperty(PROCESSOR);
        if (key == null) {
            return;
        }
        this.m_processors.remove(key);
    }
}

