/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ace.deployment.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Dictionary;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.ace.deployment.provider.DeploymentProvider;
import org.apache.ace.deployment.servlet.AceRestException;
import org.apache.ace.deployment.streamgenerator.StreamGenerator;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.log.LogService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentServlet
extends HttpServlet
implements ManagedService {
    private static final long serialVersionUID = 1L;
    public static final String CURRENT = "current";
    public static final String VERSIONS = "versions";
    public static final String DP_MIMETYPE = "application/vnd.osgi.dp";
    public static final String TEXT_MIMETYPE = "text/plain";
    private volatile LogService m_log;
    private volatile StreamGenerator m_streamGenerator;
    private volatile DeploymentProvider m_provider;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            String[] pathElements = this.verifyAndGetPathElements(request.getPathInfo());
            String gatewayID = pathElements[1];
            List<String> versions = this.getVersions(gatewayID);
            int numberOfElements = pathElements.length;
            if (numberOfElements == 3) {
                this.handleVersionsRequest(versions, response);
            } else {
                String version = pathElements[3];
                this.handlePackageDelivery(gatewayID, version, versions, request, response);
            }
        }
        catch (AceRestException e) {
            this.m_log.log(2, e.getMessage(), (Throwable)e);
            e.handleAsHttpError(response);
        }
    }

    private void handleVersionsRequest(List<String> versions, HttpServletResponse response) throws AceRestException {
        ServletOutputStream output = null;
        response.setContentType(TEXT_MIMETYPE);
        try {
            output = response.getOutputStream();
            for (String version : versions) {
                output.print(version);
                output.print("\n");
            }
        }
        catch (IOException e) {
            throw new AceRestException(400, "Request URI is invalid");
        }
        finally {
            this.tryClose((OutputStream)output);
        }
    }

    private void handlePackageDelivery(String gatewayID, String version, List<String> versions, HttpServletRequest request, HttpServletResponse response) throws AceRestException {
        ServletOutputStream output = null;
        response.setContentType(TEXT_MIMETYPE);
        try {
            output = response.getOutputStream();
            if (!versions.contains(version)) {
                throw new AceRestException(404, "Unknown version (" + version + ")");
            }
            String current = request.getParameter(CURRENT);
            InputStream inputStream = current != null ? this.m_streamGenerator.getDeploymentPackage(gatewayID, current, version) : this.m_streamGenerator.getDeploymentPackage(gatewayID, version);
            response.setContentType(DP_MIMETYPE);
            byte[] buffer = new byte[32768];
            int bytesRead = inputStream.read(buffer);
            while (bytesRead != -1) {
                output.write(buffer, 0, bytesRead);
                bytesRead = inputStream.read(buffer);
            }
        }
        catch (IOException e) {
            throw new AceRestException(400, "Request URI is invalid");
        }
        finally {
            this.tryClose((OutputStream)output);
        }
    }

    private List<String> getVersions(String gatewayID) throws AceRestException {
        try {
            return this.m_provider.getVersions(gatewayID);
        }
        catch (IllegalArgumentException iae) {
            throw new AceRestException(404, "Unknown gateway (" + gatewayID + ")");
        }
        catch (IOException ioe) {
            this.m_log.log(2, "Error getting available versions.", (Throwable)ioe);
            throw new AceRestException(500, "Error getting available versions.");
        }
    }

    private void tryClose(OutputStream output) {
        try {
            if (output != null) {
                output.close();
            }
        }
        catch (IOException e) {
            this.m_log.log(2, "Exception trying to close stream after request. ", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private String[] verifyAndGetPathElements(String path) throws AceRestException {
        if (path == null) {
            throw new AceRestException(400, "Request URI is invalid");
        }
        String[] elements = path.split("/");
        int numberOfElements = elements.length;
        if (numberOfElements < 3 || numberOfElements > 4 || !VERSIONS.equals(elements[2])) {
            throw new AceRestException(400, "Request URI is invalid");
        }
        return elements;
    }

    public String getServletInfo() {
        return "Ace Deployment Servlet Endpoint";
    }

    public void updated(Dictionary settings) throws ConfigurationException {
    }
}

