/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ace.deployment.provider.impl;

import java.net.URL;
import java.util.Map;
import java.util.jar.Attributes;
import org.apache.ace.deployment.provider.ArtifactData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtifactDataImpl
implements ArtifactData {
    public static final String HEADER_NAME = "Name";
    public static final String CUSTOMIZER = "DeploymentPackage-Customizer";
    public static final String PROCESSORPID = "Resource-Processor";
    private final String m_filename;
    private final String m_symbolicName;
    private final String m_version;
    private final Map<String, String> m_directives;
    private final URL m_url;
    private volatile boolean m_hasChanged;

    public ArtifactDataImpl(URL url, Map<String, String> directives, String symbolicName, String version, boolean hasChanged) {
        this(url, symbolicName, version, null, directives, hasChanged);
    }

    public ArtifactDataImpl(URL url, Map<String, String> directives, boolean hasChanged) {
        this(url, null, null, null, directives, hasChanged);
    }

    public ArtifactDataImpl(String filename, String symbolicName, String version, URL url, boolean hasChanged) {
        this(url, symbolicName, version, filename, null, hasChanged);
    }

    private ArtifactDataImpl(URL url, String symbolicName, String version, String filename, Map<String, String> directives, boolean hasChanged) {
        String urlString;
        this.m_url = url;
        this.m_filename = filename != null ? filename : ((urlString = this.m_url.toString()) == null ? null : urlString.substring(urlString.lastIndexOf(47) + 1));
        for (byte b : this.m_filename.getBytes()) {
            if (b >= 65 && b <= 90 || b >= 97 && b <= 122 || b >= 48 && b <= 57 || b == 46 || b == 45 || b == 95) continue;
            throw new IllegalArgumentException("Filename " + this.m_filename + " " + (filename == null ? "constructed from the url" : "") + " contains an illegal character '" + new String(new byte[]{b}) + "'");
        }
        this.m_symbolicName = symbolicName;
        this.m_version = version == null || version.trim().length() == 0 ? "0.0.0" : version;
        this.m_directives = directives;
        this.m_hasChanged = hasChanged;
    }

    public String getFilename() {
        return this.m_filename;
    }

    public String getSymbolicName() {
        return this.m_symbolicName;
    }

    public String getVersion() {
        return this.m_version;
    }

    public String getProcessorPid() {
        if (this.m_directives != null) {
            return this.m_directives.get(PROCESSORPID);
        }
        return null;
    }

    public URL getUrl() {
        return this.m_url;
    }

    public boolean hasChanged() {
        return this.m_hasChanged;
    }

    public void setChanged(boolean hasChanged) {
        this.m_hasChanged = hasChanged;
    }

    public boolean equals(Object other) {
        if (!(other instanceof ArtifactDataImpl)) {
            return false;
        }
        ArtifactDataImpl jarFile2 = (ArtifactDataImpl)other;
        if (this.getSymbolicName() != null) {
            return this.getSymbolicName().equals(jarFile2.getSymbolicName()) && this.getVersion().equals(jarFile2.getVersion());
        }
        return this.m_url.equals(jarFile2.getUrl());
    }

    public int hashCode() {
        int result = 11;
        if (this.getSymbolicName() != null) {
            result ^= this.getSymbolicName().hashCode();
        }
        result ^= this.getVersion().hashCode();
        return result ^= this.getUrl().hashCode();
    }

    public Attributes getManifestAttributes(boolean fixPackage) {
        Attributes a = new Attributes();
        if (!this.isBundle()) {
            a.putValue(PROCESSORPID, this.getProcessorPid());
        } else {
            a.putValue("Bundle-SymbolicName", this.getSymbolicName());
            a.putValue("Bundle-Version", this.getVersion());
            if (this.isCustomizer()) {
                a.putValue(CUSTOMIZER, "true");
            }
        }
        if (!this.hasChanged() && fixPackage) {
            a.putValue("DeploymentPackage-Missing", "true");
        }
        return a;
    }

    public boolean isCustomizer() {
        return this.m_directives != null && "true".equals(this.m_directives.get(CUSTOMIZER));
    }

    public boolean isBundle() {
        return this.getSymbolicName() != null;
    }
}

