/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ace.deployment.provider.filebased;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipInputStream;
import org.apache.ace.deployment.provider.ArtifactData;
import org.apache.ace.deployment.provider.DeploymentProvider;
import org.apache.ace.deployment.provider.impl.ArtifactDataImpl;
import org.osgi.framework.Version;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.log.LogService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileBasedProvider
implements DeploymentProvider,
ManagedService {
    private static final String DIRECTORY_NAME = "BaseDirectoryName";
    private static final String DEFAULT_DIRECTORY_NAME = "DefaultDirectoryName";
    private static final int OSGI_R4_MANIFEST_VERSION = 2;
    private volatile File m_baseDirectory;
    private volatile File m_defaultDirectory;
    private volatile LogService m_log;
    private final Semaphore m_disk = new Semaphore(1, true);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ArtifactData> getBundleData(String gatewayId, String version) throws IllegalArgumentException {
        List<String> versions = this.getVersions(gatewayId);
        if (!versions.contains(version)) {
            throw new IllegalArgumentException("Unknown version " + version + " requested");
        }
        File gatewayDirectory = new File(this.m_baseDirectory, gatewayId);
        File versionDirectory = gatewayDirectory.isDirectory() ? this.findMatchingVersionDirectory(gatewayDirectory, version) : this.findMatchingVersionDirectory(this.m_defaultDirectory, version);
        ArrayList<ArtifactData> bundleData = new ArrayList<ArtifactData>();
        ZipInputStream jarInputStream = null;
        File[] jarFiles = versionDirectory.listFiles();
        for (int i = 0; i < jarFiles.length; ++i) {
            Manifest bundleManifest = null;
            File jarFile = jarFiles[i];
            try {
                jarInputStream = new JarInputStream(new FileInputStream(jarFile));
                bundleManifest = ((JarInputStream)jarInputStream).getManifest();
            }
            catch (IOException ioe) {
                this.m_log.log(2, "Error making inputstream", (Throwable)ioe);
                continue;
            }
            finally {
                if (jarInputStream != null) {
                    try {
                        jarInputStream.close();
                    }
                    catch (Exception ioe) {
                        this.m_log.log(1, "Error closing the file input stream", (Throwable)ioe);
                    }
                }
            }
            Attributes mainAttributes = bundleManifest.getMainAttributes();
            String manifestVersion = mainAttributes.getValue("Bundle-ManifestVersion");
            String symbolicName = mainAttributes.getValue("Bundle-SymbolicName");
            String bundleVersion = mainAttributes.getValue("Bundle-Version");
            if (manifestVersion != null && symbolicName != null && bundleVersion != null) {
                if (2 != new Integer(manifestVersion)) {
                    this.m_log.log(2, "Invalid bundle:" + jarFile.getAbsolutePath() + " has the wrong manifest version.");
                    continue;
                }
                if (symbolicName.trim().equals("")) {
                    this.m_log.log(2, "Invalid bundle:" + jarFile.getAbsolutePath() + " the symbolic name is empty.");
                    continue;
                }
                try {
                    new Version(bundleVersion);
                    URL bundleUrl = new URL(null, jarFile.toURI().toURL().toString(), new URLStreamHandler(){

                        protected URLConnection openConnection(final URL u) throws IOException {
                            return new URLConnection(u){

                                public void connect() throws IOException {
                                }

                                public InputStream getInputStream() throws IOException {
                                    InputStream parent;
                                    try {
                                        parent = new URL(u.toURI().toURL().toString()).openStream();
                                    }
                                    catch (URISyntaxException ex) {
                                        throw new IOException(ex.getMessage());
                                    }
                                    return new InputStream(){

                                        public int read() throws IOException {
                                            return parent.read();
                                        }

                                        public int read(byte[] buffer) throws IOException {
                                            return this.read(buffer, 0, buffer.length);
                                        }

                                        /*
                                         * WARNING - Removed try catching itself - possible behaviour change.
                                         */
                                        public int read(byte[] buffer, int off, int length) throws IOException {
                                            FileBasedProvider.this.m_disk.acquireUninterruptibly();
                                            try {
                                                int n = parent.read(buffer, off, length);
                                                return n;
                                            }
                                            finally {
                                                FileBasedProvider.this.m_disk.release();
                                            }
                                        }

                                        public void close() throws IOException {
                                            parent.close();
                                        }
                                    };
                                }
                            };
                        }
                    });
                    bundleData.add(new ArtifactDataImpl(jarFile.getName(), symbolicName, bundleVersion, bundleUrl, true));
                }
                catch (IllegalArgumentException iae) {
                    this.m_log.log(2, "Invalid bundle:" + jarFile.getAbsolutePath() + " has an illegal version", (Throwable)iae);
                }
                catch (MalformedURLException mue) {
                    this.m_log.log(2, "Invalid bundle:" + jarFile.getAbsolutePath() + " unable to convert path to URL", (Throwable)mue);
                }
                continue;
            }
            this.m_log.log(2, "Invalid bundle:" + jarFile.getAbsolutePath() + " is missing required attributes");
        }
        return bundleData;
    }

    private File findMatchingVersionDirectory(File gatewayDirectory, String version) {
        Version requestedVersion;
        File directTry = new File(gatewayDirectory, version);
        if (directTry != null && directTry.isDirectory()) {
            return directTry;
        }
        try {
            requestedVersion = Version.parseVersion((String)version);
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException("Requested version " + version + " has no matching folder in store: " + gatewayDirectory.getAbsolutePath());
        }
        File[] files = gatewayDirectory.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File possibleVersionDirectory = files[i];
            if (!possibleVersionDirectory.isDirectory()) continue;
            try {
                Version foundVersion = Version.parseVersion((String)possibleVersionDirectory.getName());
                if (requestedVersion == null || !requestedVersion.equals((Object)foundVersion)) continue;
                return new File(gatewayDirectory, possibleVersionDirectory.getName());
            }
            catch (IllegalArgumentException iae) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException("Requested version " + version + " has no matching folder in store: " + gatewayDirectory.getAbsolutePath());
    }

    public List<ArtifactData> getBundleData(String gatewayId, String versionFrom, String versionTo) throws IllegalArgumentException {
        List<ArtifactData> dataVersionFrom = this.getBundleData(gatewayId, versionFrom);
        List<ArtifactData> dataVersionTo = this.getBundleData(gatewayId, versionTo);
        Iterator<ArtifactData> it = dataVersionTo.iterator();
        while (it.hasNext()) {
            ArtifactData bundleDataVersionFrom;
            ArtifactDataImpl bundleDataVersionTo;
            bundleDataVersionTo.setChanged(!(bundleDataVersionTo = (ArtifactDataImpl)it.next()).equals(bundleDataVersionFrom = this.getBundleData(bundleDataVersionTo.getSymbolicName(), dataVersionFrom)));
        }
        return dataVersionTo;
    }

    private ArtifactData getBundleData(String symbolicName, Collection<ArtifactData> data) {
        for (ArtifactData bundle : data) {
            if (!bundle.getSymbolicName().equals(symbolicName)) continue;
            return bundle;
        }
        return null;
    }

    public List<String> getVersions(String gatewayId) throws IllegalArgumentException {
        ArrayList<Version> versionList = new ArrayList<Version>();
        File gatewayDirectory = new File(this.m_baseDirectory.getAbsolutePath(), gatewayId);
        if (gatewayDirectory.isDirectory()) {
            this.getVersions(gatewayId, versionList, gatewayDirectory);
        } else {
            this.getVersions(gatewayId, versionList, this.m_defaultDirectory);
        }
        Collections.sort(versionList);
        ArrayList<String> stringVersionList = new ArrayList<String>();
        Iterator it = versionList.iterator();
        while (it.hasNext()) {
            String version = ((Version)it.next()).toString();
            stringVersionList.add(version);
        }
        return stringVersionList;
    }

    private void getVersions(String gatewayId, List<Version> versionList, File base) {
        File[] files = base.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File possibleVersionDirectory = files[i];
            if (!possibleVersionDirectory.isDirectory()) continue;
            try {
                Version version = Version.parseVersion((String)possibleVersionDirectory.getName());
                if (version.equals((Object)Version.emptyVersion)) continue;
                versionList.add(version);
                continue;
            }
            catch (IllegalArgumentException iae) {
                // empty catch block
            }
        }
        if (files.length == 0) {
            this.m_log.log(4, "No versions found for gateway " + gatewayId);
        }
    }

    public void updated(Dictionary settings) throws ConfigurationException {
        if (settings != null) {
            File defaultDirectory;
            String baseDirectoryName = this.getNotNull(settings, DIRECTORY_NAME, "The base directory cannot be null");
            File baseDirectory = new File(baseDirectoryName);
            if (!baseDirectory.exists() || !baseDirectory.isDirectory()) {
                throw new ConfigurationException(DIRECTORY_NAME, "The directory called '" + baseDirectoryName + "' " + (baseDirectory.exists() ? "is no directory." : "doesn't exist."));
            }
            this.m_baseDirectory = baseDirectory;
            String defaultDirectoryName = (String)settings.get(DEFAULT_DIRECTORY_NAME);
            if (defaultDirectoryName != null && (defaultDirectory = new File(defaultDirectoryName)).exists() && defaultDirectory.isDirectory()) {
                this.m_defaultDirectory = defaultDirectory;
                return;
            }
            this.m_defaultDirectory = baseDirectory;
        }
    }

    private String getNotNull(Dictionary settings, String id, String errorMessage) throws ConfigurationException {
        String result = (String)settings.get(id);
        if (result == null) {
            throw new ConfigurationException(id, errorMessage);
        }
        return result;
    }
}

